/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.oa.service.impl;

import com.centit.product.oa.dao.WorkDayDao;
import com.centit.product.oa.po.WorkDay;
import com.centit.product.oa.service.WorkDayManager;
import com.centit.support.algorithm.DatetimeOpt;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WorkDayManagerImpl
implements WorkDayManager {
    private static Logger logger = LoggerFactory.getLogger(WorkDayManagerImpl.class);
    @Resource
    private WorkDayDao workDayDao;

    @Override
    public boolean isWorkDay(String sWorkDay) {
        boolean result = false;
        Date workDay = DatetimeOpt.smartPraseDate((String)sWorkDay);
        WorkDay day = (WorkDay)this.workDayDao.getObjectById(WorkDay.toWorkDayId(workDay));
        if (day == null) {
            if (DatetimeOpt.getDayOfWeek((Date)workDay) > 0 && DatetimeOpt.getDayOfWeek((Date)workDay) < 6) {
                result = true;
            }
        } else if (WorkDay.WORK_DAY_TYPE_SHIFT.equals(day.getDayType())) {
            result = true;
        } else if (WorkDay.WORK_DAY_TYPE_WORKDAY.equals(day.getDayType()) && DatetimeOpt.getDayOfWeek((Date)workDay) > 0 && DatetimeOpt.getDayOfWeek((Date)workDay) < 6) {
            result = true;
        }
        return result;
    }

    @Override
    public void saveWorkDay(WorkDay workDay) {
        workDay.setWorkDay(WorkDay.toWorkDayId(workDay.getWorkDay()));
        this.workDayDao.saveNewObject(workDay);
    }

    @Override
    public void updateWorkDay(WorkDay workDay) {
        workDay.setWorkDay(WorkDay.toWorkDayId(workDay.getWorkDay()));
        this.workDayDao.updateObject(workDay);
    }

    @Override
    public void deleteWorkDay(String currDate) {
        this.workDayDao.deleteObjectById(WorkDay.toWorkDayId(currDate));
    }

    @Override
    public WorkDay getWorkDay(String currDate) {
        return (WorkDay)this.workDayDao.getObjectById(WorkDay.toWorkDayId(currDate));
    }

    @Override
    public List<WorkDay> listWorkDays(String sStartDate, String sEndDate) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("startDate", WorkDay.toWorkDayId(sStartDate));
        paramsMap.put("endDate", WorkDay.toWorkDayId(sEndDate));
        return this.workDayDao.listObjects(paramsMap);
    }

    @Override
    public int calcHolidays(String sStartDate, String sEndDate) {
        Date startDate = DatetimeOpt.smartPraseDate((String)sStartDate);
        Date endDate = DatetimeOpt.smartPraseDate((String)sEndDate);
        int holidays = DatetimeOpt.calcWeekendDays((Date)startDate, (Date)endDate);
        List<WorkDay> list = this.listWorkDays(sStartDate, sEndDate);
        if (null != list) {
            for (WorkDay workDay : list) {
                Date workDate = WorkDay.toWorkDayDate(workDay.getWorkDay());
                if (WorkDay.WORK_DAY_TYPE_HOLIDAY.equals(workDay.getDayType()) && DatetimeOpt.getDayOfWeek((Date)workDate) > 0 && DatetimeOpt.getDayOfWeek((Date)workDate) < 6) {
                    ++holidays;
                    continue;
                }
                if (!WorkDay.WORK_DAY_TYPE_SHIFT.equals(workDay.getDayType()) || DatetimeOpt.getDayOfWeek((Date)workDate) != 0 && DatetimeOpt.getDayOfWeek((Date)workDate) != 6) continue;
                --holidays;
            }
        }
        return holidays;
    }

    @Override
    public int calcWorkDays(String sStartDate, String sEndDate) {
        Date startDate = DatetimeOpt.smartPraseDate((String)sStartDate);
        Date endDate = DatetimeOpt.smartPraseDate((String)sEndDate);
        int spanDays = DatetimeOpt.calcSpanDays((Date)startDate, (Date)endDate);
        int holidays = this.calcHolidays(sStartDate, sStartDate);
        return spanDays - holidays;
    }

    @Override
    public List<WorkDay> rangeHolidays(String sStartDate, String sEndDate) {
        List<WorkDay> list = this.listWorkDays(sStartDate, sEndDate);
        int i = 0;
        int l = list == null ? 0 : list.size();
        Date startDate = DatetimeOpt.smartPraseDate((String)sStartDate);
        Date endDate = DatetimeOpt.smartPraseDate((String)sEndDate);
        ArrayList<WorkDay> workDays = new ArrayList<WorkDay>(16);
        Date s = startDate;
        while (DatetimeOpt.compareTwoDate((Date)s, (Date)endDate) < 1) {
            int day;
            int c;
            boolean specil = false;
            if (i < l && (c = DatetimeOpt.compareTwoDate((Date)s, (Date)list.get(i).getWorkDate())) == 0) {
                if (WorkDay.WORK_DAY_TYPE_HOLIDAY.equals(list.get(i).getDayType())) {
                    workDays.add((WorkDay)workDays.get(i));
                }
                specil = true;
                ++i;
            }
            if (!(specil || (day = DatetimeOpt.getDayOfWeek((Date)s)) != 0 && day != 6)) {
                WorkDay workDay = new WorkDay();
                workDay.setWorkDay(WorkDay.toWorkDayId(s));
                workDay.setDayType(WorkDay.WORK_DAY_TYPE_WEEKEND);
            }
            s = DatetimeOpt.addDays((Date)s, (int)1);
        }
        return workDays;
    }

    @Override
    public List<WorkDay> rangeWorkDays(String sStartDate, String sEndDate) {
        Date startDate = DatetimeOpt.smartPraseDate((String)sStartDate);
        Date endDate = DatetimeOpt.smartPraseDate((String)sEndDate);
        List<WorkDay> list = this.listWorkDays(sStartDate, sEndDate);
        int i = 0;
        int l = list == null ? 0 : list.size();
        ArrayList<WorkDay> workDays = new ArrayList<WorkDay>(32);
        Date s = startDate;
        while (DatetimeOpt.compareTwoDate((Date)s, (Date)endDate) < 1) {
            int day;
            int c;
            boolean specil = false;
            if (i < l && (c = DatetimeOpt.compareTwoDate((Date)s, (Date)list.get(i).getWorkDate())) == 0) {
                if (WorkDay.WORK_DAY_TYPE_SHIFT.equals(list.get(i).getDayType())) {
                    workDays.add((WorkDay)workDays.get(i));
                }
                specil = true;
                ++i;
            }
            if (!specil && (day = DatetimeOpt.getDayOfWeek((Date)s)) != 0 && day != 6) {
                WorkDay workDay = new WorkDay();
                workDay.setWorkDay(WorkDay.toWorkDayId(s));
                workDay.setDayType(WorkDay.WORK_DAY_TYPE_WORKDAY);
            }
            s = DatetimeOpt.addDays((Date)s, (int)1);
        }
        return workDays;
    }
}

