/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.controller.SmartDateFormat;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.framework.system.po.ESOperationLog;
import com.centit.framework.system.service.OperationLogManager;
import com.centit.search.document.DocumentUtils;
import com.centit.search.document.ESDocument;
import com.centit.search.service.ESServerConfig;
import com.centit.search.service.Impl.ESIndexer;
import com.centit.search.service.Impl.ESSearcher;
import com.centit.search.service.IndexerSearcherFactory;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="optLogManager")
public class ElkOptLogManager
implements OperationLogManager {
    public static final Logger logger = LoggerFactory.getLogger(ElkOptLogManager.class);
    private ESIndexer elkOptLogIndexer;
    private ESSearcher elkOptLogSearcher;
    private ESServerConfig esServerConfig;

    @Autowired
    public ElkOptLogManager(@Autowired ESServerConfig esServerConfig) {
        this.esServerConfig = esServerConfig;
        this.elkOptLogIndexer = IndexerSearcherFactory.obtainIndexer((ESServerConfig)esServerConfig, ESOperationLog.class);
        this.elkOptLogSearcher = IndexerSearcherFactory.obtainSearcher((ESServerConfig)esServerConfig, ESOperationLog.class);
    }

    public void save(OperationLog operationLog) {
        if (StringUtils.isBlank((CharSequence)operationLog.getTopUnit())) {
            return;
        }
        ESOperationLog esOperationLog = ESOperationLog.fromOperationLog(operationLog, null);
        if (this.elkOptLogIndexer.saveNewDocument((ESDocument)esOperationLog) == null) {
            throw new ObjectException(500, "elasticsearch\u64cd\u4f5c\u5931\u8d25");
        }
    }

    public void save(List<OperationLog> optLogs) {
        if (optLogs != null && optLogs.size() > 0) {
            for (OperationLog optLog : optLogs) {
                this.save(optLog);
            }
        }
    }

    public List<OperationLog> listOptLog(String optId, Map<String, Object> filterMap, int startPos, int maxRows) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        this.publicbuild(optId, filterMap, boolQueryBuilder);
        Pair longListPair = this.elkOptLogSearcher.esSearch((QueryBuilder)boolQueryBuilder, startPos, maxRows);
        ArrayList<OperationLog> operationLogList = new ArrayList<OperationLog>();
        if (longListPair != null) {
            for (Map objectMap : (List)longListPair.getValue()) {
                OperationLog operationLog = (OperationLog)JSONObject.parseObject((String)StringBaseOpt.castObjectToString((Object)objectMap), OperationLog.class);
                operationLogList.add(operationLog);
            }
        }
        return operationLogList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countOptLog(String optId, Map<String, Object> filter) {
        block7: {
            int n;
            block6: {
                GenericObjectPool restHighLevelClientGenericObjectPool = IndexerSearcherFactory.obtainclientPool((ESServerConfig)this.esServerConfig);
                RestHighLevelClient restHighLevelClient = null;
                try {
                    String indexName = DocumentUtils.obtainDocumentIndexName(ESOperationLog.class);
                    CountRequest countRequest = new CountRequest(new String[]{indexName});
                    SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
                    BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
                    this.publicbuild(optId, filter, boolQueryBuilder);
                    searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
                    countRequest.source(searchSourceBuilder);
                    restHighLevelClient = (RestHighLevelClient)restHighLevelClientGenericObjectPool.borrowObject();
                    CountResponse countResponse = restHighLevelClient.count(countRequest, RequestOptions.DEFAULT);
                    n = (int)countResponse.getCount();
                    if (restHighLevelClient == null) break block6;
                }
                catch (Exception e) {
                    logger.error("\u7edf\u8ba1\u6570\u91cf\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
                    break block7;
                }
                finally {
                    if (restHighLevelClient != null) {
                        restHighLevelClientGenericObjectPool.returnObject(restHighLevelClient);
                    }
                }
                restHighLevelClientGenericObjectPool.returnObject((Object)restHighLevelClient);
            }
            return n;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationLog getOptLogById(String logId) {
        block7: {
            OperationLog operationLog;
            block6: {
                GenericObjectPool clientPool = IndexerSearcherFactory.obtainclientPool((ESServerConfig)this.esServerConfig);
                RestHighLevelClient restHighLevelClient = null;
                try {
                    String indexName = DocumentUtils.obtainDocumentIndexName(ESOperationLog.class);
                    SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
                    SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
                    TermQueryBuilder termQuery = QueryBuilders.termQuery((String)"logId", (String)logId);
                    searchSourceBuilder.query((QueryBuilder)termQuery);
                    searchRequest.source(searchSourceBuilder);
                    restHighLevelClient = (RestHighLevelClient)clientPool.borrowObject();
                    SearchResponse searchResponse = restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
                    SearchHit[] hits = searchResponse.getHits().getHits();
                    String sourceAsString = hits[0].getSourceAsString();
                    OperationLog operationLog2 = (OperationLog)JSONObject.parseObject((String)sourceAsString, OperationLog.class);
                    operationLog2.setLogId(hits[0].getId());
                    operationLog = operationLog2;
                    if (restHighLevelClient == null) break block6;
                }
                catch (Exception e) {
                    logger.error("\u67e5\u8be2\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
                    break block7;
                }
                finally {
                    if (restHighLevelClient != null) {
                        clientPool.returnObject(restHighLevelClient);
                    }
                }
                clientPool.returnObject((Object)restHighLevelClient);
            }
            return operationLog;
        }
        return null;
    }

    public void deleteOptLogById(String logId) {
        if (!this.elkOptLogIndexer.deleteDocument(logId)) {
            throw new ObjectException(500, "elasticsearch\u64cd\u4f5c\u5931\u8d25");
        }
    }

    public void deleteMany(String[] logIds) {
        if (logIds != null) {
            for (String logId : logIds) {
                this.deleteObjectById(logId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray listOptLogsAsJson(String[] fields, Map<String, Object> filterMap, PageDesc pageDesc) {
        block9: {
            JSONArray jSONArray;
            block8: {
                GenericObjectPool clientPool = IndexerSearcherFactory.obtainclientPool((ESServerConfig)this.esServerConfig);
                RestHighLevelClient restHighLevelClient = null;
                try {
                    String indexName = DocumentUtils.obtainDocumentIndexName(ESOperationLog.class);
                    SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
                    SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
                    BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
                    if (fields != null && fields.length > 0) {
                        searchSourceBuilder.fetchSource(fields, null);
                    }
                    this.publicbuild(null, filterMap, boolQueryBuilder);
                    searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
                    searchSourceBuilder.explain(Boolean.valueOf(true));
                    searchSourceBuilder.from(pageDesc.getPageNo() > 1 ? (pageDesc.getPageNo() - 1) * pageDesc.getPageSize() : 0);
                    searchSourceBuilder.size(pageDesc.getPageSize());
                    searchRequest.source(searchSourceBuilder);
                    restHighLevelClient = (RestHighLevelClient)clientPool.borrowObject();
                    SearchResponse searchResponse = restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
                    SearchHit[] hits = searchResponse.getHits().getHits();
                    JSONArray result = new JSONArray();
                    for (SearchHit hit : hits) {
                        String sourceAsString = hit.getSourceAsString();
                        OperationLog esOperationLog = (OperationLog)JSONObject.parseObject((String)sourceAsString, OperationLog.class);
                        esOperationLog.setLogId(hit.getId());
                        JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)esOperationLog);
                        jsonObject.put((Object)"userName", (Object)CodeRepositoryUtil.getValue((String)"userCode", (String)esOperationLog.getUserCode(), (String)"all", (String)"zh_CN"));
                        result.add((Object)jsonObject);
                    }
                    SearchSourceBuilder sourceBuilderCount = new SearchSourceBuilder();
                    CountRequest countRequest = new CountRequest(new String[]{indexName});
                    BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
                    this.publicbuild(null, filterMap, boolQuery);
                    sourceBuilderCount.query((QueryBuilder)boolQuery);
                    countRequest.source(sourceBuilderCount);
                    CountResponse countResponse = restHighLevelClient.count(countRequest, RequestOptions.DEFAULT);
                    pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)countResponse.getCount()));
                    jSONArray = result;
                    if (restHighLevelClient == null) break block8;
                }
                catch (Exception e) {
                    logger.error("\u67e5\u8be2\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
                    break block9;
                }
                finally {
                    if (restHighLevelClient != null) {
                        clientPool.returnObject(restHighLevelClient);
                    }
                }
                clientPool.returnObject((Object)restHighLevelClient);
            }
            return jSONArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(String beginDate) {
        if (StringUtils.isBlank((CharSequence)beginDate)) {
            throw new ObjectException("\u8bf7\u6307\u5b9a\u5177\u4f53\u65f6\u95f4\uff01");
        }
        GenericObjectPool restHighLevelClientGenericObjectPool = IndexerSearcherFactory.obtainclientPool((ESServerConfig)this.esServerConfig);
        RestHighLevelClient restHighLevelClient = null;
        try {
            int batches;
            restHighLevelClient = (RestHighLevelClient)restHighLevelClientGenericObjectPool.borrowObject();
            String indexName = DocumentUtils.obtainDocumentIndexName(ESOperationLog.class);
            DeleteByQueryRequest delete = new DeleteByQueryRequest(new String[]{indexName});
            Long date = new SmartDateFormat("yyyy-MM-dd HH:mm:ss").parse(beginDate).getTime();
            RangeQueryBuilder optTime = QueryBuilders.rangeQuery((String)"optTime").lte((Object)date);
            delete.setQuery((QueryBuilder)optTime);
            BulkByScrollResponse bulkByScrollResponse = restHighLevelClient.deleteByQuery(delete, RequestOptions.DEFAULT);
            int n = batches = bulkByScrollResponse.getBatches();
            return n;
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        }
        finally {
            if (restHighLevelClient != null) {
                restHighLevelClientGenericObjectPool.returnObject((Object)restHighLevelClient);
            }
        }
        return 0;
    }

    public void deleteObjectById(String docId) {
        if (!this.elkOptLogIndexer.deleteDocument(docId)) {
            throw new ObjectException(500, "elasticsearch\u64cd\u4f5c\u5931\u8d25");
        }
    }

    public void updateOperationLog(OperationLog operationLog, String logId) {
        ESOperationLog esOperationLog = ESOperationLog.fromOperationLog(operationLog, logId);
        if (this.elkOptLogIndexer.mergeDocument((ESDocument)esOperationLog) == null) {
            throw new ObjectException(500, "elasticsearch\u64cd\u4f5c\u5931\u8d25");
        }
    }

    private void publicbuild(String optId, Map<String, Object> filter, BoolQueryBuilder boolQueryBuilder) throws ParseException {
        if (StringUtils.isNotBlank((CharSequence)optId)) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"optId", (String)optId));
        }
        this.removeField(ESOperationLog.class, filter);
        if (filter == null || filter.size() == 0) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchAllQuery());
        } else {
            for (Map.Entry<String, Object> entry : filter.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (!StringUtils.isNotBlank((CharSequence)key) || value == null) continue;
                if (key.startsWith("optTime")) {
                    this.buildQuery(key, "optTime", value, boolQueryBuilder);
                    continue;
                }
                if ("optContent".equals(key)) {
                    boolQueryBuilder.filter((QueryBuilder)QueryBuilders.multiMatchQuery((Object)value, (String[])new String[]{"optContent", "newValue", "oldValue"}));
                    continue;
                }
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)value));
            }
        }
    }

    private void buildQuery(String key, String field, Object value, BoolQueryBuilder boolQueryBuilder) throws ParseException {
        String optSuffix = key.substring(key.length() - 3).toLowerCase();
        Long date = new SmartDateFormat("yyyy-MM-dd HH:mm:ss").parse(String.valueOf(value)).getTime();
        switch (optSuffix) {
            case "_gt": {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)field).gt((Object)date));
                break;
            }
            case "_ge": {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)field).gte((Object)date));
                break;
            }
            case "_lt": {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)field).lt((Object)date));
                break;
            }
            case "_le": {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)field).lte((Object)date));
                break;
            }
            default: {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)field, (Object)date));
            }
        }
    }

    private void removeField(Class clzz, Map<String, Object> map) {
        if (clzz == null || map == null) {
            return;
        }
        List fieldNames = Arrays.stream(clzz.getDeclaredFields()).map(Field::getName).collect(Collectors.toList());
        map.keySet().removeIf(key -> !fieldNames.contains(key) && !key.startsWith("optTime_"));
    }
}

