/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.controller;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.centit.fileserver.utils.UploadDownloadUtils;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.product.metadata.po.MetaColumn;
import com.centit.product.metadata.po.MetaTable;
import com.centit.product.metadata.service.MetaDataService;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.FieldType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u6570\u636e\u5e93\u5143\u6570\u636e\u4fe1\u606f\u5b8c\u5584", tags={"\u5143\u6570\u636e\u4fe1\u606f\u7ef4\u62a4"})
@RestController
@RequestMapping(value={"update"})
public class MetadataUpdateController
extends BaseController {
    @Autowired
    private MetaDataService metaDataService;

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u4e1a\u52a1\u6570\u636e\u7c7b\u578bMap")
    @GetMapping(value={"/fieldType", "/no-auth/fieldType"})
    @WrapUpResponseBody
    public Map<String, String> listFieldType() {
        return FieldType.getAllTypeMap();
    }

    @ApiOperation(value="\u4fee\u6539\u8868\u5143\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tableId", value="\u8868ID"), @ApiImplicitParam(name="tableLabelName", value="\u4e2d\u6587\u540d"), @ApiImplicitParam(name="tableComment", value="\u63cf\u8ff0")})
    @PutMapping(value={"/table/{tableId}"})
    @WrapUpResponseBody
    public void updateMetaTable(@PathVariable String tableId, @RequestBody MetaTable metaTable, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        metaTable.setTableId(tableId);
        metaTable.setRecorder(userCode);
        this.metaDataService.updateMetaTable(metaTable);
    }

    @ApiOperation(value="\u4fee\u6539\u5217\u5143\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tableId", value="\u8868ID"), @ApiImplicitParam(name="fieldLabelName", value="\u5217\u540d")})
    @PutMapping(value={"/column/{tableId}/{columnCode}"})
    @WrapUpResponseBody
    public void updateMetaColumns(@PathVariable String tableId, @PathVariable String columnCode, @RequestBody MetaColumn metaColumn) {
        metaColumn.setTableId(tableId);
        metaColumn.setColumnName(columnCode);
        if ("A".equals(metaColumn.getAutoCreateRule()) && !metaColumn.isPrimaryKey()) {
            throw new ObjectException(611, "\u81ea\u52a8\u589e\u957f\u751f\u6210\u89c4\u5219\u53ea\u80fd\u914d\u7f6e\u5728\u4e3b\u952e\u4e0a\uff01");
        }
        this.metaDataService.updateMetaColumn(metaColumn);
    }

    @ApiOperation(value="\u65b0\u5efa\u5173\u8054\u5173\u7cfb\u5143\u6570\u636e")
    @PostMapping(value={"/{tableId}/relation"})
    @WrapUpResponseBody
    public void createRelations(@PathVariable String tableId, MetaTable metaTable) {
        this.metaDataService.saveRelations(tableId, metaTable.getMdRelations());
    }

    @ApiOperation(value="\u5bfc\u5165TableStore\u4e2d\u5bfc\u5165\u8868\u5173\u7cfb")
    @ApiImplicitParam(name="databaseCode", type="path", value="\u6570\u636e\u5e93ID")
    @RequestMapping(value={"/import/{databaseCode}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public void importRelationsFromTableStore(@PathVariable String databaseCode, HttpServletRequest request) throws IOException {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(403, "\u7528\u6237\u6ca1\u767b\u5f55\uff0c\u6216\u8005session\u5df2\u5931\u6548\uff01");
        }
        Pair fileInfo = UploadDownloadUtils.fetchInputStreamFromMultipartResolver((HttpServletRequest)request);
        JSONObject jsonObject = JSON.parseObject((InputStream)((InputStream)fileInfo.getRight()), (JSONReader.Feature[])new JSONReader.Feature[0]);
        if (!(jsonObject != null && jsonObject.containsKey("projectInfo") && jsonObject.containsKey("tables") && jsonObject.containsKey("modules"))) {
            throw new ObjectException(611, "\u6587\u4ef6\u4e2d\u7684json\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        this.metaDataService.importRelationFromTableStore(databaseCode, jsonObject, userCode);
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u8868\u7684\u5c5e\u6027\uff0c\u53ea\u80fd\u4fee\u6539 \u903b\u8f91\u5220\u9664\u6807\u8bc6\u3001\u66f4\u65b0\u7248\u672c\u6807\u8bc6 \u3001\u662f\u5426\u5199\u5165\u65e5\u5fd7\u3001\u662f\u5426\u5168\u6587\u68c0\u7d22\u3002\r\n\u8fd9\u56db\u4e2a\u5c5e\u6027 :fulltextSearch writeOptLog deleteTagField  checkVersionField ")
    @PutMapping(value={"/batchUpdateTable"})
    @ApiImplicitParam(name="formJsonString", paramType="body", value="JSON\u4e2d\u5206\u4e24\u90e8\u5206\uff0c\u4e00\u90e8\u5206\u662f\u67e5\u8be2\u6761\u4ef6\uff0c\u4e00\u90e8\u5206\u662f\u4fee\u6539\u7684\u5c5e\u6027")
    @WrapUpResponseBody
    public void batchUpdateTableProps(@RequestBody String formJsonString) {
        String writeOptLog;
        JSONObject formJson = JSONObject.parseObject((String)formJsonString);
        JSONObject filter = formJson.getJSONObject("filter");
        if (filter == null) {
            return;
        }
        JSONObject props = formJson.getJSONObject("props");
        if (props == null || props.isEmpty()) {
            return;
        }
        List<MetaTable> tables = this.metaDataService.searchMateTable(filter);
        if (tables == null || tables.isEmpty()) {
            return;
        }
        MetaTable tableInfo = new MetaTable();
        String fulltextSearch = props.getString("fulltextSearch");
        if (StringUtils.isNotBlank((CharSequence)fulltextSearch)) {
            tableInfo.setFulltextSearch(BooleanBaseOpt.castObjectToBoolean((Object)fulltextSearch, (Boolean)false));
        }
        if (StringUtils.isNotBlank((CharSequence)(writeOptLog = props.getString("writeOptLog")))) {
            tableInfo.setWriteOptLog(BooleanBaseOpt.castObjectToBoolean((Object)writeOptLog, (Boolean)false));
        }
        tableInfo.setDeleteTagField(StringRegularOpt.trimStringBlankAsNull((String)props.getString("deleteTagField")));
        tableInfo.setCheckVersionField(StringRegularOpt.trimStringBlankAsNull((String)props.getString("checkVersionField")));
        for (MetaTable metaTable : tables) {
            tableInfo.setTableId(metaTable.getTableId());
            this.metaDataService.updateMetaTable(tableInfo);
        }
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u8868\u7684\u5b57\u6bb5\u5c5e\u6027\uff1b\u53ef\u4ee5\u4fee\u6539: \u751f\u6210\u89c4\u5219\u3001\u8131\u654f\u3001\u6821\u9a8c\u3001\u5e94\u7528\u3001\u5e94\u7528\u3001\u5ef6\u65f6\u52a0\u8f7d \u548c \u5fc5\u586b \u7b49\u5c5e\u6027")
    @PutMapping(value={"/batchUpdateColumn"})
    @WrapUpResponseBody
    public int batchUpdateTableColumns(@RequestBody String formJsonString) {
        String lazyFetch;
        JSONObject formJson = JSONObject.parseObject((String)formJsonString);
        JSONObject filter = formJson.getJSONObject("filter");
        if (filter == null) {
            return 0;
        }
        JSONObject props = formJson.getJSONObject("props");
        if (props == null || props.isEmpty()) {
            return 0;
        }
        String columnName = props.getString("columnName");
        if (StringUtils.isBlank((CharSequence)columnName)) {
            throw new ObjectException(611, "\u6279\u91cf\u4fee\u6539\u8868\u7684\u5b57\u6bb5\u5c5e\u6027\uff0c\u5fc5\u987b\u6307\u5b9a\u5b57\u6bb5\u540d\uff1acolumnName\uff01");
        }
        List<MetaTable> tables = this.metaDataService.searchMateTable(filter);
        if (tables == null || tables.isEmpty()) {
            return 0;
        }
        MetaColumn columnInfo = new MetaColumn();
        columnInfo.setColumnName(columnName);
        Object mandatory = props.get("mandatory");
        if (mandatory != null) {
            columnInfo.setMandatory(BooleanBaseOpt.castObjectToBoolean((Object)mandatory, null));
        }
        if ((lazyFetch = props.getString("lazyFetch")) != null) {
            columnInfo.setLazyFetch(BooleanBaseOpt.castObjectToBoolean((Object)lazyFetch, null));
        }
        columnInfo.setReferenceType(StringRegularOpt.trimStringBlankAsNull((String)props.getString("referenceType")));
        columnInfo.setReferenceData(StringRegularOpt.trimStringBlankAsNull((String)props.getString("referenceData")));
        columnInfo.setCheckRuleId(StringRegularOpt.trimStringBlankAsNull((String)props.getString("checkRuleId")));
        columnInfo.setCheckRuleParams(props.getJSONObject("checkRuleParams"));
        columnInfo.setAutoCreateCondition(StringRegularOpt.trimStringBlankAsNull((String)props.getString("autoCreateCondition")));
        columnInfo.setAutoCreateRule(StringRegularOpt.trimStringBlankAsNull((String)props.getString("autoCreateRule")));
        columnInfo.setAutoCreateParam(StringRegularOpt.trimStringBlankAsNull((String)props.getString("autoCreateParam")));
        columnInfo.setSensitiveType(StringRegularOpt.trimStringBlankAsNull((String)props.getString("sensitiveType")));
        int updated = 0;
        for (MetaTable metaTable : tables) {
            MetaColumn column = this.metaDataService.getMetaColumn(metaTable.getTableId(), columnName);
            if (column == null) continue;
            columnInfo.setTableId(metaTable.getTableId());
            this.metaDataService.updateMetaColumn(columnInfo);
            ++updated;
        }
        return updated;
    }
}

