/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.utils;

import com.centit.product.metadata.po.DataCheckRule;
import com.centit.product.metadata.utils.DataCheckUtils;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.compiler.ObjectTranslate;
import com.centit.support.compiler.Pretreatment;
import com.centit.support.compiler.VariableFormula;
import com.centit.support.compiler.VariableTranslate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class DataCheckResult {
    private Boolean result = true;
    private List<String> errorMsgs = new ArrayList<String>(4);
    public static final Map<String, Function<Object[], Object>> extraFunc = new HashMap<String, Function<Object[], Object>>();

    public String getErrorMessage() {
        if (this.result.booleanValue()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String msg : this.errorMsgs) {
            sb.append(msg).append("\r\n");
        }
        return sb.toString();
    }

    public void reset() {
        this.result = true;
        this.errorMsgs.clear();
    }

    public static DataCheckResult create() {
        return new DataCheckResult();
    }

    public DataCheckResult runCheckRule(DataCheckRule rule, Map<String, Object> realParams, boolean makeErrorMessage, boolean nullAsTrue) {
        Object checkValue = realParams.get("checkValue");
        if (checkValue == null) {
            if (!nullAsTrue) {
                this.result = false;
                if (makeErrorMessage) {
                    this.errorMsgs.add(Pretreatment.mapTemplateString((String)rule.getFaultMessage(), realParams));
                }
            }
        } else if (!BooleanBaseOpt.castObjectToBoolean((Object)VariableFormula.calculate((String)rule.getRuleFormula(), (VariableTranslate)new ObjectTranslate(realParams), extraFunc), (Boolean)false).booleanValue()) {
            this.result = false;
            if (makeErrorMessage) {
                this.errorMsgs.add(Pretreatment.mapTemplateString((String)rule.getFaultMessage(), realParams));
            }
        }
        return this;
    }

    public DataCheckResult checkData(Object data, DataCheckRule rule, Map<String, String> param, boolean makeErrorMessage, boolean nullAsTrue) {
        HashMap<String, Object> realPparam = new HashMap<String, Object>();
        if (!param.isEmpty()) {
            for (Map.Entry<String, String> ent : param.entrySet()) {
                realPparam.put(ent.getKey(), VariableFormula.calculate((String)ent.getValue(), (Object)data));
            }
        }
        return this.runCheckRule(rule, realPparam, makeErrorMessage, nullAsTrue);
    }

    public DataCheckResult checkData(Object data, DataCheckRule rule, Map<String, String> param) {
        return this.checkData(data, rule, param, true, true);
    }

    public Boolean getResult() {
        return this.result;
    }

    public List<String> getErrorMsgs() {
        return this.errorMsgs;
    }

    public void setResult(Boolean result) {
        this.result = result;
    }

    public void setErrorMsgs(List<String> errorMsgs) {
        this.errorMsgs = errorMsgs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataCheckResult)) {
            return false;
        }
        DataCheckResult other = (DataCheckResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$result = this.getResult();
        Boolean other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
            return false;
        }
        List<String> this$errorMsgs = this.getErrorMsgs();
        List<String> other$errorMsgs = other.getErrorMsgs();
        return !(this$errorMsgs == null ? other$errorMsgs != null : !((Object)this$errorMsgs).equals(other$errorMsgs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataCheckResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        List<String> $errorMsgs = this.getErrorMsgs();
        result = result * 59 + ($errorMsgs == null ? 43 : ((Object)$errorMsgs).hashCode());
        return result;
    }

    public String toString() {
        return "DataCheckResult(result=" + this.getResult() + ", errorMsgs=" + this.getErrorMsgs() + ")";
    }

    static {
        extraFunc.put("checkIdCardNo", d -> DataCheckUtils.checkIdCardNo(StringBaseOpt.castObjectToString((Object)d[0])));
    }
}

