/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.service.impl;

import com.centit.product.metadata.dao.MetaRelationDao;
import com.centit.product.metadata.dao.MetaTableDao;
import com.centit.product.metadata.po.MetaRelation;
import com.centit.product.metadata.po.MetaTable;
import com.centit.product.metadata.service.MetaDataCache;
import com.centit.support.common.CachedMap;
import com.centit.support.common.ObjectException;
import org.apache.commons.lang3.tuple.MutablePair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MetaDataCacheImpl
implements MetaDataCache {
    private CachedMap<String, MutablePair<Integer, MetaTable>> metaTableCache = new CachedMap(tableId -> {
        MetaTable metaTable = this.getTableInfoWithColumns((String)tableId);
        if (metaTable == null) {
            return null;
        }
        return new MutablePair((Object)0, (Object)metaTable);
    }, 30L);
    @Autowired
    private MetaTableDao metaTableDao;
    @Autowired
    private MetaRelationDao metaRelationDao;

    private MetaTable getTableInfoWithColumns(String tableId) {
        MetaTable metaTable = this.metaTableDao.getObjectById((Object)tableId);
        this.metaTableDao.fetchObjectReference(metaTable, "mdColumns");
        return metaTable;
    }

    @Override
    public MetaTable getTableInfo(String tableId) {
        MutablePair tableMutablePair = (MutablePair)this.metaTableCache.getCachedValue((Object)tableId);
        if (tableMutablePair == null) {
            throw new ObjectException(612, "\u5143\u6570\u636e\u914d\u7f6e\u4e0d\u5b8c\u6574\uff0c\u7f3a\u5c11\u8868\u4fe1\u606f\uff1a" + tableId);
        }
        MetaTable metaTable = (MetaTable)tableMutablePair.getRight();
        if (metaTable == null) {
            throw new ObjectException(612, "\u5143\u6570\u636e\u914d\u7f6e\u4e0d\u5b8c\u6574\uff0c\u7f3a\u5c11\u8868\u4fe1\u606f\uff1a" + tableId);
        }
        return metaTable;
    }

    private MetaTable fetchTableRelations(MetaTable metaTable) {
        this.metaTableDao.fetchObjectReference(metaTable, "mdRelations");
        if (metaTable.getMdRelations().size() > 0) {
            for (MetaRelation mr : metaTable.getMdRelations()) {
                this.metaRelationDao.fetchObjectReference(mr, "relationDetails");
            }
        }
        return metaTable;
    }

    private MetaTable fetchTableParents(MetaTable metaTable) {
        this.metaTableDao.fetchObjectReference(metaTable, "parents");
        if (metaTable.getParents().size() > 0) {
            for (MetaRelation parent : metaTable.getParents()) {
                this.metaRelationDao.fetchObjectReference(parent, "relationDetails");
            }
        }
        return metaTable;
    }

    @Override
    public MetaTable getTableInfoWithRelations(String tableId) {
        MutablePair tablePair = (MutablePair)this.metaTableCache.getCachedValue((Object)tableId);
        if (tablePair == null) {
            throw new ObjectException(604, "\u6ca1\u6709\u5bf9\u5e94\u7684\u8868\u7ed3\u6784\u5143\u6570\u636e\uff1a" + tableId);
        }
        MetaTable metaTable = (MetaTable)tablePair.getRight();
        if (metaTable == null) {
            throw new ObjectException(604, "\u6ca1\u6709\u5bf9\u5e94\u7684\u8868\u7ed3\u6784\u5143\u6570\u636e\uff1a" + tableId);
        }
        if ((Integer)tablePair.getLeft() % 10 == 0) {
            this.fetchTableRelations(metaTable);
            tablePair.setLeft((Object)((Integer)tablePair.getLeft() + 1));
        }
        return metaTable;
    }

    @Override
    public MetaTable getTableInfoWithParents(String tableId) {
        MutablePair tablePair = (MutablePair)this.metaTableCache.getCachedValue((Object)tableId);
        MetaTable metaTable = (MetaTable)tablePair.getRight();
        if ((Integer)tablePair.getLeft() / 10 == 0) {
            this.fetchTableParents(metaTable);
            tablePair.setLeft((Object)((Integer)tablePair.getLeft() + 10));
        }
        return metaTable;
    }

    @Override
    public MetaTable getTableInfoAll(String tableId) {
        MutablePair tablePair = (MutablePair)this.metaTableCache.getCachedValue((Object)tableId);
        MetaTable metaTable = (MetaTable)tablePair.getRight();
        if ((Integer)tablePair.getLeft() % 10 == 0) {
            this.fetchTableRelations(metaTable);
        }
        if ((Integer)tablePair.getLeft() / 10 == 0) {
            this.fetchTableParents(metaTable);
        }
        tablePair.setLeft((Object)11);
        return metaTable;
    }
}

