/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.controller;

import com.alibaba.fastjson2.JSONArray;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.OsInfo;
import com.centit.product.metadata.api.ISourceInfo;
import com.centit.product.metadata.po.SourceInfo;
import com.centit.product.metadata.service.SourceInfoManager;
import com.centit.product.metadata.service.SourceInfoMetadata;
import com.centit.product.metadata.transaction.AbstractDBConnectPools;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.network.HtmlFormUtils;
import com.centit.support.network.HttpExecutor;
import com.centit.support.network.HttpExecutorContext;
import com.centit.support.network.SoapWsdlParser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/database"})
@Api(tags={"\u6570\u636e\u5e93\u7ef4\u62a4\u63a5\u53e3"}, value="\u6570\u636e\u5e93\u7ef4\u62a4\u63a5\u53e3")
public class SourceInfoController
extends BaseController {
    @Autowired
    private SourceInfoManager databaseInfoMag;
    @Autowired
    private SourceInfoMetadata sourceInfoMetadata;
    @Value(value="${os.file.base.dir:./}")
    private String osFileDir;
    @Autowired
    private PlatformEnvironment platformEnvironment;
    private String optId = "DATABASE";

    @ApiOperation(value="\u6240\u6709\u6570\u636e\u5e93\u5217\u8868\u4fe1\u606f", notes="\u6240\u6709\u6570\u636e\u5e93\u5217\u8868\u4fe1\u606f\u3002\u589e\u52a0databaseCode")
    @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\uff0c\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="query", dataTypeClass=PageDesc.class)
    @RequestMapping(method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.BASE64)
    public PageQueryResult<Object> list(PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            return PageQueryResult.createResult(Collections.emptyList(), (PageDesc)pageDesc);
        }
        searchColumn.put("topUnit", topUnit);
        JSONArray listObjects = this.databaseInfoMag.listDatabaseAsJson(searchColumn, pageDesc);
        this.databaseInfoMag.appendRelativeOsInfo(listObjects);
        return PageQueryResult.createJSONArrayResult((JSONArray)listObjects, (PageDesc)pageDesc, (Class[])new Class[]{SourceInfo.class});
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e\u5e93\u4fe1\u606f", notes="\u65b0\u589e\u6570\u636e\u5e93\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="databaseinfo", value="json\u683c\u5f0f\uff0c\u6570\u636e\u5e93\u5bf9\u8c61\u4fe1\u606f", required=true, paramType="body", dataTypeClass=SourceInfo.class)
    @RequestMapping(method={RequestMethod.POST})
    public void saveDatabaseInfo(@RequestBody SourceInfo databaseinfo, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isBlank((CharSequence)WebOptUtils.getCurrentUserCode((HttpServletRequest)request))) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55!");
        }
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            throw new ObjectException(500, "\u60a8\u8fd8\u672a\u52a0\u5165\u79df\u6237!");
        }
        databaseinfo.setTopUnit(topUnit);
        databaseinfo.setDatabaseUrl(HtmlFormUtils.htmlString((String)databaseinfo.getDatabaseUrl()));
        if (StringUtils.isNotBlank((CharSequence)databaseinfo.getPassword())) {
            databaseinfo.setPassword(databaseinfo.getPassword());
        }
        databaseinfo.setCreated(WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        this.databaseInfoMag.saveNewObject(databaseinfo);
        JsonResultUtils.writeSingleDataJson((Object)databaseinfo.getDatabaseCode(), (HttpServletResponse)response);
        OperationLogCenter.logNewObject((HttpServletRequest)request, (String)this.optId, (String)databaseinfo.getDatabaseCode(), (String)"create", (String)"\u65b0\u589e\u6570\u636e\u5e93", (Object)databaseinfo);
    }

    @ApiOperation(value="\u65b0\u589e\u6587\u4ef6\u6570\u636e\u5e93", notes="\u65b0\u589e\u6587\u4ef6\u6570\u636e\u5e93\u3002")
    @ApiImplicitParam(name="h2", value="json\u683c\u5f0f\uff0c\u6570\u636e\u5e93\u5bf9\u8c61\u4fe1\u606f", required=true, paramType="body", dataTypeClass=SourceInfo.class)
    @RequestMapping(value={"/createH2"}, method={RequestMethod.POST})
    public void createH2DatabaseInfo(String osId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55!");
        }
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            throw new ObjectException(500, "\u60a8\u8fd8\u672a\u52a0\u5165\u79df\u6237!");
        }
        if (StringUtils.isBlank((CharSequence)osId)) {
            throw new ObjectException(500, "\u7f3a\u5c11\u5e94\u7528\u76f8\u5173\u7684\u53c2\u6570!");
        }
        List userGroups = this.platformEnvironment.listWorkGroup(osId, userCode, null);
        if (userGroups == null || CollectionUtils.isEmpty((Collection)userGroups)) {
            throw new ObjectException(203, "\u60a8\u4e0d\u5728\u8be5\u5e94\u7528\u5f00\u53d1\u7ec4\u4e2d\uff01");
        }
        if (this.databaseInfoMag.getObjectById(osId) != null) {
            throw new ObjectException(500, "\u6b64\u5e94\u7528\u5df2\u521b\u5efa\u8fc7\u6587\u4ef6\u6570\u636e\u5e93\uff0c\u4e0d\u80fd\u518d\u6b21\u521b\u5efa!");
        }
        String url = "";
        url = this.osFileDir.endsWith("/") || this.osFileDir.endsWith("\\") ? this.osFileDir + "h2/" + osId : this.osFileDir + File.separatorChar + "h2/" + osId;
        url = "jdbc:h2:file:" + url;
        SourceInfo databaseinfo = new SourceInfo();
        databaseinfo.setTopUnit(topUnit);
        databaseinfo.setDatabaseUrl(url);
        OsInfo osInfo = this.platformEnvironment.getOsInfo(osId);
        if (osInfo != null) {
            databaseinfo.setDatabaseName(osInfo.getOsName() + "\u3010\u5185\u7f6e\u6587\u4ef6\u6570\u636e\u5e93\u3011");
        } else {
            databaseinfo.setDatabaseName(osId);
        }
        databaseinfo.setSourceType("D");
        databaseinfo.setCreated(userCode);
        databaseinfo.setDatabaseCode(osId);
        try {
            AbstractDBConnectPools.testConnect(databaseinfo);
            this.databaseInfoMag.saveNewObject(databaseinfo);
            JsonResultUtils.writeSingleDataJson((Object)databaseinfo.getDatabaseCode(), (HttpServletResponse)response);
        }
        catch (SQLException e) {
            JsonResultUtils.writeErrorMessageJson((String)e.getMessage(), (HttpServletResponse)response);
        }
        OperationLogCenter.logNewObject((HttpServletRequest)request, (String)this.optId, (String)databaseinfo.getDatabaseCode(), (String)"create", (String)"\u65b0\u589e\u6570\u636e\u5e93", (Object)databaseinfo);
    }

    @ApiOperation(value="\u6570\u636e\u5e93\u8fde\u63a5\u6d4b\u8bd5", notes="\u6570\u636e\u5e93\u8fde\u63a5\u6d4b\u8bd5\u3002")
    @ApiImplicitParam(name="databaseinfo", value="json\u683c\u5f0f\uff0c\u6570\u636e\u5e93\u5bf9\u8c61\u4fe1\u606f", required=true, paramType="body", dataTypeClass=SourceInfo.class)
    @RequestMapping(value={"/testConnect"}, method={RequestMethod.POST})
    public void testConnect(@Valid SourceInfo sourceInfo, HttpServletResponse response) {
        sourceInfo.setDatabaseUrl(HtmlFormUtils.htmlString((String)sourceInfo.getDatabaseUrl()));
        sourceInfo = this.sourceInfoMetadata.convertorSourceInfo(sourceInfo);
        if (sourceInfo.getDatabaseCode() != null) {
            this.sourceInfoMetadata.refreshCache(sourceInfo.getDatabaseCode());
            SourceInfo dataBaseSourceInfo = this.sourceInfoMetadata.fetchSourceInfo(sourceInfo.getDatabaseCode());
            if (StringUtils.isBlank((CharSequence)sourceInfo.getPassword())) {
                sourceInfo.setPassword(dataBaseSourceInfo.getPassword());
            }
        }
        try {
            AbstractDBConnectPools.testConnect(sourceInfo);
            JsonResultUtils.writeSingleDataJson((Object)"\u8fde\u63a5\u6d4b\u8bd5\u6210\u529f", (HttpServletResponse)response);
        }
        catch (SQLException e) {
            JsonResultUtils.writeErrorMessageJson((String)e.getMessage(), (HttpServletResponse)response);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e\u5e93\u4fe1\u606f", notes="\u4fee\u6539\u6570\u636e\u5e93\u4fe1\u606f\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="databaseCode", value="\u6570\u636e\u5e93\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="databaseinfo", value="json\u683c\u5f0f\uff0c\u6570\u636e\u5e93\u5bf9\u8c61\u4fe1\u606f", required=true, paramType="body", dataTypeClass=SourceInfo.class)})
    @RequestMapping(value={"/{databaseCode}"}, method={RequestMethod.PUT})
    public void updateDatabaseInfo(@PathVariable String databaseCode, @RequestBody SourceInfo databaseinfo, HttpServletRequest request, HttpServletResponse response) {
        databaseinfo.setDatabaseUrl(HtmlFormUtils.htmlString((String)databaseinfo.getDatabaseUrl()));
        SourceInfo temp = this.databaseInfoMag.getObjectById(databaseCode);
        if (StringUtils.isNotBlank((CharSequence)databaseinfo.getPassword()) && !databaseinfo.getPassword().equals(temp.getPassword())) {
            databaseinfo.setPassword(databaseinfo.getPassword());
            try {
                AbstractDBConnectPools.testConnect(databaseinfo);
            }
            catch (SQLException e) {
                throw new ObjectException(612, "\u6570\u636e\u5e93\u94fe\u63a5\u6d4b\u8bd5\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
        this.databaseInfoMag.mergeObject(databaseinfo);
        this.sourceInfoMetadata.refreshCache(databaseinfo.getDatabaseCode());
        if ("D".equals(databaseinfo.getSourceType())) {
            AbstractDBConnectPools.refreshDataSource((ISourceInfo)databaseinfo);
        }
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logUpdateObject((HttpServletRequest)request, (String)this.optId, (String)databaseCode, (String)"update", (String)"\u66f4\u65b0\u6570\u636e\u5e93\u4fe1\u606f", (Object)databaseinfo, (Object)temp);
    }

    @ApiOperation(value="\u83b7\u53d6\u5355\u4e2a\u6570\u636e\u5e93\u4fe1\u606f", notes="\u83b7\u53d6\u5355\u4e2a\u6570\u636e\u5e93\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="databaseCode", value="\u6570\u636e\u5e93\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{databaseCode}"}, method={RequestMethod.GET})
    public void getDatabaseInhfo(@PathVariable String databaseCode, HttpServletResponse response) {
        SourceInfo sourceInfo = this.databaseInfoMag.getObjectById(databaseCode);
        JsonResultUtils.writeSingleDataJson((Object)sourceInfo, (HttpServletResponse)response);
    }

    @ApiOperation(value="\u5220\u9664\u5355\u4e2a\u6570\u636e\u5e93\u4fe1\u606f", notes="\u5220\u9664\u5355\u4e2a\u6570\u636e\u5e93\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="databaseCode", value="\u6570\u636e\u5e93\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{databaseCode}"}, method={RequestMethod.DELETE})
    public void deleteDatabase(@PathVariable String databaseCode, HttpServletRequest request, HttpServletResponse response) {
        SourceInfo sourceInfo = this.databaseInfoMag.getObjectById(databaseCode);
        this.databaseInfoMag.deleteObjectById(databaseCode);
        if ("D".equals(sourceInfo.getSourceType())) {
            AbstractDBConnectPools.delDataSource((ISourceInfo)sourceInfo);
        }
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logDeleteObject((HttpServletRequest)request, (String)this.optId, (String)databaseCode, (String)"delete", (String)"\u5220\u9664\u6570\u636e\u5e93", (Object)sourceInfo);
    }

    @ApiOperation(value="\u83b7\u53d6SOAP\u7684 namespace", notes="\u6839\u636eurl\u83b7\u53d6soap\u7684namespace")
    @ApiImplicitParam(name="url", value="Http\u670d\u52a1\u7684url \u4ec5\u9650\u4e8esoap\u534f\u8bae", paramType="query", dataTypeClass=PageDesc.class)
    @RequestMapping(path={"soapnamespace"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public String getSoapNameSpace(String url) {
        try {
            String wsdl = HttpExecutor.simpleGet((HttpExecutorContext)HttpExecutorContext.create(), (String)(url + "?wsdl"));
            Document doc = DocumentHelper.parseText((String)wsdl);
            return SoapWsdlParser.getSoapNameSpace((Element)doc.getRootElement());
        }
        catch (IOException | DocumentException e) {
            return "error:" + e.getMessage();
        }
    }

    @ApiOperation(value="\u83b7\u53d6SOAP\u7684\u65b9\u6cd5\u5217\u8868", notes="\u6839\u636e\u670d\u52a1id\uff08databaseCode\uff09\u83b7\u53d6soap\u7684\u65b9\u6cd5\u7c7b\u522b")
    @ApiImplicitParam(name="httpServicesId", value="Http\u670d\u52a1\u7684\u8d44\u6e90id\uff1adatabaseCode", paramType="query", dataTypeClass=PageDesc.class)
    @RequestMapping(path={"soapactions"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<String> getSoapActionList(String httpServicesId, String withInputName) {
        ArrayList<String> methods = new ArrayList<String>();
        SourceInfo sourceInfo = this.databaseInfoMag.getObjectById(httpServicesId);
        if (sourceInfo == null) {
            return methods;
        }
        try {
            String wsdl = HttpExecutor.simpleGet((HttpExecutorContext)HttpExecutorContext.create(), (String)(sourceInfo.getDatabaseUrl() + "?wsdl"));
            Document doc = DocumentHelper.parseText((String)wsdl);
            List actiontsName = SoapWsdlParser.getSoapActionList((Element)doc.getRootElement());
            if (BooleanBaseOpt.castObjectToBoolean((Object)withInputName, (Boolean)false).booleanValue()) {
                ArrayList<String> methodWithInputName = new ArrayList<String>();
                for (String actName : actiontsName) {
                    methodWithInputName.add(actName + ":" + SoapWsdlParser.getSoapActionInputName((Element)doc.getRootElement(), (String)actName));
                }
                return methodWithInputName;
            }
            return actiontsName;
        }
        catch (IOException | DocumentException e) {
            this.logger.error(e.getMessage());
            return methods;
        }
    }

    @ApiOperation(value="\u83b7\u53d6SOAP\u7684 \u65b9\u6cd5\u53c2\u6570", notes="\u6839\u636eurl\u83b7\u53d6soap\u7684namespace")
    @ApiImplicitParams(value={@ApiImplicitParam(name="httpServicesId", value="Http\u670d\u52a1\u7684\u8d44\u6e90id\uff1adatabaseCode", paramType="query", dataTypeClass=PageDesc.class), @ApiImplicitParam(name="httpServicesId", value="Http\u670d\u52a1\u7684\u8d44\u6e90id\uff1adatabaseCode", paramType="query", dataTypeClass=PageDesc.class)})
    @RequestMapping(path={"soapactionparams"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public Map<String, String> getSoapActionParams(String httpServicesId, String actionName) {
        HashMap<String, String> params = new HashMap<String, String>();
        SourceInfo sourceInfo = this.databaseInfoMag.getObjectById(httpServicesId);
        if (sourceInfo == null) {
            return params;
        }
        try {
            String wsdl = HttpExecutor.simpleGet((HttpExecutorContext)HttpExecutorContext.create(), (String)(sourceInfo.getDatabaseUrl() + "?wsdl"));
            Document doc = DocumentHelper.parseText((String)wsdl);
            int p = actionName.indexOf(":");
            if (p > 0) {
                actionName = actionName.substring(0, p);
            }
            return SoapWsdlParser.getSoapActionParams((Element)doc.getRootElement(), (String)actionName);
        }
        catch (IOException | DocumentException e) {
            this.logger.error(e.getMessage());
            return params;
        }
    }
}

