/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.dataopt.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.centit.framework.common.ResponseData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.product.metadata.service.MetaObjectService;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"chart"})
@Api(value="\u57fa\u4e8e\u5143\u6570\u636e\u7684\u6570\u636e\u8bbf\u95ee\u670d\u52a1", tags={"\u6570\u636e\u8bbf\u95ee"})
public class MetaObjectController
extends BaseController {
    @Autowired
    private MetaObjectService metaObjectService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6570\u636e\u5e93\u8868\u6570\u636e\u5217\u8868")
    @RequestMapping(value={"/{tableId}/list"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<Object> listObjects(@PathVariable String tableId, PageDesc pageDesc, HttpServletRequest request) {
        Map params = MetaObjectController.collectRequestParameters((HttpServletRequest)request);
        JSONArray ja = this.metaObjectService.pageQueryObjects(tableId, params, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)ja, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e00\u4e2a\u6570\u636e\uff0c\u4e3b\u952e\u4f5c\u4e3a\u53c2\u6570\u4ee5key-value\u5f62\u5f0f\u63d0\u4ea4")
    @RequestMapping(value={"/{tableId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public Map<String, Object> getObject(@PathVariable String tableId, HttpServletRequest request) {
        Map parameters = MetaObjectController.collectRequestParameters((HttpServletRequest)request);
        return this.metaObjectService.getObjectById(tableId, parameters);
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e\u5e93\u8868\u6570\u636e")
    @RequestMapping(value={"/{tableId}"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public ResponseData updateObject(@PathVariable String tableId, @RequestBody String jsonString) {
        this.metaObjectService.updateObject(tableId, (Map)JSON.parseObject((String)jsonString));
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e\u5e93\u8868\u6570\u636e")
    @RequestMapping(value={"/{tableId}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData saveObject(@PathVariable String tableId, @RequestBody String jsonString) {
        this.metaObjectService.saveObject(tableId, (Map)JSON.parseObject((String)jsonString));
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e\u5e93\u8868\u6570\u636e")
    @RequestMapping(value={"/{tableId}"}, method={RequestMethod.DELETE})
    @WrapUpResponseBody
    public ResponseData deleteObject(@PathVariable String tableId, HttpServletRequest request) {
        Map parameters = MetaObjectController.collectRequestParameters((HttpServletRequest)request);
        this.metaObjectService.deleteObject(tableId, parameters);
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u83b7\u53d6\u4e00\u4e2a\u6570\u636e\u5e26\u5b50\u8868\uff0c\u4e3b\u952e\u4f5c\u4e3a\u53c2\u6570\u4ee5key-value\u5f62\u5f0f\u63d0\u4ea4")
    @RequestMapping(value={"/{tableId}/withChildren"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public Map<String, Object> getObjectWithChildren(@PathVariable String tableId, HttpServletRequest request) {
        Map parameters = MetaObjectController.collectRequestParameters((HttpServletRequest)request);
        return this.metaObjectService.getObjectWithChildren(tableId, parameters, 1);
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e\u5e93\u8868\u6570\u636e\u5e26\u5b50\u8868")
    @RequestMapping(value={"/{tableId}/withChildren"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public ResponseData updateObjectWithChildren(@PathVariable String tableId, @RequestBody String jsonString) {
        this.metaObjectService.mergeObjectWithChildren(tableId, (Map)JSON.parseObject((String)jsonString));
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e\u5e93\u8868\u6570\u636e\u5e26\u5b50\u8868")
    @RequestMapping(value={"/{tableId}/withChildren"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData saveObjectWithChildren(@PathVariable String tableId, @RequestBody String jsonString) {
        this.metaObjectService.saveObjectWithChildren(tableId, (Map)JSON.parseObject((String)jsonString));
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e\u5e93\u8868\u6570\u636e\u5e26\u5b50\u8868")
    @RequestMapping(value={"/{tableId}/withChildren"}, method={RequestMethod.DELETE})
    @WrapUpResponseBody
    public ResponseData deleteObjectWithChildren(@PathVariable String tableId, HttpServletRequest request) {
        Map parameters = MetaObjectController.collectRequestParameters((HttpServletRequest)request);
        this.metaObjectService.deleteObjectWithChildren(tableId, parameters);
        return ResponseData.makeSuccessResponse();
    }
}

