/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.dataopt.bizopt;

import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.ObjectException;
import com.centit.framework.ip.po.DatabaseInfo;
import com.centit.framework.ip.service.IntegrationEnvironment;
import com.centit.product.metadata.po.MetaTable;
import com.centit.product.metadata.service.MetaDataService;
import com.centit.product.metadata.utils.JdbcConnect;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.dataopt.bizopt.BuiltInOperation;
import com.centit.support.dataopt.core.BizModel;
import com.centit.support.dataopt.core.DataSet;
import com.centit.support.dataopt.dataset.SQLDataSetWriter;
import org.apache.commons.lang3.StringUtils;

public class DatabaseBizOperation
extends BuiltInOperation {
    private IntegrationEnvironment integrationEnvironment;
    private MetaDataService metaDataService;

    public DatabaseBizOperation() {
    }

    public DatabaseBizOperation(JSONObject bizOptJson) {
        this.bizOptJson = bizOptJson;
    }

    private BizModel runPersistence(BizModel bizModel, JSONObject bizOptJson) {
        String sourDSName = this.getJsonFieldString(bizOptJson, "source", bizModel.getModelName());
        String databaseCode = this.getJsonFieldString(bizOptJson, "databaseCode", null);
        String tableName = this.getJsonFieldString(bizOptJson, "tableName", null);
        String writerType = this.getJsonFieldString(bizOptJson, "writerType", "merge");
        if (databaseCode == null || tableName == null) {
            throw new ObjectException((Object)bizOptJson, 620, "\u5bf9\u5e94\u7684\u5143\u6570\u636e\u4fe1\u606f\u627e\u4e0d\u5230\uff0c\u6570\u636e\u5e93\uff1a" + databaseCode + " \u8868:" + databaseCode);
        }
        DatabaseInfo databaseInfo = this.integrationEnvironment.getDatabaseInfo(databaseCode);
        if (databaseInfo == null) {
            throw new ObjectException((Object)bizOptJson, 620, "\u6570\u636e\u5e93\u4fe1\u606f\u65e0\u6548\uff1a" + databaseCode);
        }
        DataSet dataSet = bizModel.fetchDataSetByName(sourDSName);
        if (dataSet == null) {
            throw new ObjectException((Object)bizOptJson, 620, "\u6570\u636e\u6e90\u4fe1\u606f\u65e0\u6548\uff1a" + sourDSName);
        }
        MetaTable tableInfo = this.metaDataService.getMetaTable(databaseCode, tableName);
        if (tableInfo == null) {
            throw new ObjectException((Object)bizOptJson, 620, "\u5bf9\u5e94\u7684\u5143\u6570\u636e\u4fe1\u606f\u627e\u4e0d\u5230\uff0c\u6570\u636e\u5e93\uff1a" + databaseCode + " \u8868:" + databaseCode);
        }
        SQLDataSetWriter dataSetWriter = new SQLDataSetWriter(JdbcConnect.mapDataSource((DatabaseInfo)databaseInfo), (TableInfo)tableInfo);
        switch (writerType) {
            case "append": {
                dataSetWriter.append(dataSet);
                break;
            }
            case "merge": 
            case "update": {
                dataSetWriter.merge(dataSet);
                break;
            }
            default: {
                dataSetWriter.save(dataSet);
            }
        }
        return bizModel;
    }

    protected BizModel runOneStep(BizModel bizModel, JSONObject bizOptJson) {
        String sOptType = bizOptJson.getString("operation");
        if (StringUtils.isBlank((CharSequence)sOptType)) {
            return bizModel;
        }
        switch (sOptType) {
            case "map": {
                return this.runMap(bizModel, bizOptJson);
            }
            case "filter": {
                return this.runFilter(bizModel, bizOptJson);
            }
            case "append": {
                return this.runAppend(bizModel, bizOptJson);
            }
            case "stat": {
                return this.runStat(bizModel, bizOptJson);
            }
            case "analyse": {
                return this.runAnalyse(bizModel, bizOptJson);
            }
            case "cross": {
                return this.runCross(bizModel, bizOptJson);
            }
            case "compare": {
                return this.runCompare(bizModel, bizOptJson);
            }
            case "join": {
                return this.runJoin(bizModel, bizOptJson);
            }
            case "persistence": {
                return this.runPersistence(bizModel, bizOptJson);
            }
        }
        return bizModel;
    }

    public void setIntegrationEnvironment(IntegrationEnvironment integrationEnvironment) {
        this.integrationEnvironment = integrationEnvironment;
    }

    public void setMetaDataService(MetaDataService metaDataService) {
        this.metaDataService = metaDataService;
    }
}

