/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.po;

import com.alibaba.fastjson2.annotation.JSONField;
import com.centit.framework.core.dao.DictionaryMap;
import com.centit.product.metadata.po.MetaColumn;
import com.centit.product.metadata.po.MetaRelation;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.compiler.Lexer;
import com.centit.support.database.metadata.SimpleTableInfo;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.metadata.TableReference;
import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import com.centit.support.database.utils.DBType;
import com.centit.support.security.DesensitizeOptUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

@ApiModel(value="\u8868\u5143\u6570\u636e")
@Entity
@Table(name="F_MD_TABLE")
public class MetaTable
implements TableInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String OBJECT_AS_CLOB_ID_FIELD = "OBJECT_ID";
    public static final String OBJECT_AS_CLOB_ID_PROP = "objectId";
    public static final String OBJECT_AS_CLOB_FIELD = "OBJECT_JSON";
    public static final String OBJECT_AS_CLOB_PROP = "objectJson";
    public static final String WORKFLOW_INST_ID_FIELD = "FLOW_INST_ID";
    public static final String WORKFLOW_INST_ID_PROP = "flowInstId";
    public static final String WORKFLOW_NODE_INST_ID_FIELD = "NODE_INST_ID";
    public static final String WORKFLOW_NODE_INST_ID_PROP = "nodeInstId";
    private static final String PRIMARY_KEY_PREFIX = "PK_";
    @Id
    @Column(name="TABLE_ID")
    @ApiModelProperty(value="\u8868ID")
    @ValueGenerator(strategy=GeneratorType.UUID22)
    private String tableId;
    @Column(name="DATABASE_CODE")
    @ApiModelProperty(value="\u6570\u636e\u5e93ID")
    private String databaseCode;
    @Column(name="TABLE_TYPE")
    @NotBlank
    @Pattern(regexp="[TVC]")
    @Length(max=1)
    @ApiModelProperty(value="\u8868\u7c7b\u522b\uff08T-\u8868\uff1bV-\u89c6\u56fe\uff1bC-\u5927\u5b57\u6bb5\uff09")
    @DictionaryMap(fieldName={"tableTypeText"}, value={"TableType"})
    private @NotBlank @Pattern(regexp="[TVC]") @Length(max=1) String tableType;
    @ApiModelProperty(value="\u8868\u7684\u5b58\u50a8\u7c7b\u522b  H\uff1a\u9690\u85cf\uff1bR\uff1a\u53ea\u8bfb\uff1bN\uff1a\u53ef\u8bfb\u5199)")
    @Column(name="ACCESS_TYPE")
    @NotBlank
    @Pattern(regexp="[HRCN]")
    @Length(max=1)
    private @NotBlank @Pattern(regexp="[HRCN]") @Length(max=1) String accessType = "N";
    @Column(name="TABLE_NAME")
    @NotBlank
    @Length(max=64)
    @ApiModelProperty(value="\u8868\u540d")
    private @NotBlank @Length(max=64) String tableName;
    @Column(name="TABLE_LABEL_NAME")
    @NotBlank
    @Length(max=200)
    @ApiModelProperty(value="\u8868\u4e2d\u6587\u540d")
    private @NotBlank @Length(max=200) String tableLabelName;
    @ApiModelProperty(value="\u8868\u63cf\u8ff0")
    @Column(name="TABLE_COMMENT")
    @Length(max=256)
    private @Length(max=256) String tableComment;
    @Column(name="WORKFLOW_OPT_TYPE")
    @NotBlank
    @Pattern(regexp="[0-2]")
    @Length(max=1)
    private @NotBlank @Pattern(regexp="[0-2]") @Length(max=1) String workFlowOptType = "0";
    @Column(name="FULLTEXT_SEARCH")
    @NotBlank
    @Length(max=1)
    private @NotBlank @Length(max=1) Boolean fulltextSearch = false;
    @ApiModelProperty(value="\u5bf9\u8c61\u6807\u9898\u6a21\u677f\uff0c\u7528\u4e8e\u5168\u6587\u68c0\u7d22\u65f6\u7684\u6807\u9898\u663e\u793a")
    @Column(name="OBJECT_TITLE")
    @Length(max=500)
    private @Length(max=500) String objectTitle;
    @Column(name="WRITE_OPT_LOG")
    @NotBlank
    @Length(max=1)
    private @NotBlank @Length(max=1) Boolean writeOptLog = false;
    @Column(name="DELETE_TAG_FIELD")
    @Length(max=100)
    private @Length(max=100) String deleteTagField;
    @Column(name="CHECK_VERSION_FIELD")
    @Length(max=100)
    private @Length(max=100) String checkVersionField;
    @Column(name="RECORD_DATE")
    @ValueGenerator(strategy=GeneratorType.FUNCTION, condition=GeneratorCondition.ALWAYS, value="today()")
    private Date recordDate;
    @Column(name="RECORDER")
    @Length(max=64)
    @DictionaryMap(fieldName={"recorderName"}, value={"userCode"})
    private @Length(max=64) String recorder;
    @OneToMany(targetEntity=MetaColumn.class)
    @JoinColumn(name="TABLE_ID", referencedColumnName="TABLE_ID")
    private List<MetaColumn> mdColumns;
    @OneToMany(targetEntity=MetaRelation.class)
    @JoinColumn(name="tableId", referencedColumnName="parentTableId")
    private List<MetaRelation> mdRelations;
    @OneToMany(targetEntity=MetaRelation.class)
    @JoinColumn(name="tableId", referencedColumnName="childTableId")
    private List<MetaRelation> parents;
    @Transient
    @ApiModelProperty(hidden=true)
    private DBType databaseType;

    public void setDatabaseType(DBType databaseType) {
        this.databaseType = databaseType;
        if (this.mdColumns != null) {
            for (MetaColumn col : this.mdColumns) {
                col.setDatabaseType(databaseType);
            }
        }
    }

    public List<MetaColumn> getMdColumns() {
        if (this.mdColumns == null) {
            this.mdColumns = new ArrayList<MetaColumn>();
        }
        return this.mdColumns;
    }

    public void addMdColumn(MetaColumn mdColumn) {
        if (this.mdColumns == null) {
            this.mdColumns = new ArrayList<MetaColumn>();
        }
        this.mdColumns.add(mdColumn);
    }

    public void removeMdColumn(MetaColumn mdColumn) {
        if (this.mdColumns == null) {
            return;
        }
        this.mdColumns.remove(mdColumn);
    }

    public MetaColumn newMdColumn() {
        MetaColumn res = new MetaColumn();
        res.setTableId(this.getTableId());
        return res;
    }

    public final List<String> extraVersionFields() {
        if (StringUtils.isBlank((CharSequence)this.checkVersionField)) {
            return null;
        }
        String[] ss = StringUtils.split((String)this.checkVersionField, (String)",");
        if (ss == null) {
            return null;
        }
        ArrayList<String> fields = new ArrayList<String>(ss.length + 1);
        for (String s : ss) {
            if (!StringUtils.isNotBlank((CharSequence)s)) continue;
            fields.add(s.trim());
        }
        return fields;
    }

    public final Map<String, Object> extraDeleteTag() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Lexer lexer = new Lexer(this.deleteTagField);
        String field = lexer.getAWord();
        while (StringUtils.isNotBlank((CharSequence)field)) {
            MetaColumn mc;
            String aWord = lexer.getAWord();
            String defaultValue = "1";
            if ("=".equals(aWord) && StringUtils.isNotBlank((CharSequence)(aWord = lexer.getAWord()))) {
                defaultValue = StringRegularOpt.trimString((String)aWord);
                aWord = lexer.getAWord();
            }
            if ((mc = this.findFieldByColumn(field)) != null) {
                params.put(mc.getPropertyName(), defaultValue);
            }
            if (!StringUtils.equalsAny((CharSequence)aWord, (CharSequence[])new CharSequence[]{",", "&"})) break;
            field = lexer.getAWord();
        }
        return params;
    }

    public List<MetaRelation> getParents() {
        if (this.parents == null) {
            this.parents = new ArrayList<MetaRelation>(4);
        }
        return this.parents;
    }

    public void addParent(MetaRelation parent) {
        this.getParents().add(parent);
    }

    public void removeParent(MetaRelation parent) {
        if (this.parents == null) {
            return;
        }
        this.parents.remove(parent);
    }

    public List<MetaRelation> getMdRelations() {
        if (this.mdRelations == null) {
            this.mdRelations = new ArrayList<MetaRelation>(4);
        }
        return this.mdRelations;
    }

    public void addMdRelation(MetaRelation mdRelation) {
        this.getMdRelations().add(mdRelation);
    }

    public void removeMdRelation(MetaRelation mdRelation) {
        if (this.mdRelations == null) {
            return;
        }
        this.mdRelations.remove(mdRelation);
    }

    public boolean isWriteOptLog() {
        return this.writeOptLog != null && this.writeOptLog != false;
    }

    public boolean isFulltextSearch() {
        return this.fulltextSearch != null && this.fulltextSearch != false;
    }

    public MetaTable convertFromDbTable(SimpleTableInfo tableInfo) {
        this.tableName = tableInfo.getTableName();
        if (StringUtils.isNotBlank((CharSequence)tableInfo.getTableLabelName())) {
            this.tableLabelName = tableInfo.getTableLabelName();
        }
        if (StringUtils.isNotBlank((CharSequence)tableInfo.getTableComment())) {
            this.tableComment = tableInfo.getTableComment();
        }
        this.tableType = tableInfo.getTableType();
        this.accessType = StringUtils.isBlank((CharSequence)this.accessType) ? "N" : this.accessType;
        return this;
    }

    @ApiModelProperty(hidden=true)
    @JSONField(serialize=false)
    public String getPkName() {
        return PRIMARY_KEY_PREFIX + this.tableLabelName;
    }

    @ApiModelProperty(hidden=true)
    public String getSchema() {
        return null;
    }

    @ApiModelProperty(hidden=true)
    public String getOrderBy() {
        return null;
    }

    public MetaColumn findFieldByName(String name) {
        if (this.mdColumns == null) {
            return null;
        }
        for (MetaColumn c : this.mdColumns) {
            if (!c.getPropertyName().equals(name)) continue;
            return c;
        }
        for (MetaColumn c : this.mdColumns) {
            if (!c.getColumnName().equalsIgnoreCase(name)) continue;
            return c;
        }
        return null;
    }

    public boolean hasGeneratedKeys() {
        for (MetaColumn c : this.mdColumns) {
            if (!"A".equals(c.getAutoCreateRule()) || !c.isPrimaryKey()) continue;
            return true;
        }
        return false;
    }

    public MetaColumn fetchGeneratedKey() {
        for (MetaColumn column : this.mdColumns) {
            if (!"A".equals(column.getAutoCreateRule()) || !column.isPrimaryKey()) continue;
            return column;
        }
        return null;
    }

    public MetaColumn findFieldByColumn(String name) {
        if (this.mdColumns == null) {
            return null;
        }
        for (MetaColumn c : this.mdColumns) {
            if (!c.getColumnName().equalsIgnoreCase(name)) continue;
            return c;
        }
        for (MetaColumn c : this.mdColumns) {
            if (!c.getPropertyName().equals(name)) continue;
            return c;
        }
        return null;
    }

    @ApiModelProperty(hidden=true)
    @JSONField(serialize=false)
    public List<MetaColumn> getColumns() {
        return this.mdColumns;
    }

    @ApiModelProperty(hidden=true)
    @JSONField(serialize=false)
    public List<? extends TableReference> getReferences() {
        return this.mdRelations;
    }

    @ApiModelProperty(hidden=true)
    public String getTableLabelName() {
        return this.tableLabelName;
    }

    public Map<String, DesensitizeOptUtils.SensitiveTypeEnum> fetchDesensitizeOpt() {
        HashMap<String, DesensitizeOptUtils.SensitiveTypeEnum> optMap = new HashMap<String, DesensitizeOptUtils.SensitiveTypeEnum>();
        if (this.mdColumns == null) {
            return optMap;
        }
        for (MetaColumn c : this.mdColumns) {
            DesensitizeOptUtils.SensitiveTypeEnum desenOpt = DesensitizeOptUtils.mapSensitiveType((String)c.getSensitiveType());
            if (DesensitizeOptUtils.SensitiveTypeEnum.NONE == desenOpt) continue;
            optMap.put(c.getPropertyName(), desenOpt);
        }
        return optMap;
    }

    public String getTableId() {
        return this.tableId;
    }

    public String getDatabaseCode() {
        return this.databaseCode;
    }

    public String getTableType() {
        return this.tableType;
    }

    public String getAccessType() {
        return this.accessType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableComment() {
        return this.tableComment;
    }

    public String getWorkFlowOptType() {
        return this.workFlowOptType;
    }

    public Boolean getFulltextSearch() {
        return this.fulltextSearch;
    }

    public String getObjectTitle() {
        return this.objectTitle;
    }

    public Boolean getWriteOptLog() {
        return this.writeOptLog;
    }

    public String getDeleteTagField() {
        return this.deleteTagField;
    }

    public String getCheckVersionField() {
        return this.checkVersionField;
    }

    public Date getRecordDate() {
        return this.recordDate;
    }

    public String getRecorder() {
        return this.recorder;
    }

    public DBType getDatabaseType() {
        return this.databaseType;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public void setDatabaseCode(String databaseCode) {
        this.databaseCode = databaseCode;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public void setAccessType(String accessType) {
        this.accessType = accessType;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setTableLabelName(String tableLabelName) {
        this.tableLabelName = tableLabelName;
    }

    public void setTableComment(String tableComment) {
        this.tableComment = tableComment;
    }

    public void setWorkFlowOptType(String workFlowOptType) {
        this.workFlowOptType = workFlowOptType;
    }

    public void setFulltextSearch(Boolean fulltextSearch) {
        this.fulltextSearch = fulltextSearch;
    }

    public void setObjectTitle(String objectTitle) {
        this.objectTitle = objectTitle;
    }

    public void setWriteOptLog(Boolean writeOptLog) {
        this.writeOptLog = writeOptLog;
    }

    public void setDeleteTagField(String deleteTagField) {
        this.deleteTagField = deleteTagField;
    }

    public void setCheckVersionField(String checkVersionField) {
        this.checkVersionField = checkVersionField;
    }

    public void setRecordDate(Date recordDate) {
        this.recordDate = recordDate;
    }

    public void setRecorder(String recorder) {
        this.recorder = recorder;
    }

    public void setMdColumns(List<MetaColumn> mdColumns) {
        this.mdColumns = mdColumns;
    }

    public void setMdRelations(List<MetaRelation> mdRelations) {
        this.mdRelations = mdRelations;
    }

    public void setParents(List<MetaRelation> parents) {
        this.parents = parents;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaTable)) {
            return false;
        }
        MetaTable other = (MetaTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$fulltextSearch = this.getFulltextSearch();
        Boolean other$fulltextSearch = other.getFulltextSearch();
        if (this$fulltextSearch == null ? other$fulltextSearch != null : !((Object)this$fulltextSearch).equals(other$fulltextSearch)) {
            return false;
        }
        Boolean this$writeOptLog = this.getWriteOptLog();
        Boolean other$writeOptLog = other.getWriteOptLog();
        if (this$writeOptLog == null ? other$writeOptLog != null : !((Object)this$writeOptLog).equals(other$writeOptLog)) {
            return false;
        }
        String this$tableId = this.getTableId();
        String other$tableId = other.getTableId();
        if (this$tableId == null ? other$tableId != null : !this$tableId.equals(other$tableId)) {
            return false;
        }
        String this$databaseCode = this.getDatabaseCode();
        String other$databaseCode = other.getDatabaseCode();
        if (this$databaseCode == null ? other$databaseCode != null : !this$databaseCode.equals(other$databaseCode)) {
            return false;
        }
        String this$tableType = this.getTableType();
        String other$tableType = other.getTableType();
        if (this$tableType == null ? other$tableType != null : !this$tableType.equals(other$tableType)) {
            return false;
        }
        String this$accessType = this.getAccessType();
        String other$accessType = other.getAccessType();
        if (this$accessType == null ? other$accessType != null : !this$accessType.equals(other$accessType)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$tableLabelName = this.getTableLabelName();
        String other$tableLabelName = other.getTableLabelName();
        if (this$tableLabelName == null ? other$tableLabelName != null : !this$tableLabelName.equals(other$tableLabelName)) {
            return false;
        }
        String this$tableComment = this.getTableComment();
        String other$tableComment = other.getTableComment();
        if (this$tableComment == null ? other$tableComment != null : !this$tableComment.equals(other$tableComment)) {
            return false;
        }
        String this$workFlowOptType = this.getWorkFlowOptType();
        String other$workFlowOptType = other.getWorkFlowOptType();
        if (this$workFlowOptType == null ? other$workFlowOptType != null : !this$workFlowOptType.equals(other$workFlowOptType)) {
            return false;
        }
        String this$objectTitle = this.getObjectTitle();
        String other$objectTitle = other.getObjectTitle();
        if (this$objectTitle == null ? other$objectTitle != null : !this$objectTitle.equals(other$objectTitle)) {
            return false;
        }
        String this$deleteTagField = this.getDeleteTagField();
        String other$deleteTagField = other.getDeleteTagField();
        if (this$deleteTagField == null ? other$deleteTagField != null : !this$deleteTagField.equals(other$deleteTagField)) {
            return false;
        }
        String this$checkVersionField = this.getCheckVersionField();
        String other$checkVersionField = other.getCheckVersionField();
        if (this$checkVersionField == null ? other$checkVersionField != null : !this$checkVersionField.equals(other$checkVersionField)) {
            return false;
        }
        Date this$recordDate = this.getRecordDate();
        Date other$recordDate = other.getRecordDate();
        if (this$recordDate == null ? other$recordDate != null : !((Object)this$recordDate).equals(other$recordDate)) {
            return false;
        }
        String this$recorder = this.getRecorder();
        String other$recorder = other.getRecorder();
        if (this$recorder == null ? other$recorder != null : !this$recorder.equals(other$recorder)) {
            return false;
        }
        List<MetaColumn> this$mdColumns = this.getMdColumns();
        List<MetaColumn> other$mdColumns = other.getMdColumns();
        if (this$mdColumns == null ? other$mdColumns != null : !((Object)this$mdColumns).equals(other$mdColumns)) {
            return false;
        }
        List<MetaRelation> this$mdRelations = this.getMdRelations();
        List<MetaRelation> other$mdRelations = other.getMdRelations();
        if (this$mdRelations == null ? other$mdRelations != null : !((Object)this$mdRelations).equals(other$mdRelations)) {
            return false;
        }
        List<MetaRelation> this$parents = this.getParents();
        List<MetaRelation> other$parents = other.getParents();
        if (this$parents == null ? other$parents != null : !((Object)this$parents).equals(other$parents)) {
            return false;
        }
        DBType this$databaseType = this.getDatabaseType();
        DBType other$databaseType = other.getDatabaseType();
        return !(this$databaseType == null ? other$databaseType != null : !this$databaseType.equals(other$databaseType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetaTable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $fulltextSearch = this.getFulltextSearch();
        result = result * 59 + ($fulltextSearch == null ? 43 : ((Object)$fulltextSearch).hashCode());
        Boolean $writeOptLog = this.getWriteOptLog();
        result = result * 59 + ($writeOptLog == null ? 43 : ((Object)$writeOptLog).hashCode());
        String $tableId = this.getTableId();
        result = result * 59 + ($tableId == null ? 43 : $tableId.hashCode());
        String $databaseCode = this.getDatabaseCode();
        result = result * 59 + ($databaseCode == null ? 43 : $databaseCode.hashCode());
        String $tableType = this.getTableType();
        result = result * 59 + ($tableType == null ? 43 : $tableType.hashCode());
        String $accessType = this.getAccessType();
        result = result * 59 + ($accessType == null ? 43 : $accessType.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $tableLabelName = this.getTableLabelName();
        result = result * 59 + ($tableLabelName == null ? 43 : $tableLabelName.hashCode());
        String $tableComment = this.getTableComment();
        result = result * 59 + ($tableComment == null ? 43 : $tableComment.hashCode());
        String $workFlowOptType = this.getWorkFlowOptType();
        result = result * 59 + ($workFlowOptType == null ? 43 : $workFlowOptType.hashCode());
        String $objectTitle = this.getObjectTitle();
        result = result * 59 + ($objectTitle == null ? 43 : $objectTitle.hashCode());
        String $deleteTagField = this.getDeleteTagField();
        result = result * 59 + ($deleteTagField == null ? 43 : $deleteTagField.hashCode());
        String $checkVersionField = this.getCheckVersionField();
        result = result * 59 + ($checkVersionField == null ? 43 : $checkVersionField.hashCode());
        Date $recordDate = this.getRecordDate();
        result = result * 59 + ($recordDate == null ? 43 : ((Object)$recordDate).hashCode());
        String $recorder = this.getRecorder();
        result = result * 59 + ($recorder == null ? 43 : $recorder.hashCode());
        List<MetaColumn> $mdColumns = this.getMdColumns();
        result = result * 59 + ($mdColumns == null ? 43 : ((Object)$mdColumns).hashCode());
        List<MetaRelation> $mdRelations = this.getMdRelations();
        result = result * 59 + ($mdRelations == null ? 43 : ((Object)$mdRelations).hashCode());
        List<MetaRelation> $parents = this.getParents();
        result = result * 59 + ($parents == null ? 43 : ((Object)$parents).hashCode());
        DBType $databaseType = this.getDatabaseType();
        result = result * 59 + ($databaseType == null ? 43 : $databaseType.hashCode());
        return result;
    }

    public String toString() {
        return "MetaTable(tableId=" + this.getTableId() + ", databaseCode=" + this.getDatabaseCode() + ", tableType=" + this.getTableType() + ", accessType=" + this.getAccessType() + ", tableName=" + this.getTableName() + ", tableLabelName=" + this.getTableLabelName() + ", tableComment=" + this.getTableComment() + ", workFlowOptType=" + this.getWorkFlowOptType() + ", fulltextSearch=" + this.getFulltextSearch() + ", objectTitle=" + this.getObjectTitle() + ", writeOptLog=" + this.getWriteOptLog() + ", deleteTagField=" + this.getDeleteTagField() + ", checkVersionField=" + this.getCheckVersionField() + ", recordDate=" + this.getRecordDate() + ", recorder=" + this.getRecorder() + ", mdColumns=" + this.getMdColumns() + ", mdRelations=" + this.getMdRelations() + ", parents=" + this.getParents() + ", databaseType=" + this.getDatabaseType() + ")";
    }
}

