/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.po;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.annotation.JSONField;
import com.centit.framework.core.dao.DictionaryMap;
import com.centit.product.metadata.api.ISourceInfo;
import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorTime;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import com.centit.support.security.SecurityOptUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="F_DATABASE_INFO")
@ApiModel(value="\u96c6\u6210\u8d44\u6e90\u5e93\u4fe1\u606f\u5bf9\u8c61", description="\u96c6\u6210\u8d44\u6e90\u5e93\u4fe1\u606f\u5bf9\u8c61 DatabaseInfo")
public class SourceInfo
implements ISourceInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="DATABASE_CODE")
    @ApiModelProperty(value="\u6570\u636e\u5e93\u4ee3\u7801", name="databaseCode")
    @ValueGenerator(strategy=GeneratorType.UUID22)
    private String databaseCode;
    @Column(name="OS_ID")
    @ApiModelProperty(value="\u7cfb\u7edf\u4ee3\u7801", name="osId")
    private String osId;
    @Column(name="top_unit")
    @ApiModelProperty(value="\u6240\u5c5e\u79df\u6237", name="topUnit")
    private String topUnit;
    @Column(name="DATABASE_NAME")
    @Length(max=100)
    @ApiModelProperty(value="\u6570\u636e\u5e93\u540d", name="databaseName")
    private @Length(max=100) String databaseName;
    @Column(name="DATABASE_URL")
    @Length(max=1000)
    @ApiModelProperty(value="\u6570\u636e\u5e93\u5730\u5740", name="databaseUrl")
    private @Length(max=1000) String databaseUrl;
    @Column(name="USERNAME")
    @Length(max=100)
    @ApiModelProperty(value="\u6570\u636e\u5e93\u7528\u6237\u540d", name="username")
    private @Length(max=100) String username;
    @Column(name="PASSWORD")
    @Length(max=100)
    @ApiModelProperty(value="\u6570\u636e\u5e93\u5bc6\u7801", name="password")
    private @Length(max=100) String password;
    @Column(name="DATABASE_DESC")
    @Length(max=500)
    @ApiModelProperty(value="\u6570\u636e\u5e93\u63cf\u8ff0\u4fe1\u606f", name="databaseDesc")
    private @Length(max=500) String databaseDesc;
    @ApiModelProperty(value="\u4fee\u6539\u65f6\u95f4", name="lastModifyDate")
    @ValueGenerator(strategy=GeneratorType.FUNCTION, value="today()", condition=GeneratorCondition.ALWAYS, occasion=GeneratorTime.ALWAYS)
    @Column(name="LAST_MODIFY_DATE")
    private Date lastModifyDate;
    @ApiModelProperty(value="\u521b\u5efa\u4eba", name="CREATED")
    @Column(name="CREATED")
    @Length(max=32)
    @DictionaryMap(fieldName={"createUserName"}, value={"userCode"})
    private @Length(max=32) String created;
    @ApiModelProperty(value="\u521b\u5efa\u65f6\u95f4", name="CREATE_TIME")
    @ValueGenerator(strategy=GeneratorType.FUNCTION, value="today()")
    @Column(name="CREATE_TIME")
    private Date createTime;
    @ApiModelProperty(value="\u6269\u5c55\u5c5e\u6027\uff0cjson\u683c\u5f0f\uff0cclob\u5b57\u6bb5")
    @Column(name="EXT_PROPS")
    @Basic(fetch=FetchType.LAZY)
    private JSONObject extProps;
    @ApiModelProperty(value="\u8d44\u6e90\u7c7b\u578b,D:\u5173\u7cfb\u6570\u636e\u5e93 M:MongoDb R:redis E:elssearch K:kafka B:rabbitmq,H http\u670d\u52a1", name="SOURCE_TYPE")
    @Column(name="SOURCE_TYPE")
    private String sourceType;

    public SourceInfo() {
    }

    public void setDatabaseUrl(String databaseUrl) {
        this.databaseUrl = StringUtils.trim((String)databaseUrl);
    }

    public SourceInfo(String databaseCode, String databaseName) {
        this.databaseCode = databaseCode;
        this.databaseName = databaseName;
    }

    public SourceInfo(String databaseCode, String databaseName, String databaseUrl, String username, String password, String dataDesc) {
        this.databaseCode = databaseCode;
        this.databaseName = databaseName;
        this.databaseUrl = StringUtils.trim((String)databaseUrl);
        this.username = username;
        this.password = password;
        this.databaseDesc = dataDesc;
    }

    public void setPassword(String pwd) {
        if (StringUtils.isNotBlank((CharSequence)pwd)) {
            this.password = pwd.startsWith("cipher:") ? pwd : SecurityOptUtils.encodeSecurityString((String)pwd, (String)"cipher");
        }
    }

    @JSONField(serialize=false)
    public String getClearPassword() {
        return SecurityOptUtils.decodeSecurityString((String)this.password);
    }

    public boolean equals(Object dbco) {
        if (this == dbco) {
            return true;
        }
        if (dbco instanceof ISourceInfo) {
            ISourceInfo dbc = (ISourceInfo)dbco;
            return this.databaseUrl != null && this.databaseUrl.equals(dbc.getDatabaseUrl()) && this.databaseCode != null && this.databaseCode.equals(dbc.getDatabaseCode()) && (this.username == null && dbc.getUsername() == null || this.username != null && this.username.equals(dbc.getUsername())) && (this.password == null && dbc.getPassword() == null || this.password != null && this.password.equals(dbc.getPassword())) && (this.extProps == null && dbc.getExtProps() == null || this.extProps != null && this.extProps.equals((Object)dbc.getExtProps()));
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.databaseUrl == null ? 0 : this.databaseUrl.hashCode());
        result = 37 * result + (this.databaseCode == null ? 0 : this.databaseCode.hashCode());
        result = 37 * result + (this.username == null ? 0 : this.getUsername().hashCode());
        result = 37 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 37 * result + (this.extProps == null ? 0 : this.extProps.hashCode());
        return result;
    }

    public String getDatabaseCode() {
        return this.databaseCode;
    }

    public String getOsId() {
        return this.osId;
    }

    public String getTopUnit() {
        return this.topUnit;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabaseDesc() {
        return this.databaseDesc;
    }

    public Date getLastModifyDate() {
        return this.lastModifyDate;
    }

    public String getCreated() {
        return this.created;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public JSONObject getExtProps() {
        return this.extProps;
    }

    @Override
    public String getSourceType() {
        return this.sourceType;
    }

    public void setDatabaseCode(String databaseCode) {
        this.databaseCode = databaseCode;
    }

    public void setOsId(String osId) {
        this.osId = osId;
    }

    public void setTopUnit(String topUnit) {
        this.topUnit = topUnit;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setDatabaseDesc(String databaseDesc) {
        this.databaseDesc = databaseDesc;
    }

    public void setLastModifyDate(Date lastModifyDate) {
        this.lastModifyDate = lastModifyDate;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setExtProps(JSONObject extProps) {
        this.extProps = extProps;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String toString() {
        return "SourceInfo(databaseCode=" + this.getDatabaseCode() + ", osId=" + this.getOsId() + ", topUnit=" + this.getTopUnit() + ", databaseName=" + this.getDatabaseName() + ", databaseUrl=" + this.getDatabaseUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", databaseDesc=" + this.getDatabaseDesc() + ", lastModifyDate=" + this.getLastModifyDate() + ", created=" + this.getCreated() + ", createTime=" + this.getCreateTime() + ", extProps=" + this.getExtProps() + ", sourceType=" + this.getSourceType() + ")";
    }
}

