/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.adapter.po;

import com.alibaba.fastjson.annotation.JSONField;
import com.centit.framework.core.dao.DictionaryMap;
import com.centit.product.adapter.po.MetaRelDetail;
import com.centit.product.adapter.po.MetaTable;
import com.centit.support.database.metadata.TableReference;
import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorTime;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import com.centit.support.database.utils.FieldType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

@ApiModel
@Entity
@Table(name="F_MD_RELATION")
public class MetaRelation
implements TableReference,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="RELATION_ID")
    @ApiModelProperty(hidden=true)
    @ValueGenerator(strategy=GeneratorType.UUID)
    private String relationId;
    @ApiModelProperty(value="\u4e3b\u8868ID")
    @Column(name="PARENT_TABLE_ID")
    private String parentTableId;
    @ApiModelProperty(value="\u4ece\u8868ID")
    @Column(name="CHILD_TABLE_ID")
    private String childTableId;
    @ApiModelProperty(value="\u5173\u8054\u540d\u79f0")
    @Column(name="RELATION_NAME")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=64, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a") @Length(max=64, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String relationName;
    @ApiModelProperty(value="\u72b6\u6001")
    @Column(name="RELATION_STATE")
    private String relationState = "T";
    @ApiModelProperty(value="\u63cf\u8ff0")
    @Column(name="RELATION_COMMENT")
    @Length(max=256, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=256, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String relationComment;
    @ApiModelProperty(value="\u66f4\u6539\u4eba\u5458", hidden=true)
    @Column(name="RECORDER")
    @Length(max=8, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @DictionaryMap(fieldName={"recorderName"}, value={"userCode"})
    private @Length(max=8, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String recorder;
    @ApiModelProperty(hidden=true)
    @ValueGenerator(strategy=GeneratorType.FUNCTION, occasion=GeneratorTime.NEW_UPDATE, condition=GeneratorCondition.ALWAYS, value="today()")
    @Column(name="LAST_MODIFY_DATE")
    private Date lastModifyDate;
    @ApiModelProperty(hidden=true)
    @OneToMany(targetEntity=MetaTable.class)
    @JoinColumn(name="parentTableId", referencedColumnName="tableId")
    @JSONField(serialize=false)
    private MetaTable parentTable;
    @ApiModelProperty(hidden=true)
    @OneToMany(targetEntity=MetaTable.class)
    @JoinColumn(name="childTableId", referencedColumnName="tableId")
    @JSONField(serialize=false)
    private MetaTable childTable;
    @ApiModelProperty(value="\u5173\u8054\u660e\u7ec6")
    @OneToMany(targetEntity=MetaRelDetail.class)
    @JoinColumn(name="relationId", referencedColumnName="relationId")
    private List<MetaRelDetail> relationDetails;

    @ApiModelProperty(hidden=true)
    @JSONField(serialize=false)
    public String getReferenceCode() {
        return String.valueOf(this.relationId);
    }

    @ApiModelProperty(hidden=true)
    @JSONField(serialize=false)
    public String getReferenceName() {
        return this.relationName;
    }

    @ApiModelProperty(value="\u5b50\u8868\u540d\u79f0")
    public String getTableName() {
        return this.childTable == null ? null : this.childTable.getTableName();
    }

    @ApiModelProperty(value="\u7236\u8868\u540d\u79f0")
    public String getParentTableName() {
        return this.parentTable == null ? null : this.parentTable.getTableName();
    }

    @ApiModelProperty(hidden=true)
    public Map<String, String> getReferenceColumns() {
        if (this.relationDetails == null || this.relationDetails.size() < 1) {
            return null;
        }
        HashMap<String, String> colMap = new HashMap<String, String>(this.relationDetails.size() + 1);
        for (MetaRelDetail mrd : this.relationDetails) {
            colMap.put(mrd.getParentColumnCode(), mrd.getChildColumnCode());
        }
        return colMap;
    }

    @ApiModelProperty(hidden=true)
    public boolean containColumn(String sCol) {
        if (this.relationDetails == null || this.relationDetails.size() < 1) {
            return false;
        }
        for (MetaRelDetail mrd : this.relationDetails) {
            if (!StringUtils.equals((CharSequence)sCol, (CharSequence)mrd.getChildColumnCode())) continue;
            return true;
        }
        return false;
    }

    private Object fetchObjectColumn(Map<String, Object> parentObject, String columnName) {
        Object fkValue = parentObject.get(FieldType.mapPropName((String)columnName));
        if (fkValue == null) {
            fkValue = parentObject.get(columnName);
        }
        return fkValue;
    }

    public Map<String, Object> fetchChildFk(Map<String, Object> parentObject) {
        HashMap<String, Object> fk = new HashMap<String, Object>(8);
        if (this.relationDetails == null) {
            return null;
        }
        for (MetaRelDetail mrd : this.relationDetails) {
            Object fkValue = this.fetchObjectColumn(parentObject, mrd.getParentColumnCode());
            if (fkValue == null) {
                return null;
            }
            fk.put(FieldType.mapPropName((String)mrd.getChildColumnCode()), fkValue);
        }
        return fk;
    }

    public Map<String, Object> fetchParentPk(Map<String, Object> childObject) {
        HashMap<String, Object> pk = new HashMap<String, Object>(8);
        for (MetaRelDetail mrd : this.relationDetails) {
            Object pkValue = this.fetchObjectColumn(childObject, mrd.getChildColumnCode());
            if (pkValue == null) {
                return null;
            }
            pk.put(FieldType.mapPropName((String)mrd.getParentColumnCode()), pkValue);
        }
        return pk;
    }

    public String getRelationId() {
        return this.relationId;
    }

    public String getParentTableId() {
        return this.parentTableId;
    }

    public String getChildTableId() {
        return this.childTableId;
    }

    public String getRelationName() {
        return this.relationName;
    }

    public String getRelationState() {
        return this.relationState;
    }

    public String getRelationComment() {
        return this.relationComment;
    }

    public String getRecorder() {
        return this.recorder;
    }

    public Date getLastModifyDate() {
        return this.lastModifyDate;
    }

    public MetaTable getParentTable() {
        return this.parentTable;
    }

    public MetaTable getChildTable() {
        return this.childTable;
    }

    public List<MetaRelDetail> getRelationDetails() {
        return this.relationDetails;
    }

    public void setRelationId(String relationId) {
        this.relationId = relationId;
    }

    public void setParentTableId(String parentTableId) {
        this.parentTableId = parentTableId;
    }

    public void setChildTableId(String childTableId) {
        this.childTableId = childTableId;
    }

    public void setRelationName(String relationName) {
        this.relationName = relationName;
    }

    public void setRelationState(String relationState) {
        this.relationState = relationState;
    }

    public void setRelationComment(String relationComment) {
        this.relationComment = relationComment;
    }

    public void setRecorder(String recorder) {
        this.recorder = recorder;
    }

    public void setLastModifyDate(Date lastModifyDate) {
        this.lastModifyDate = lastModifyDate;
    }

    public void setParentTable(MetaTable parentTable) {
        this.parentTable = parentTable;
    }

    public void setChildTable(MetaTable childTable) {
        this.childTable = childTable;
    }

    public void setRelationDetails(List<MetaRelDetail> relationDetails) {
        this.relationDetails = relationDetails;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaRelation)) {
            return false;
        }
        MetaRelation other = (MetaRelation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$relationId = this.getRelationId();
        String other$relationId = other.getRelationId();
        if (this$relationId == null ? other$relationId != null : !this$relationId.equals(other$relationId)) {
            return false;
        }
        String this$parentTableId = this.getParentTableId();
        String other$parentTableId = other.getParentTableId();
        if (this$parentTableId == null ? other$parentTableId != null : !this$parentTableId.equals(other$parentTableId)) {
            return false;
        }
        String this$childTableId = this.getChildTableId();
        String other$childTableId = other.getChildTableId();
        if (this$childTableId == null ? other$childTableId != null : !this$childTableId.equals(other$childTableId)) {
            return false;
        }
        String this$relationName = this.getRelationName();
        String other$relationName = other.getRelationName();
        if (this$relationName == null ? other$relationName != null : !this$relationName.equals(other$relationName)) {
            return false;
        }
        String this$relationState = this.getRelationState();
        String other$relationState = other.getRelationState();
        if (this$relationState == null ? other$relationState != null : !this$relationState.equals(other$relationState)) {
            return false;
        }
        String this$relationComment = this.getRelationComment();
        String other$relationComment = other.getRelationComment();
        if (this$relationComment == null ? other$relationComment != null : !this$relationComment.equals(other$relationComment)) {
            return false;
        }
        String this$recorder = this.getRecorder();
        String other$recorder = other.getRecorder();
        if (this$recorder == null ? other$recorder != null : !this$recorder.equals(other$recorder)) {
            return false;
        }
        Date this$lastModifyDate = this.getLastModifyDate();
        Date other$lastModifyDate = other.getLastModifyDate();
        if (this$lastModifyDate == null ? other$lastModifyDate != null : !((Object)this$lastModifyDate).equals(other$lastModifyDate)) {
            return false;
        }
        MetaTable this$parentTable = this.getParentTable();
        MetaTable other$parentTable = other.getParentTable();
        if (this$parentTable == null ? other$parentTable != null : !((Object)this$parentTable).equals(other$parentTable)) {
            return false;
        }
        MetaTable this$childTable = this.getChildTable();
        MetaTable other$childTable = other.getChildTable();
        if (this$childTable == null ? other$childTable != null : !((Object)this$childTable).equals(other$childTable)) {
            return false;
        }
        List<MetaRelDetail> this$relationDetails = this.getRelationDetails();
        List<MetaRelDetail> other$relationDetails = other.getRelationDetails();
        return !(this$relationDetails == null ? other$relationDetails != null : !((Object)this$relationDetails).equals(other$relationDetails));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetaRelation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $relationId = this.getRelationId();
        result = result * 59 + ($relationId == null ? 43 : $relationId.hashCode());
        String $parentTableId = this.getParentTableId();
        result = result * 59 + ($parentTableId == null ? 43 : $parentTableId.hashCode());
        String $childTableId = this.getChildTableId();
        result = result * 59 + ($childTableId == null ? 43 : $childTableId.hashCode());
        String $relationName = this.getRelationName();
        result = result * 59 + ($relationName == null ? 43 : $relationName.hashCode());
        String $relationState = this.getRelationState();
        result = result * 59 + ($relationState == null ? 43 : $relationState.hashCode());
        String $relationComment = this.getRelationComment();
        result = result * 59 + ($relationComment == null ? 43 : $relationComment.hashCode());
        String $recorder = this.getRecorder();
        result = result * 59 + ($recorder == null ? 43 : $recorder.hashCode());
        Date $lastModifyDate = this.getLastModifyDate();
        result = result * 59 + ($lastModifyDate == null ? 43 : ((Object)$lastModifyDate).hashCode());
        MetaTable $parentTable = this.getParentTable();
        result = result * 59 + ($parentTable == null ? 43 : ((Object)$parentTable).hashCode());
        MetaTable $childTable = this.getChildTable();
        result = result * 59 + ($childTable == null ? 43 : ((Object)$childTable).hashCode());
        List<MetaRelDetail> $relationDetails = this.getRelationDetails();
        result = result * 59 + ($relationDetails == null ? 43 : ((Object)$relationDetails).hashCode());
        return result;
    }

    public String toString() {
        return "MetaRelation(relationId=" + this.getRelationId() + ", parentTableId=" + this.getParentTableId() + ", childTableId=" + this.getChildTableId() + ", relationName=" + this.getRelationName() + ", relationState=" + this.getRelationState() + ", relationComment=" + this.getRelationComment() + ", recorder=" + this.getRecorder() + ", lastModifyDate=" + this.getLastModifyDate() + ", parentTable=" + this.getParentTable() + ", childTable=" + this.getChildTable() + ", relationDetails=" + this.getRelationDetails() + ")";
    }
}

