/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.adapter.po;

import com.centit.framework.core.dao.DictionaryMap;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorTime;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.validator.constraints.Length;

@ApiModel
@Entity
@Table(name="F_META_CHANG_LOG")
public class MetaChangLog
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="\u7f16\u53f7", hidden=true)
    @Id
    @Column(name="CHANGE_ID")
    @ValueGenerator(strategy=GeneratorType.UUID22)
    private String changeId;
    @ApiModelProperty(value="\u8868ID", hidden=true)
    @Column(name="TABLE_ID")
    private String tableID;
    @ApiModelProperty(value="\u6570\u636e\u5e93ID")
    @Column(name="DATABASE_CODE")
    private String databaseCode;
    @ApiModelProperty(value="\u63d0\u4ea4\u65e5\u671f", required=true)
    @Column(name="CHANGE_DATE")
    @ValueGenerator(strategy=GeneratorType.FUNCTION, occasion=GeneratorTime.NEW_UPDATE, condition=GeneratorCondition.ALWAYS, value="today()")
    @OrderBy(value="DESC")
    private Date changeDate;
    @ApiModelProperty(value="\u63d0\u4ea4\u4eba", required=true)
    @Column(name="CHANGER")
    @DictionaryMap(fieldName={"changerName"}, value={"userCode"})
    private String changer;
    @ApiModelProperty(value="\u66f4\u6539\u811a\u672c")
    @Column(name="CHANGE_SCRIPT")
    private String changeScript;
    @ApiModelProperty(value="\u66f4\u6539\u8bf4\u660e")
    @Column(name="CHANGE_COMMENT")
    @Length(max=2048, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=2048, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String changeComment;
    @Transient
    private String changerName;

    public MetaChangLog() {
        this.changeDate = DatetimeOpt.currentUtilDate();
    }

    public MetaChangLog(String tableID, String databaseCode, Date changeDate, String changer) {
        this.tableID = tableID;
        this.databaseCode = databaseCode;
        this.changeDate = changeDate;
        this.changer = changer;
    }

    public MetaChangLog(String tableID, String databaseCode, String changeId, Date changeDate, String changer, String changeScript, String changeComment) {
        this.tableID = tableID;
        this.changeId = changeId;
        this.databaseCode = databaseCode;
        this.changeDate = changeDate;
        this.changer = changer;
        this.changeScript = changeScript;
        this.changeComment = changeComment;
    }

    public MetaChangLog copy(MetaChangLog other) {
        this.setTableID(other.getTableID());
        this.changeId = other.getChangeId();
        this.databaseCode = other.getDatabaseCode();
        this.changeDate = other.getChangeDate();
        this.changer = other.getChanger();
        this.changeScript = other.getChangeScript();
        this.changeComment = other.getChangeComment();
        return this;
    }

    public MetaChangLog copyNotNullProperty(MetaChangLog other) {
        if (other.getTableID() != null) {
            this.setTableID(other.getTableID());
        }
        if (other.getChangeId() != null) {
            this.changeId = other.getChangeId();
        }
        if (other.getDatabaseCode() != null) {
            this.databaseCode = other.getDatabaseCode();
        }
        if (other.getChangeDate() != null) {
            this.changeDate = other.getChangeDate();
        }
        if (other.getChanger() != null) {
            this.changer = other.getChanger();
        }
        if (other.getChangeScript() != null) {
            this.changeScript = other.getChangeScript();
        }
        if (other.getChangeComment() != null) {
            this.changeComment = other.getChangeComment();
        }
        return this;
    }

    public MetaChangLog clearProperties() {
        this.changeId = null;
        this.databaseCode = null;
        this.changeDate = null;
        this.changer = null;
        this.changeScript = null;
        this.changeComment = null;
        return this;
    }

    public String getChangeId() {
        return this.changeId;
    }

    public String getTableID() {
        return this.tableID;
    }

    public String getDatabaseCode() {
        return this.databaseCode;
    }

    public Date getChangeDate() {
        return this.changeDate;
    }

    public String getChanger() {
        return this.changer;
    }

    public String getChangeScript() {
        return this.changeScript;
    }

    public String getChangeComment() {
        return this.changeComment;
    }

    public String getChangerName() {
        return this.changerName;
    }

    public void setChangeId(String changeId) {
        this.changeId = changeId;
    }

    public void setTableID(String tableID) {
        this.tableID = tableID;
    }

    public void setDatabaseCode(String databaseCode) {
        this.databaseCode = databaseCode;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public void setChanger(String changer) {
        this.changer = changer;
    }

    public void setChangeScript(String changeScript) {
        this.changeScript = changeScript;
    }

    public void setChangeComment(String changeComment) {
        this.changeComment = changeComment;
    }

    public void setChangerName(String changerName) {
        this.changerName = changerName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaChangLog)) {
            return false;
        }
        MetaChangLog other = (MetaChangLog)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$changeId = this.getChangeId();
        String other$changeId = other.getChangeId();
        if (this$changeId == null ? other$changeId != null : !this$changeId.equals(other$changeId)) {
            return false;
        }
        String this$tableID = this.getTableID();
        String other$tableID = other.getTableID();
        if (this$tableID == null ? other$tableID != null : !this$tableID.equals(other$tableID)) {
            return false;
        }
        String this$databaseCode = this.getDatabaseCode();
        String other$databaseCode = other.getDatabaseCode();
        if (this$databaseCode == null ? other$databaseCode != null : !this$databaseCode.equals(other$databaseCode)) {
            return false;
        }
        Date this$changeDate = this.getChangeDate();
        Date other$changeDate = other.getChangeDate();
        if (this$changeDate == null ? other$changeDate != null : !((Object)this$changeDate).equals(other$changeDate)) {
            return false;
        }
        String this$changer = this.getChanger();
        String other$changer = other.getChanger();
        if (this$changer == null ? other$changer != null : !this$changer.equals(other$changer)) {
            return false;
        }
        String this$changeScript = this.getChangeScript();
        String other$changeScript = other.getChangeScript();
        if (this$changeScript == null ? other$changeScript != null : !this$changeScript.equals(other$changeScript)) {
            return false;
        }
        String this$changeComment = this.getChangeComment();
        String other$changeComment = other.getChangeComment();
        if (this$changeComment == null ? other$changeComment != null : !this$changeComment.equals(other$changeComment)) {
            return false;
        }
        String this$changerName = this.getChangerName();
        String other$changerName = other.getChangerName();
        return !(this$changerName == null ? other$changerName != null : !this$changerName.equals(other$changerName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetaChangLog;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $changeId = this.getChangeId();
        result = result * 59 + ($changeId == null ? 43 : $changeId.hashCode());
        String $tableID = this.getTableID();
        result = result * 59 + ($tableID == null ? 43 : $tableID.hashCode());
        String $databaseCode = this.getDatabaseCode();
        result = result * 59 + ($databaseCode == null ? 43 : $databaseCode.hashCode());
        Date $changeDate = this.getChangeDate();
        result = result * 59 + ($changeDate == null ? 43 : ((Object)$changeDate).hashCode());
        String $changer = this.getChanger();
        result = result * 59 + ($changer == null ? 43 : $changer.hashCode());
        String $changeScript = this.getChangeScript();
        result = result * 59 + ($changeScript == null ? 43 : $changeScript.hashCode());
        String $changeComment = this.getChangeComment();
        result = result * 59 + ($changeComment == null ? 43 : $changeComment.hashCode());
        String $changerName = this.getChangerName();
        result = result * 59 + ($changerName == null ? 43 : $changerName.hashCode());
        return result;
    }

    public String toString() {
        return "MetaChangLog(changeId=" + this.getChangeId() + ", tableID=" + this.getTableID() + ", databaseCode=" + this.getDatabaseCode() + ", changeDate=" + this.getChangeDate() + ", changer=" + this.getChanger() + ", changeScript=" + this.getChangeScript() + ", changeComment=" + this.getChangeComment() + ", changerName=" + this.getChangerName() + ")";
    }
}

