/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.socketio;

import com.centit.im.service.WebImSocket;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ServerEndpoint(value="/im/{userCode}")
public class WebImSocketListener {
    private static Logger logger = LoggerFactory.getLogger(WebImSocketListener.class);
    public static WebImSocket webImSocket;

    @Autowired
    public void setWebImSocket(WebImSocket webImSocket) {
        if (webImSocket != null) {
            WebImSocketListener.webImSocket = webImSocket;
        }
    }

    @OnOpen
    public void onOpen(Session session, @PathParam(value="userCode") String userCode) {
        try {
            webImSocket.signInUser(userCode, session);
        }
        catch (Exception e) {
            logger.error("onOpen", (Throwable)e);
        }
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        try {
            webImSocket.recvMessage(session, message);
        }
        catch (Exception e) {
            logger.error("onMessage" + message, (Throwable)e);
        }
    }

    @OnClose
    public void onClose(Session session) {
        try {
            webImSocket.signOutUser(session);
            if (session.isOpen()) {
                session.close();
            }
        }
        catch (Exception e) {
            logger.error("onClose \u5f02\u5e38:", (Throwable)e);
        }
    }

    @OnError
    public void onError(Session session, Throwable error) {
        logger.error("onError \u5f02\u5e38\uff1a" + error.getMessage(), error);
        this.onClose(session);
    }
}

