/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.po;

import com.alibaba.fastjson2.JSON;
import com.centit.im.po.ImMessage;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="F_WEB_IM_MESSAGE")
public class WebImMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="MSG_ID")
    @ValueGenerator(strategy=GeneratorType.UUID22)
    private String msgId;
    @Column(name="OS_ID")
    @Length(max=20, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ValueGenerator(strategy=GeneratorType.CONSTANT, value="WebIM")
    private @Length(max=20, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String osId;
    @Column(name="MSG_TYPE")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String msgType;
    @Column(name="SENDER")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String sender;
    @Column(name="SENDER_NAME")
    @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String senderName;
    @Column(name="RECEIVER")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String receiver;
    @Column(name="SEND_TIME")
    @Temporal(value=TemporalType.TIMESTAMP)
    @ValueGenerator(strategy=GeneratorType.FUNCTION, value="today()")
    private Date sendTime;
    @Column(name="MSG_STATE")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String msgState;
    @Column(name="CONTENT_TYPE")
    @Length(max=20, message="\u5185\u5bb9\u7c7b\u578b\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=20, message="\u5185\u5bb9\u7c7b\u578b\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String contentType;
    @Column(name="CONTENT")
    @Length(max=1000, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=1000, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String content;

    public WebImMessage() {
        this.osId = "WebIM";
    }

    public WebImMessage(String msgId, String msgType, String sender, String receiver) {
        this.msgId = msgId;
        this.osId = "WebIM";
        this.msgType = msgType;
        this.sender = sender;
        this.receiver = receiver;
    }

    public WebImMessage copy(ImMessage other) {
        this.sender = other.getSender();
        this.receiver = other.getReceiver();
        this.sendTime = other.getSendTime();
        this.senderName = other.getSenderName();
        this.contentType = other.getContentType();
        this.content = JSON.toJSONString((Object)other.getContent());
        this.msgType = other.getType();
        return this;
    }

    public WebImMessage copy(WebImMessage other) {
        this.setMsgId(other.getMsgId());
        this.osId = other.getOsId();
        this.msgType = other.getMsgType();
        this.sender = other.getSender();
        this.receiver = other.getReceiver();
        this.sendTime = other.getSendTime();
        this.msgState = other.getMsgState();
        this.contentType = other.getContentType();
        this.content = other.getContent();
        this.senderName = other.getSenderName();
        return this;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public String getOsId() {
        return this.osId;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public String getSender() {
        return this.sender;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public Date getSendTime() {
        return this.sendTime;
    }

    public String getMsgState() {
        return this.msgState;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContent() {
        return this.content;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public void setOsId(String osId) {
        this.osId = osId;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public void setMsgState(String msgState) {
        this.msgState = msgState;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebImMessage)) {
            return false;
        }
        WebImMessage other = (WebImMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$msgId = this.getMsgId();
        String other$msgId = other.getMsgId();
        if (this$msgId == null ? other$msgId != null : !this$msgId.equals(other$msgId)) {
            return false;
        }
        String this$osId = this.getOsId();
        String other$osId = other.getOsId();
        if (this$osId == null ? other$osId != null : !this$osId.equals(other$osId)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        String this$sender = this.getSender();
        String other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) {
            return false;
        }
        String this$senderName = this.getSenderName();
        String other$senderName = other.getSenderName();
        if (this$senderName == null ? other$senderName != null : !this$senderName.equals(other$senderName)) {
            return false;
        }
        String this$receiver = this.getReceiver();
        String other$receiver = other.getReceiver();
        if (this$receiver == null ? other$receiver != null : !this$receiver.equals(other$receiver)) {
            return false;
        }
        Date this$sendTime = this.getSendTime();
        Date other$sendTime = other.getSendTime();
        if (this$sendTime == null ? other$sendTime != null : !((Object)this$sendTime).equals(other$sendTime)) {
            return false;
        }
        String this$msgState = this.getMsgState();
        String other$msgState = other.getMsgState();
        if (this$msgState == null ? other$msgState != null : !this$msgState.equals(other$msgState)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebImMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $msgId = this.getMsgId();
        result = result * 59 + ($msgId == null ? 43 : $msgId.hashCode());
        String $osId = this.getOsId();
        result = result * 59 + ($osId == null ? 43 : $osId.hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        String $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : $sender.hashCode());
        String $senderName = this.getSenderName();
        result = result * 59 + ($senderName == null ? 43 : $senderName.hashCode());
        String $receiver = this.getReceiver();
        result = result * 59 + ($receiver == null ? 43 : $receiver.hashCode());
        Date $sendTime = this.getSendTime();
        result = result * 59 + ($sendTime == null ? 43 : ((Object)$sendTime).hashCode());
        String $msgState = this.getMsgState();
        result = result * 59 + ($msgState == null ? 43 : $msgState.hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    public String toString() {
        return "WebImMessage(msgId=" + this.getMsgId() + ", osId=" + this.getOsId() + ", msgType=" + this.getMsgType() + ", sender=" + this.getSender() + ", senderName=" + this.getSenderName() + ", receiver=" + this.getReceiver() + ", sendTime=" + this.getSendTime() + ", msgState=" + this.getMsgState() + ", contentType=" + this.getContentType() + ", content=" + this.getContent() + ")";
    }
}

