/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.po;

import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="F_WEB_IM_CUSTOMER")
public class WebImCustomer
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="USER_CODE")
    @ValueGenerator(strategy=GeneratorType.UUID)
    private String userCode;
    @Column(name="OS_ID")
    @ValueGenerator(strategy=GeneratorType.CONSTANT, value="WebIM")
    private String osId;
    @Column(name="USER_TYPE")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String userType;
    @Column(name="USER_NAME")
    @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String userName;
    @Column(name="HEAD_SCULPTURE")
    @Length(max=200, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=200, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String headSculpture;
    @Column(name="SERVICE_OPTS")
    @Length(max=1000, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=1000, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String serviceOpts;
    @Column(name="CUSTOMER_SERVICE")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String customerService;
    @Column(name="LAST_ACTIVE_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastActiveDate;
    @Column(name="CREATOR")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String creator;
    @Column(name="CREATE_TIME")
    @Temporal(value=TemporalType.TIMESTAMP)
    @ValueGenerator(strategy=GeneratorType.FUNCTION, value="today()")
    private Date createTime;
    @Transient
    private String userState;

    public WebImCustomer() {
    }

    public WebImCustomer(String userCode, String userName) {
        this.userCode = userCode;
        this.userName = userName;
    }

    public String getUserState() {
        if (this.userState == null) {
            return "F";
        }
        return this.userState;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public String getOsId() {
        return this.osId;
    }

    public String getUserType() {
        return this.userType;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getHeadSculpture() {
        return this.headSculpture;
    }

    public String getServiceOpts() {
        return this.serviceOpts;
    }

    public String getCustomerService() {
        return this.customerService;
    }

    public Date getLastActiveDate() {
        return this.lastActiveDate;
    }

    public String getCreator() {
        return this.creator;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public void setOsId(String osId) {
        this.osId = osId;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setHeadSculpture(String headSculpture) {
        this.headSculpture = headSculpture;
    }

    public void setServiceOpts(String serviceOpts) {
        this.serviceOpts = serviceOpts;
    }

    public void setCustomerService(String customerService) {
        this.customerService = customerService;
    }

    public void setLastActiveDate(Date lastActiveDate) {
        this.lastActiveDate = lastActiveDate;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setUserState(String userState) {
        this.userState = userState;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebImCustomer)) {
            return false;
        }
        WebImCustomer other = (WebImCustomer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$userCode = this.getUserCode();
        String other$userCode = other.getUserCode();
        if (this$userCode == null ? other$userCode != null : !this$userCode.equals(other$userCode)) {
            return false;
        }
        String this$osId = this.getOsId();
        String other$osId = other.getOsId();
        if (this$osId == null ? other$osId != null : !this$osId.equals(other$osId)) {
            return false;
        }
        String this$userType = this.getUserType();
        String other$userType = other.getUserType();
        if (this$userType == null ? other$userType != null : !this$userType.equals(other$userType)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$headSculpture = this.getHeadSculpture();
        String other$headSculpture = other.getHeadSculpture();
        if (this$headSculpture == null ? other$headSculpture != null : !this$headSculpture.equals(other$headSculpture)) {
            return false;
        }
        String this$serviceOpts = this.getServiceOpts();
        String other$serviceOpts = other.getServiceOpts();
        if (this$serviceOpts == null ? other$serviceOpts != null : !this$serviceOpts.equals(other$serviceOpts)) {
            return false;
        }
        String this$customerService = this.getCustomerService();
        String other$customerService = other.getCustomerService();
        if (this$customerService == null ? other$customerService != null : !this$customerService.equals(other$customerService)) {
            return false;
        }
        Date this$lastActiveDate = this.getLastActiveDate();
        Date other$lastActiveDate = other.getLastActiveDate();
        if (this$lastActiveDate == null ? other$lastActiveDate != null : !((Object)this$lastActiveDate).equals(other$lastActiveDate)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$userState = this.getUserState();
        String other$userState = other.getUserState();
        return !(this$userState == null ? other$userState != null : !this$userState.equals(other$userState));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebImCustomer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $userCode = this.getUserCode();
        result = result * 59 + ($userCode == null ? 43 : $userCode.hashCode());
        String $osId = this.getOsId();
        result = result * 59 + ($osId == null ? 43 : $osId.hashCode());
        String $userType = this.getUserType();
        result = result * 59 + ($userType == null ? 43 : $userType.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $headSculpture = this.getHeadSculpture();
        result = result * 59 + ($headSculpture == null ? 43 : $headSculpture.hashCode());
        String $serviceOpts = this.getServiceOpts();
        result = result * 59 + ($serviceOpts == null ? 43 : $serviceOpts.hashCode());
        String $customerService = this.getCustomerService();
        result = result * 59 + ($customerService == null ? 43 : $customerService.hashCode());
        Date $lastActiveDate = this.getLastActiveDate();
        result = result * 59 + ($lastActiveDate == null ? 43 : ((Object)$lastActiveDate).hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $userState = this.getUserState();
        result = result * 59 + ($userState == null ? 43 : $userState.hashCode());
        return result;
    }

    public String toString() {
        return "WebImCustomer(userCode=" + this.getUserCode() + ", osId=" + this.getOsId() + ", userType=" + this.getUserType() + ", userName=" + this.getUserName() + ", headSculpture=" + this.getHeadSculpture() + ", serviceOpts=" + this.getServiceOpts() + ", customerService=" + this.getCustomerService() + ", lastActiveDate=" + this.getLastActiveDate() + ", creator=" + this.getCreator() + ", createTime=" + this.getCreateTime() + ", userState=" + this.getUserState() + ")";
    }
}

