/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.controller;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.im.po.WebImMessage;
import com.centit.im.service.WebImMessageManager;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@Api(value="\u6d88\u606f\u7ba1\u7406\u63a5\u53e3", tags={"\u6d88\u606f\u7ba1\u7406\u63a5\u53e3"})
@RequestMapping(value={"/webimmsg"})
public class WebImMsgController
extends BaseController {
    @Autowired
    protected WebImMessageManager webImMessageManager;

    public static JSONArray messgeListToJson(JSONArray messageList) {
        if (CollectionUtils.isEmpty((Collection)messageList)) {
            return messageList;
        }
        for (Object obj : messageList) {
            JSONObject jsonObject = (JSONObject)obj;
            JSONObject jsonContent = (JSONObject)JSON.parse((String)jsonObject.getString("content"));
            jsonObject.put((Object)"content", (Object)jsonContent);
            jsonObject.put((Object)"contentType", jsonContent.get("contentType"));
        }
        return messageList;
    }

    public static JSONArray messgeListToJson(List<WebImMessage> messageList) {
        if (CollectionUtils.isEmpty(messageList)) {
            return null;
        }
        return WebImMsgController.messgeListToJson((JSONArray)JSON.toJSON(messageList));
    }

    @ApiOperation(value="1\u67e5\u8be2\u5386\u53f2\u6d88\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="receiver", value="\u63a5\u6536\u4eba", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="sender", value="\u53d1\u9001\u4eba", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/historyMessage/{receiver}/{sender}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult listUserHistoryMessage(@PathVariable String receiver, @PathVariable String sender, PageDesc pageDesc, Date lastReadDate) {
        JSONArray listObjects = this.webImMessageManager.listChatMessage(sender, receiver, lastReadDate, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)WebImMsgController.messgeListToJson(listObjects), (PageDesc)pageDesc);
    }

    @ApiOperation(value="2\u83b7\u53d6\u6536\u5230\u6240\u6709\u4fe1\u606f")
    @ApiImplicitParam(name="lastReadDate", value="\u4e0a\u6b21\u6d88\u606f\u7684\u65f6\u95f4", required=false, paramType="query", dataType="String")
    @RequestMapping(value={"/allHistoryMessage/{receiver}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult listAllHistoryMessage(@PathVariable String receiver, PageDesc pageDesc, Date lastReadDate) {
        JSONArray listObjects = this.webImMessageManager.listAllChatMessage(receiver, lastReadDate, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)WebImMsgController.messgeListToJson(listObjects), (PageDesc)pageDesc);
    }

    @ApiOperation(value="3\u83b7\u53d6\u7fa4\u804a\u5386\u53f2\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="receiver", value="\u63a5\u6536\u4eba", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="lastReadDate", value="\u4e0a\u6b21\u6d88\u606f\u7684\u65f6\u95f4", required=false, paramType="path", dataType="String")})
    @RequestMapping(value={"/groupHistoryMessage/{receiver}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult listGroupHistoryMessage(@PathVariable String receiver, PageDesc pageDesc, Date lastReadDate) {
        JSONArray listObjects = this.webImMessageManager.listGroupChatMessage(receiver, lastReadDate, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)WebImMsgController.messgeListToJson(listObjects), (PageDesc)pageDesc);
    }

    @ApiOperation(value="4\u83b7\u53d6\u7ec4\u7fa4\u804a\u5386\u53f2\u4fe1\u606f")
    @RequestMapping(value={"/groupHistoryMessage/{userCode}/{unitCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult listUserGroupHistoryMessage(@PathVariable String userCode, @PathVariable String unitCode, PageDesc pageDesc, Date lastReadDate) {
        JSONArray listObjects = this.webImMessageManager.listGroupChatMessage(userCode, unitCode, lastReadDate, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)WebImMsgController.messgeListToJson(listObjects), (PageDesc)pageDesc);
    }

    @ApiOperation(value="5\u83b7\u53d6\u672a\u8bfb\u4fe1\u606f\u7edf\u8ba1")
    @RequestMapping(value={"/statUnread/{userCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public Map<String, Integer> statUnreadMessage(@PathVariable String userCode) {
        return this.webImMessageManager.statUnreadMessage(userCode);
    }

    @ApiOperation(value="6\u83b7\u53d6\u672a\u8bfb\u7fa4\u4fe1\u606f\u7edf\u8ba1")
    @RequestMapping(value={"/statGroupUnread/{userCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public Map<String, Integer> statGroupUnreadMessage(@PathVariable String userCode) {
        return this.webImMessageManager.statGroupUnreadMessage(userCode);
    }

    @ApiOperation(value="7\u83b7\u53d6\u6700\u540e\u672a\u8bfb\u4fe1\u606f\u53ca\u7edf\u8ba1")
    @RequestMapping(value={"/getUnreadLastMsg/{userCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public JSONArray statUnreadWithLastMsg(@PathVariable String userCode) {
        JSONArray listObjects = this.webImMessageManager.statUnreadWithLastMsg(userCode);
        return WebImMsgController.messgeListToJson(listObjects);
    }

    @ApiOperation(value="8\u83b7\u53d6\u5305\u62ec\u6700\u540e\u672a\u8bfb\u7fa4\u4fe1\u606f\u7edf\u8ba1")
    @RequestMapping(value={"/getGroupUnreadLastMsg/{userCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public JSONArray statGroupUnreadeWithLastMsg(@PathVariable String userCode) {
        JSONArray obj = this.webImMessageManager.statGroupUnreadWithLastMsg(userCode);
        return WebImMsgController.messgeListToJson(obj);
    }

    @ApiOperation(value="9\u8bbe\u7f6e\u4fe1\u606f\u72b6\u6001")
    @RequestMapping(value={"/setReadState/{receiver}/{sender}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public int setReadState(@PathVariable String receiver, @PathVariable String sender) {
        return this.webImMessageManager.setReadState(receiver, sender);
    }

    @ApiOperation(value="10\u8bbe\u7f6e\u7fa4\u4fe1\u606f\u72b6\u6001")
    @RequestMapping(value={"/setGroupReadState/{receiver}/{unitCode}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData setGroupReadState(@PathVariable String receiver, @PathVariable String unitCode) {
        this.webImMessageManager.setGroupReadState(receiver, unitCode);
        return ResponseData.makeSuccessResponse();
    }
}

