/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.dao;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.im.po.WebImMessage;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.PageDesc;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class WebImMessageDao
extends BaseDaoImpl<WebImMessage, String> {
    public static final Log log = LogFactory.getLog(WebImMessageDao.class);

    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("msgId", "EQUAL");
        filterField.put("osId", "EQUAL");
        filterField.put("msgType", "EQUAL");
        filterField.put("sender", "EQUAL");
        filterField.put("receiver", "EQUAL");
        filterField.put("sendTime", "EQUAL");
        filterField.put("msgState", "EQUAL");
        filterField.put("content", "EQUAL");
        return filterField;
    }

    public JSONArray listChatMessage(String sender, String receiver, Date lastReadDate, PageDesc pageDesc) {
        Date lrd = lastReadDate == null ? DatetimeOpt.currentUtilDate() : lastReadDate;
        String sql = "select f.MSG_ID, f.OS_ID, f.MSG_TYPE, f.SENDER, f.RECEIVER, f.SEND_TIME, f.SENDER_NAME, f.MSG_STATE, f.CONTENT_TYPE, f.CONTENT FROM F_WEB_IM_MESSAGE f WHERE 1=1 AND f.SEND_TIME <= ? AND (f.SENDER = ? AND f.RECEIVER = ?) OR (f.SENDER = ? AND f.RECEIVER = ?) ORDER BY f.SEND_TIME DESC ";
        return DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{lrd, sender, receiver, receiver, sender}, (PageDesc)pageDesc);
    }

    public JSONArray listAllChatMessage(String receiver, Date lastReadDate, PageDesc pageDesc) {
        Date lrd = lastReadDate == null ? DatetimeOpt.currentUtilDate() : lastReadDate;
        String sql = "select f.MSG_ID, f.OS_ID, f.MSG_TYPE, f.SENDER, f.RECEIVER, f.SEND_TIME, f.SENDER_NAME, f.MSG_STATE, f.CONTENT_TYPE, f.CONTENT FROM F_WEB_IM_MESSAGE f WHERE f.SEND_TIME <= ? AND ( f.RECEIVER = ?  OR f.SENDER = ?) ORDER BY f.SEND_TIME DESC";
        return DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{lrd, receiver, receiver}, (PageDesc)pageDesc);
    }

    public JSONArray listGroupChatMessage(String unitCode, Date lastReadDate, PageDesc pageDesc) {
        Date lrd = lastReadDate == null ? DatetimeOpt.currentUtilDate() : lastReadDate;
        String sql = "select f.MSG_ID, f.OS_ID, f.MSG_TYPE, f.SENDER, f.RECEIVER, f.SEND_TIME, f.SENDER_NAME, f.MSG_STATE, f.CONTENT_TYPE, f.CONTENT FROM F_WEB_IM_MESSAGE f WHERE f.SEND_TIME <= ? AND f.RECEIVER = ? AND f.MSG_TYPE = 'G' ORDER BY f.SEND_TIME DESC";
        return DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{lrd, unitCode}, (PageDesc)pageDesc);
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public int updateReadState(String sender, String receiver) {
        String sql = "UPDATE F_WEB_IM_MESSAGE f SET f.MSG_STATE='C' WHERE f.MSG_STATE='U' AND f.RECEIVER=? AND f.SENDER=?";
        return DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{receiver, sender});
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public int updateReadState(String receiver) {
        String sql = "UPDATE F_WEB_IM_MESSAGE f SET f.MSG_STATE='C' WHERE f.MSG_STATE='U' AND f.RECEIVER=? ";
        return DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{receiver});
    }

    public Map<String, Integer> statUnreadMsg(String receiver) {
        String sql = "select v.SENDER, v.UNREAD_SUM  from  F_V_UNREAD_CHAT_MSG v where  v.RECEIVER= ? ";
        JSONArray jsonArray = DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this, (String)sql, (String[])new String[]{"senderCode", "unreadSum"}, (Object[])new Object[]{receiver});
        HashMap<String, Integer> map = new HashMap<String, Integer>(jsonArray.size() * 2);
        for (Object obj : jsonArray) {
            map.put(StringBaseOpt.objectToString((Object)((JSONObject)obj).get((Object)"senderCode")), NumberBaseOpt.castObjectToInteger((Object)((JSONObject)obj).get((Object)"unreadSum")));
        }
        return map;
    }

    public Map<String, Integer> statGroupUnreadMsg(String userCode) {
        String sql = "select v.UNIT_CODE, v.UNREAD_SUM  from  F_V_UNREAD_GROUP_MSG v where v.USER_CODE = ?";
        JSONArray jsonArray = DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this, (String)sql, (String[])new String[]{"unitCode", "unreadSum"}, (Object[])new Object[]{userCode});
        HashMap<String, Integer> map = new HashMap<String, Integer>(jsonArray.size() * 2);
        for (Object obj : jsonArray) {
            map.put(StringBaseOpt.objectToString((Object)((JSONObject)obj).get((Object)"unitCode")), NumberBaseOpt.castObjectToInteger((Object)((JSONObject)obj).get((Object)"unreadSum")));
        }
        return map;
    }

    public JSONArray statUnreadWithLastMsg(String receiver) {
        String sql = "select v.SENDER, v.RECEIVER, v.UNREAD_SUM, v.SEND_TIME, V.SENDER_NAME,v.MSG_ID, v.MSG_TYPE, v.MSG_STATE, v.CONTENT, v.CONTENT_TYPE from  F_V_LAST_UNREAD_CHAT_MSG v where  v.RECEIVER= ? ";
        JSONArray jsonArray = DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this, (String)sql, (String[])new String[]{"sender", "receiver", "unreadSum", "sendTime", "senderName", "msgId", "msgType", "msgState", "content", "contentType"}, (Object[])new Object[]{receiver});
        return jsonArray;
    }

    public JSONArray statGroupUnreadWithLastMsg(String userCode) {
        String sql = "select v.USER_CODE, v.UNIT_CODE, v.UNREAD_SUM, v.SEND_TIME, V.SENDER_NAME,v.MSG_ID, v.MSG_TYPE, v.MSG_STATE, v.CONTENT, v.CONTENT_TYPE from  F_V_LAST_UNREAD_GROUP_MSG v where  v.USER_CODE= ? ";
        JSONArray jsonArray = DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this, (String)sql, (String[])new String[]{"userCode", "unitCode", "unreadSum", "sendTime", "senderName", "msgId", "msgType", "msgState", "content", "contentType"}, (Object[])new Object[]{userCode});
        return jsonArray;
    }
}

