/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.po;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="F_WEB_IM_GROUP")
public class WebImGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="GROUP_ID")
    @ValueGenerator(strategy=GeneratorType.UUID22)
    private String groupId;
    @Column(name="OS_ID")
    @ValueGenerator(strategy=GeneratorType.CONSTANT, value="WebIM")
    private String osId;
    @Column(name="GROUP_TYPE")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String groupType;
    @Column(name="GROUP_NAME")
    @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String groupName;
    @Column(name="GROUP_NOTICE")
    @Length(max=1000, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=1000, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String groupNotice;
    @Column(name="CREATOR")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String creator;
    @Column(name="CREATE_TIME")
    @Temporal(value=TemporalType.TIMESTAMP)
    @ValueGenerator(strategy=GeneratorType.FUNCTION, value="today")
    private Date createTime;

    public static WebImGroup createFromJsonString(String jsonStr) {
        JSONObject jsonObject = JSON.parseObject((String)jsonStr);
        if (jsonObject == null) {
            return null;
        }
        return WebImGroup.createFromJson(jsonObject);
    }

    public static WebImGroup createFromJson(JSONObject jsonObject) {
        WebImGroup imGroup = new WebImGroup();
        imGroup.setGroupId(jsonObject.getString("groupId"));
        imGroup.setOsId(jsonObject.getString("osId"));
        imGroup.setGroupType(jsonObject.getString("groupType"));
        imGroup.setGroupName(jsonObject.getString("groupName"));
        imGroup.setGroupNotice(jsonObject.getString("groupNotice"));
        imGroup.setCreator(jsonObject.getString("creator"));
        imGroup.setCreateTime(DatetimeOpt.castObjectToDate((Object)jsonObject.get((Object)"createTime")));
        return imGroup;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getOsId() {
        return this.osId;
    }

    public String getGroupType() {
        return this.groupType;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getGroupNotice() {
        return this.groupNotice;
    }

    public String getCreator() {
        return this.creator;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setOsId(String osId) {
        this.osId = osId;
    }

    public void setGroupType(String groupType) {
        this.groupType = groupType;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setGroupNotice(String groupNotice) {
        this.groupNotice = groupNotice;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebImGroup)) {
            return false;
        }
        WebImGroup other = (WebImGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$osId = this.getOsId();
        String other$osId = other.getOsId();
        if (this$osId == null ? other$osId != null : !this$osId.equals(other$osId)) {
            return false;
        }
        String this$groupType = this.getGroupType();
        String other$groupType = other.getGroupType();
        if (this$groupType == null ? other$groupType != null : !this$groupType.equals(other$groupType)) {
            return false;
        }
        String this$groupName = this.getGroupName();
        String other$groupName = other.getGroupName();
        if (this$groupName == null ? other$groupName != null : !this$groupName.equals(other$groupName)) {
            return false;
        }
        String this$groupNotice = this.getGroupNotice();
        String other$groupNotice = other.getGroupNotice();
        if (this$groupNotice == null ? other$groupNotice != null : !this$groupNotice.equals(other$groupNotice)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        return !(this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebImGroup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $osId = this.getOsId();
        result = result * 59 + ($osId == null ? 43 : $osId.hashCode());
        String $groupType = this.getGroupType();
        result = result * 59 + ($groupType == null ? 43 : $groupType.hashCode());
        String $groupName = this.getGroupName();
        result = result * 59 + ($groupName == null ? 43 : $groupName.hashCode());
        String $groupNotice = this.getGroupNotice();
        result = result * 59 + ($groupNotice == null ? 43 : $groupNotice.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        return result;
    }

    public String toString() {
        return "WebImGroup(groupId=" + this.getGroupId() + ", osId=" + this.getOsId() + ", groupType=" + this.getGroupType() + ", groupName=" + this.getGroupName() + ", groupNotice=" + this.getGroupNotice() + ", creator=" + this.getCreator() + ", createTime=" + this.getCreateTime() + ")";
    }
}

