/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.controller;

import com.centit.framework.common.ResponseData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.im.po.ImMessage;
import com.centit.im.service.WebImSocket;
import com.centit.im.socketio.ImMessageUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/webim"})
@Api(value="\u5373\u65f6\u6d88\u606f\u53d1\u9001\u63a5\u53e3", tags={"\u5373\u65f6\u6d88\u606f\u53d1\u9001\u63a5\u53e3"})
public class WebImController
extends BaseController {
    @Autowired
    protected WebImSocket webImSocket;

    @ApiOperation(value="1\u7b2c\u4e09\u65b9\u53d1\u9001\u6d88\u606f")
    @RequestMapping(value={"/sendMessage/{receiver}/{sender}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData sendMessage(@PathVariable String receiver, @PathVariable String sender, @RequestBody ImMessage message) {
        message.setReceiver(receiver);
        message.setSender(sender);
        ImMessageUtils.checkMessage(message);
        this.webImSocket.sendMessage(receiver, message);
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="2\u7b2c\u4e09\u65b9\u53d1\u9001\u7fa4\u6d88\u606f")
    @RequestMapping(value={"/sendUnitMessage/{receiver}/{sender}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData sendGroupMessage(@PathVariable String receiver, @PathVariable String sender, @RequestBody ImMessage message) {
        message.setReceiver(receiver);
        message.setSender(sender);
        ImMessageUtils.checkMessage(message);
        this.webImSocket.sendGroupMessage(receiver, message);
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="3\u7b2c\u4e09\u65b9\u5e7f\u64ad\u6d88\u606f")
    @RequestMapping(value={"/toall/{sender}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData toallMessage(@PathVariable String sender, @RequestBody ImMessage message) {
        message.setSender(sender);
        ImMessageUtils.checkMessage(message);
        this.webImSocket.toallMessage(message);
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="4\u7b2c\u4e09\u65b9\u5728\u7ebf\u5e7f\u64ad\u6d88\u606f")
    @RequestMapping(value={"/broadcast/{sender}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData broadcastMessage(@PathVariable String sender, @RequestBody ImMessage message) {
        message.setSender(sender);
        ImMessageUtils.checkMessage(message);
        this.webImSocket.broadcastMessage(message);
        return ResponseData.makeSuccessResponse();
    }
}

