/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.po;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.im.po.WebImGroupMemberId;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="F_WEB_IM_GROUP_MEMBER")
public class WebImGroupMember
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private WebImGroupMemberId cid;
    @Column(name="OS_ID")
    @ValueGenerator(strategy=GeneratorType.CONSTANT, value="WebIM")
    private String osId;
    @Column(name="GROUP_ALIAS")
    private String groupAlias;
    @Column(name="GROUP_MEMO")
    private String groupMemo;
    @Column(name="LAST_PUSH_TIME")
    @ValueGenerator(strategy=GeneratorType.FUNCTION, condition=GeneratorCondition.ALWAYS, value="today()")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastPushTime;
    @Column(name="JOIN_TIME")
    @ValueGenerator(strategy=GeneratorType.FUNCTION, value="today()")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date joinTime;

    public WebImGroupMember() {
    }

    public WebImGroupMember(WebImGroupMemberId id, Date lastPushTime) {
        this.cid = id;
        this.lastPushTime = lastPushTime;
    }

    public String getUserCode() {
        if (this.cid == null) {
            this.cid = new WebImGroupMemberId();
        }
        return this.cid.getUserCode();
    }

    public void setUserCode(String userCode) {
        if (this.cid == null) {
            this.cid = new WebImGroupMemberId();
        }
        this.cid.setUserCode(userCode);
    }

    public String getGroupId() {
        if (this.cid == null) {
            this.cid = new WebImGroupMemberId();
        }
        return this.cid.getGroupId();
    }

    public void setGroupId(String unitCode) {
        if (this.cid == null) {
            this.cid = new WebImGroupMemberId();
        }
        this.cid.setGroupId(unitCode);
    }

    public static WebImGroupMember createFromJson(JSONObject jo) {
        WebImGroupMember webImGroupMember = new WebImGroupMember();
        webImGroupMember.setOsId(jo.getString("osId"));
        webImGroupMember.setGroupId(jo.getString("groupId"));
        webImGroupMember.setUserCode(jo.getString("userCode"));
        webImGroupMember.setGroupAlias(jo.getString("groupAlias"));
        webImGroupMember.setGroupMemo(jo.getString("groupMemo"));
        webImGroupMember.setJoinTime(DatetimeOpt.castObjectToDate((Object)jo.get((Object)"joinTime")));
        webImGroupMember.setLastPushTime(DatetimeOpt.castObjectToDate((Object)jo.get((Object)"lastPushTime")));
        return webImGroupMember;
    }

    public static List<WebImGroupMember> createFromJsonArray(JSONArray ja) {
        if (ja == null || ja.size() < 1) {
            return null;
        }
        ArrayList<WebImGroupMember> members = new ArrayList<WebImGroupMember>(ja.size());
        for (Object obj : ja) {
            members.add(WebImGroupMember.createFromJson((JSONObject)obj));
        }
        return members;
    }

    public WebImGroupMemberId getCid() {
        return this.cid;
    }

    public String getOsId() {
        return this.osId;
    }

    public String getGroupAlias() {
        return this.groupAlias;
    }

    public String getGroupMemo() {
        return this.groupMemo;
    }

    public Date getLastPushTime() {
        return this.lastPushTime;
    }

    public Date getJoinTime() {
        return this.joinTime;
    }

    public void setCid(WebImGroupMemberId cid) {
        this.cid = cid;
    }

    public void setOsId(String osId) {
        this.osId = osId;
    }

    public void setGroupAlias(String groupAlias) {
        this.groupAlias = groupAlias;
    }

    public void setGroupMemo(String groupMemo) {
        this.groupMemo = groupMemo;
    }

    public void setLastPushTime(Date lastPushTime) {
        this.lastPushTime = lastPushTime;
    }

    public void setJoinTime(Date joinTime) {
        this.joinTime = joinTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebImGroupMember)) {
            return false;
        }
        WebImGroupMember other = (WebImGroupMember)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WebImGroupMemberId this$cid = this.getCid();
        WebImGroupMemberId other$cid = other.getCid();
        if (this$cid == null ? other$cid != null : !((Object)this$cid).equals(other$cid)) {
            return false;
        }
        String this$osId = this.getOsId();
        String other$osId = other.getOsId();
        if (this$osId == null ? other$osId != null : !this$osId.equals(other$osId)) {
            return false;
        }
        String this$groupAlias = this.getGroupAlias();
        String other$groupAlias = other.getGroupAlias();
        if (this$groupAlias == null ? other$groupAlias != null : !this$groupAlias.equals(other$groupAlias)) {
            return false;
        }
        String this$groupMemo = this.getGroupMemo();
        String other$groupMemo = other.getGroupMemo();
        if (this$groupMemo == null ? other$groupMemo != null : !this$groupMemo.equals(other$groupMemo)) {
            return false;
        }
        Date this$lastPushTime = this.getLastPushTime();
        Date other$lastPushTime = other.getLastPushTime();
        if (this$lastPushTime == null ? other$lastPushTime != null : !((Object)this$lastPushTime).equals(other$lastPushTime)) {
            return false;
        }
        Date this$joinTime = this.getJoinTime();
        Date other$joinTime = other.getJoinTime();
        return !(this$joinTime == null ? other$joinTime != null : !((Object)this$joinTime).equals(other$joinTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebImGroupMember;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WebImGroupMemberId $cid = this.getCid();
        result = result * 59 + ($cid == null ? 43 : ((Object)$cid).hashCode());
        String $osId = this.getOsId();
        result = result * 59 + ($osId == null ? 43 : $osId.hashCode());
        String $groupAlias = this.getGroupAlias();
        result = result * 59 + ($groupAlias == null ? 43 : $groupAlias.hashCode());
        String $groupMemo = this.getGroupMemo();
        result = result * 59 + ($groupMemo == null ? 43 : $groupMemo.hashCode());
        Date $lastPushTime = this.getLastPushTime();
        result = result * 59 + ($lastPushTime == null ? 43 : ((Object)$lastPushTime).hashCode());
        Date $joinTime = this.getJoinTime();
        result = result * 59 + ($joinTime == null ? 43 : ((Object)$joinTime).hashCode());
        return result;
    }

    public String toString() {
        return "WebImGroupMember(cid=" + this.getCid() + ", osId=" + this.getOsId() + ", groupAlias=" + this.getGroupAlias() + ", groupMemo=" + this.getGroupMemo() + ", lastPushTime=" + this.getLastPushTime() + ", joinTime=" + this.getJoinTime() + ")";
    }
}

