/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.controller;

import com.alibaba.fastjson.JSONObject;
import com.centit.fileserver.common.FileStore;
import com.centit.fileserver.utils.FileRangeInfo;
import com.centit.fileserver.utils.SystemTempFileUtils;
import com.centit.fileserver.utils.UploadDownloadUtils;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileMD5Maker;
import com.centit.support.file.FileSystemOpt;
import com.centit.support.file.FileType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;

@Controller
@RequestMapping(value={"/file"})
@Api(value="\u4e0a\u4f20\u6587\u4ef6\u63a5\u53e3", tags={"\u4e0a\u4f20\u6587\u4ef6\u63a5\u53e3"})
public class FileController
extends BaseController {
    private static Logger log = LoggerFactory.getLogger(FileController.class);
    @Autowired
    protected FileStore fileStore;

    private static void downFileRange(HttpServletRequest request, HttpServletResponse response, InputStream inputStream, long fSize, String fileName) throws IOException {
        response.setContentType(FileType.getFileMimeType((String)fileName) + ";charset=ISO8859-1");
        response.setHeader("Accept-Ranges", "bytes");
        String s = request.getParameter("downloadType");
        response.setHeader("Content-Disposition", ("inline".equalsIgnoreCase(s) ? "inline" : "attachment") + "; filename=" + UploadDownloadUtils.encodeDownloadFilename((String)fileName));
        long pos = 0L;
        FileRangeInfo fr = FileRangeInfo.parseRange((String)request.getHeader("Range"));
        if (fr == null) {
            fr = new FileRangeInfo(0L, fSize - 1L, fSize);
        } else {
            if (fr.getRangeEnd() <= 0L) {
                fr.setRangeEnd(fSize - 1L);
            }
            fr.setFileSize(fSize);
            pos = fr.getRangeStart();
            if (fr.getPartSize() < fr.getFileSize()) {
                response.setStatus(206);
            }
        }
        response.setHeader("Content-Length", String.valueOf(fr.getPartSize()));
        response.setHeader("Content-Range", fr.getResponseRange());
        try (ServletOutputStream out = response.getOutputStream();
             BufferedOutputStream bufferOut = new BufferedOutputStream((OutputStream)out);){
            int writeLen;
            if (pos > 0L) {
                inputStream.skip(pos);
            }
            byte[] buffer = new byte[65536];
            int length = 0;
            for (int needSize = new Long(fr.getPartSize()).intValue(); needSize > 0 && (length = inputStream.read(buffer, 0, buffer.length)) != -1; needSize -= writeLen) {
                writeLen = needSize > length ? length : needSize;
                bufferOut.write(buffer, 0, writeLen);
                bufferOut.flush();
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @RequestMapping(value={"/download/{md5SizeExt}"}, method={RequestMethod.GET})
    public void downloadUnprotectedFile(@PathVariable(value="md5SizeExt") String md5SizeExt, String fileName, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String uri = request.getRequestURI();
        String[] urips = uri.split("/");
        int n = urips.length;
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = urips[n - 1];
        }
        Pair<String, Long> md5Size = FileController.fetchMd5andSize(md5SizeExt);
        InputStream inputStream = this.fileStore.loadFileStream((String)md5Size.getLeft(), ((Long)md5Size.getRight()).longValue());
        FileController.downFileRange(request, response, inputStream, (Long)md5Size.getRight(), fileName);
    }

    public static Pair<String, Long> fetchMd5andSize(String md5SizeExt) {
        String fileMd5 = md5SizeExt.substring(0, 32);
        int pos = md5SizeExt.indexOf(46);
        long fileSize = pos < 0 ? NumberBaseOpt.parseLong((String)md5SizeExt.substring(33), (Long)0L) : NumberBaseOpt.parseLong((String)md5SizeExt.substring(33, pos), (Long)0L);
        return Pair.of((Object)fileMd5, (Object)fileSize);
    }

    @CrossOrigin(origins={"*"}, allowCredentials="true", maxAge=86400L, allowedHeaders={"*"}, methods={RequestMethod.GET})
    @RequestMapping(value={"/exists"}, method={RequestMethod.GET})
    public void checkFileExists(String token, long size, HttpServletResponse response) {
        JsonResultUtils.writeOriginalObject((Object)this.fileStore.checkFile(token, size), (HttpServletResponse)response);
    }

    @CrossOrigin(origins={"*"}, allowCredentials="true", maxAge=86400L, methods={RequestMethod.GET})
    @RequestMapping(value={"/range"}, method={RequestMethod.GET})
    public void checkFileRange(String token, long size, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Pair<String, InputStream> fileInfo = this.fetchInputStreamFromRequest(request);
        long tempFileSize = 0L;
        if (this.fileStore.checkFile(token, size)) {
            this.completedStoreFile(token, size, (String)fileInfo.getLeft(), response);
            tempFileSize = size;
        } else {
            tempFileSize = SystemTempFileUtils.checkTempFileSize((String)SystemTempFileUtils.getTempFilePath((String)token, (long)size));
        }
        JsonResultUtils.writeOriginalJson((String)UploadDownloadUtils.makeRangeUploadJson((long)tempFileSize).toJSONString(), (HttpServletResponse)response);
    }

    private void completedStoreFile(String fileMd5, long size, String fileName, HttpServletResponse response) {
        try {
            String fileId = fileMd5 + "_" + String.valueOf(size) + "." + FileType.getFileExtName((String)fileName);
            JSONObject json = new JSONObject();
            HashMap<String, String> json1 = new HashMap<String, String>();
            json1.put("src", "file/download/" + fileId + "?fileName=" + fileName);
            json1.put("fileId", fileId);
            json1.put("token", fileMd5);
            json1.put("name", fileName);
            json.put("code", (Object)0);
            json.put("message", (Object)"\u4e0a\u4f20\u6210\u529f");
            json.put("data", json1);
            JsonResultUtils.writeOriginalJson((String)json.toString(), (HttpServletResponse)response);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            JsonResultUtils.writeHttpErrorMessage((int)422, (String)("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff0c\u4f46\u662f\u5728\u4fdd\u5b58\u524d\uff1a" + e.getMessage()), (HttpServletResponse)response);
        }
    }

    private Pair<String, InputStream> fetchInputStreamFromRequest(HttpServletRequest request) throws IOException {
        boolean isMultipart;
        String fileName = request.getParameter("name");
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = request.getParameter("fileName");
        }
        if (!(isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request))) {
            return new ImmutablePair((Object)fileName, (Object)request.getInputStream());
        }
        StandardServletMultipartResolver resolver = new StandardServletMultipartResolver();
        MultipartHttpServletRequest multiRequest = resolver.resolveMultipart(request);
        Map map = multiRequest.getFileMap();
        InputStream fis = null;
        for (Map.Entry entry : map.entrySet()) {
            MultipartFile cMultipartFile = (MultipartFile)entry.getValue();
            fileName = cMultipartFile.getResource().getFilename();
            fis = cMultipartFile.getInputStream();
        }
        return new ImmutablePair((Object)fileName, fis);
    }

    @CrossOrigin(origins={"*"}, allowCredentials="true", maxAge=86400L, methods={RequestMethod.POST})
    @RequestMapping(value={"/range"}, method={RequestMethod.POST})
    public void uploadRange(String token, long size, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Pair<String, InputStream> fileInfo = this.fetchInputStreamFromRequest(request);
        String tempFilePath = SystemTempFileUtils.getTempFilePath((String)token, (long)size);
        if (this.fileStore.checkFile(token, size)) {
            this.completedStoreFile(token, size, (String)fileInfo.getLeft(), response);
            return;
        }
        try {
            long uploadSize = UploadDownloadUtils.uploadRange((String)tempFilePath, (InputStream)((InputStream)fileInfo.getRight()), (String)token, (long)size, (HttpServletRequest)request);
            if (uploadSize == 0L) {
                this.fileStore.saveFile(tempFilePath, token, size);
                this.completedStoreFile(token, size, (String)fileInfo.getLeft(), response);
                FileSystemOpt.deleteFile((String)tempFilePath);
                return;
            }
            if (uploadSize > 0L) {
                JsonResultUtils.writeOriginalJson((String)UploadDownloadUtils.makeRangeUploadJson((long)uploadSize).toJSONString(), (HttpServletResponse)response);
            }
        }
        catch (ObjectException e) {
            log.error(e.getMessage(), (Throwable)e);
            JsonResultUtils.writeHttpErrorMessage((int)e.getExceptionCode(), (String)e.getMessage(), (HttpServletResponse)response);
        }
    }

    @CrossOrigin(origins={"*"}, allowCredentials="true", maxAge=86400L, methods={RequestMethod.POST})
    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    @ApiOperation(value="1\u4e0a\u4f20\u6587\u4ef6")
    public void uploadFile(HttpServletRequest request, HttpServletResponse response) throws IOException {
        request.setCharacterEncoding("utf8");
        String tempFilePath = SystemTempFileUtils.getRandomTempFilePath();
        try {
            Pair<String, InputStream> fileInfo = this.fetchInputStreamFromRequest(request);
            int fileSize = FileIOOpt.writeInputStreamToFile((InputStream)((InputStream)fileInfo.getRight()), (String)tempFilePath);
            String fileMd5 = FileMD5Maker.makeFileMD5((File)new File(tempFilePath));
            this.fileStore.saveFile(tempFilePath);
            this.completedStoreFile(fileMd5, fileSize, (String)fileInfo.getLeft(), response);
            FileSystemOpt.deleteFile((String)tempFilePath);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            JsonResultUtils.writeErrorMessageJson((String)e.getMessage(), (HttpServletResponse)response);
        }
    }
}

