/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.client;

import com.centit.framework.appclient.AppSession;
import com.centit.framework.appclient.HttpReceiveJSON;
import com.centit.framework.appclient.RestfulHttpRequest;
import com.centit.im.client.IMClient;
import com.centit.im.client.MessageSenderIMImpl;
import com.centit.im.dto.FriendMemo;
import com.centit.im.dto.ImCustomer;
import com.centit.im.po.ImMessage;
import com.centit.support.common.ObjectException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMClientImpl
implements IMClient {
    private static Logger log = LoggerFactory.getLogger(MessageSenderIMImpl.class);
    private AppSession appSession;

    public void initAppSession(String appServerUrl, String appLoginUrl, String userCode, String password) {
        this.appSession = new AppSession(appServerUrl, false, userCode, password);
        this.appSession.setAppLoginUrl(appLoginUrl);
    }

    public CloseableHttpClient getHttpClient() throws Exception {
        return this.appSession.allocHttpClient();
    }

    public void releaseHttpClient(CloseableHttpClient httpClient) {
        this.appSession.releaseHttpClient(httpClient);
    }

    @Override
    public void setFriendMemo(FriendMemo memo) {
        String jsonStr = RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/webimcust/friend", (Object)memo);
        HttpReceiveJSON resJson = HttpReceiveJSON.valueOfJson((String)jsonStr);
        if (resJson.getCode() != 0) {
            throw new ObjectException((Object)memo, resJson.getMessage());
        }
    }

    @Override
    public void registerUser(ImCustomer user) {
        String jsonStr = RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/webimcust/register", (Object)user);
        HttpReceiveJSON resJson = HttpReceiveJSON.valueOfJson((String)jsonStr);
        if (resJson.getCode() != 0) {
            throw new ObjectException((Object)user, resJson.getMessage());
        }
    }

    @Override
    public void setUserConfig(ImCustomer cust) {
        String jsonStr = RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)("/webimcust/config/" + cust.getUserCode()), (Object)cust);
        HttpReceiveJSON resJson = HttpReceiveJSON.valueOfJson((String)jsonStr);
        if (resJson.getCode() != 0) {
            throw new ObjectException((Object)cust, resJson.getMessage());
        }
    }

    @Override
    public void sendMessage(ImMessage message) {
        String jsonStr = RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)("/webimcust/sendMessage/" + message.getReceiver() + "/" + message.getSender()), (Object)message);
        HttpReceiveJSON resJson = HttpReceiveJSON.valueOfJson((String)jsonStr);
        if (resJson.getCode() != 0) {
            throw new ObjectException((Object)message, resJson.getMessage());
        }
    }
}

