/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.client;

import com.centit.framework.model.adapter.MessageSender;
import com.centit.im.client.IMClient;
import com.centit.im.po.ImMessage;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.json.JSONOpt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageSenderIMImpl
implements MessageSender {
    private static Logger log = LoggerFactory.getLogger(MessageSenderIMImpl.class);
    private IMClient imClient;

    public void setImClient(IMClient imClient) {
        this.imClient = imClient;
    }

    public String sendMessage(String sender, String receiver, String msgSubject, String msgContent) {
        return this.sendMessage(sender, receiver, msgSubject, msgContent, null, null, null);
    }

    public String sendMessage(String sender, String receiver, String msgSubject, String msgContent, String optId, String optMethod, String optTag) {
        ImMessage message = new ImMessage();
        message.setSender(sender);
        message.setReceiver(receiver);
        message.setSenderName(sender);
        message.setSendTime(DatetimeOpt.currentUtilDate());
        message.setContent(JSONOpt.createHashMap((Object[])new Object[]{"title", msgSubject, "content", msgContent}));
        message.setType("S");
        message.setContentType("text");
        try {
            this.imClient.sendMessage(message);
            return "OK";
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return e.getMessage();
        }
    }
}

