/*
 * Decompiled with CFR 0.152.
 */
package com.centit.task.controller;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.support.common.ObjectException;
import com.centit.support.common.WorkTimeSpan;
import com.centit.support.database.utils.PageDesc;
import com.centit.task.po.TaskInfo;
import com.centit.task.service.TaskInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@Api(value="\u4efb\u52a1\u4fe1\u606f", tags={"\u4efb\u52a1\u4fe1\u606f\u63a5\u53e3\u7c7b"})
@RequestMapping(value={"/general/task"})
public class TaskInfoController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(TaskInfoController.class);
    @Autowired
    private TaskInfoService taskInfoService;

    @ApiOperation(value="\u4efb\u52a1\u4fe1\u606f\u5217\u8868", notes="\u4efb\u52a1\u4fe1\u606f\u5217\u8868")
    @WrapUpResponseBody
    @RequestMapping(method={RequestMethod.GET})
    public PageQueryResult listAllTaskInfo(PageDesc pageDesc, HttpServletRequest request) {
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            throw new ObjectException("\u60a8\u672a\u767b\u5f55");
        }
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        filterMap.put("unitCode", topUnit);
        List<TaskInfo> listObjects = this.taskInfoService.listTaskInfos(filterMap, pageDesc);
        JSONArray jsonArray = DictionaryMapUtils.objectsToJSONArray(listObjects);
        for (Object object : jsonArray) {
            JSONObject jsonObject = (JSONObject)object;
            this.translateWorkLoadDate(jsonObject);
        }
        return PageQueryResult.createResult((Collection)jsonArray, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u4efb\u52a1\u4fe1\u606f", notes="\u67e5\u8be2\u5355\u4e2a\u4efb\u52a1\u4fe1\u606f")
    @WrapUpResponseBody
    @RequestMapping(value={"/{taskId}"}, method={RequestMethod.GET})
    public JSONObject getTaskInfoByCode(@PathVariable String taskId) {
        TaskInfo taskInfo = this.taskInfoService.getTaskInfoByCode(taskId);
        if (null == taskId) {
            return new JSONObject();
        }
        JSONObject jsonObject = (JSONObject)DictionaryMapUtils.objectToJSON((Object)taskInfo);
        this.translateWorkLoadDate(jsonObject);
        return jsonObject;
    }

    @ApiOperation(value="\u4fdd\u5b58\u4efb\u52a1\u4fe1\u606f", notes="\u4fdd\u5b58\u4efb\u52a1\u4fe1\u606f")
    @WrapUpResponseBody
    @RequestMapping(method={RequestMethod.POST})
    public TaskInfo saveTaskInfo(@RequestBody TaskInfo taskInfo, HttpServletRequest request) {
        this.addUserInfoToTaskInfo(taskInfo, request);
        this.taskInfoService.saveTaskInfo(taskInfo);
        return taskInfo;
    }

    @ApiOperation(value="\u4fee\u6539\u4efb\u52a1\u4fe1\u606f", notes="\u4fee\u6539\u4efb\u52a1\u4fe1\u606f,\u540c\u65f6\u4f1a\u6dfb\u52a0\u5907\u6ce8\u4fe1\u606f")
    @WrapUpResponseBody
    @RequestMapping(method={RequestMethod.PUT})
    public ResponseData updateTaskInfo(@RequestBody TaskInfo taskInfo, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)taskInfo.getTaskId())) {
            return ResponseData.makeErrorMessage((String)"taskId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.addUserInfoToTaskInfo(taskInfo, request);
        this.taskInfoService.updateTaskInfo(taskInfo);
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u5220\u9664\u4efb\u52a1\u4fe1\u606f", notes="\u5220\u9664\u4efb\u52a1\u4fe1\u606f")
    @WrapUpResponseBody
    @RequestMapping(value={"/{taskId}"}, method={RequestMethod.DELETE})
    public void deleteFlowRoleByCode(@PathVariable String taskId, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException("\u60a8\u672a\u767b\u5f55");
        }
        this.taskInfoService.deleteTaskInfoByCode(taskId, userCode);
    }

    @ApiOperation(value="\u7edf\u8ba1\u4efb\u52a1\u6570", notes="taskCount\u4efb\u52a1\u6570,taskState\u72b6\u6001,workload\u5de5\u4f5c\u91cf")
    @WrapUpResponseBody
    @RequestMapping(value={"/stat-task"}, method={RequestMethod.GET})
    public JSONArray countTaskInfo(HttpServletRequest request) {
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            throw new ObjectException("\u60a8\u672a\u767b\u5f55");
        }
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        filterMap.put("unitCode", topUnit);
        return this.taskInfoService.statTaskInfo(filterMap);
    }

    @ApiOperation(value="\u7edf\u8ba1\u9879\u76ee\u7ec4\u6210\u5458\u4efb\u52a1\u6570", notes="taskCount\u4efb\u52a1\u6570,taskState\u72b6\u6001,workload\u5de5\u4f5c\u91cf")
    @WrapUpResponseBody
    @RequestMapping(value={"/stat-member"}, method={RequestMethod.GET})
    public JSONArray statMember(HttpServletRequest request) {
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            throw new ObjectException("\u60a8\u672a\u767b\u5f55");
        }
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        filterMap.put("unitCode", topUnit);
        return this.taskInfoService.statMember(filterMap);
    }

    @ApiOperation(value="\u7edf\u8ba1\u4e2a\u4eba\u9879\u76ee\u4efb\u52a1\u6570", notes="taskCount\u4efb\u52a1\u6570,taskState\u72b6\u6001,workload\u5de5\u4f5c\u91cf")
    @WrapUpResponseBody
    @RequestMapping(value={"/stat-personal-task"}, method={RequestMethod.GET})
    public JSONArray statPersonalTask(HttpServletRequest request) {
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            throw new ObjectException("\u60a8\u672a\u767b\u5f55");
        }
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        filterMap.put("unitCode", topUnit);
        return this.taskInfoService.statPersonalTask(filterMap);
    }

    @ApiOperation(value="\u7edf\u8ba1\u79df\u6237\u4e0b\u9879\u76ee\u5206\u5e03", notes="\u4e0d\u9700\u8981\u53c2\u6570")
    @WrapUpResponseBody
    @RequestMapping(value={"/stat-unit-task"}, method={RequestMethod.GET})
    public JSONObject statUnitTask(HttpServletRequest request) {
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            throw new ObjectException("\u60a8\u672a\u767b\u5f55");
        }
        return this.taskInfoService.statUnitTask(topUnit);
    }

    @ApiOperation(value="\u7edf\u8ba1\u79df\u6237\u4e0b\u4eba\u5458\u5206\u5e03", notes="\u4e0d\u9700\u8981\u53c2\u6570")
    @WrapUpResponseBody
    @RequestMapping(value={"/stat-unit-person"}, method={RequestMethod.GET})
    public JSONArray statUnitPerson(HttpServletRequest request) {
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            throw new ObjectException("\u60a8\u672a\u767b\u5f55");
        }
        return this.taskInfoService.statUnitPerson(topUnit);
    }

    private void translateWorkLoadDate(JSONObject jsonObject) {
        WorkTimeSpan workTimeSpan = new WorkTimeSpan();
        workTimeSpan.fromNumberAsMinute(jsonObject.getLongValue("workload"));
        jsonObject.put((Object)"workloadMinute", (Object)workTimeSpan.toStringAsMinute().toLowerCase());
        workTimeSpan.fromNumberAsMinute(jsonObject.getLongValue("estimateWorkload"));
        jsonObject.put((Object)"estimateWorkloadMinute", (Object)workTimeSpan.toStringAsMinute().toLowerCase());
    }

    private void addUserInfoToTaskInfo(TaskInfo taskInfo, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException("\u60a8\u8fd8\u672a\u767b\u5f55");
        }
        taskInfo.setUserCode(userCode);
        taskInfo.setUnitCode(WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
    }
}

