/*
 * Decompiled with CFR 0.152.
 */
package com.centit.task.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.centit.task.dao.TaskLogDao;
import com.centit.task.po.TaskLog;
import com.centit.task.service.TaskInfoService;
import com.centit.task.service.TaskLogService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskLogServiceImpl
implements TaskLogService {
    private static final Logger log = LoggerFactory.getLogger(TaskLogServiceImpl.class);
    @Autowired
    private TaskLogDao taskLogDao;
    @Autowired
    private TaskInfoService taskInfoService;

    @Override
    @Transactional
    public List<TaskLog> listTaskLogs(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.taskLogDao.listObjects(filterMap, pageDesc);
    }

    @Override
    @Transactional
    public TaskLog getTaskLogByCode(String logId) {
        return (TaskLog)this.taskLogDao.getObjectById(logId);
    }

    @Override
    @Transactional
    public void saveTaskLog(TaskLog taskLog) {
        this.taskLogDao.mergeObject(taskLog);
        if (0L != taskLog.getWorkload() && !"M".equals(taskLog.getLogType())) {
            this.taskInfoService.incrementWorkload(taskLog.getWorkload(), taskLog.getTaskId());
        }
    }

    @Override
    @Transactional
    public void deleteTaskLogByCode(String logId, String userCode) {
        TaskLog taskLog = (TaskLog)this.taskLogDao.getObjectById(logId);
        if (null == taskLog) {
            throw new ObjectException("\u65e5\u5fd7\u4fe1\u606f\u4e0d\u5b58\u5728!");
        }
        if (!taskLog.getLogType().equals("R") || !taskLog.getUserCode().equals(userCode)) {
            throw new ObjectException("\u53ea\u80fd\u5220\u9664\u81ea\u5df1\u7684\u65e5\u5fd7\u4fe1\u606f");
        }
        this.taskInfoService.decrementWorkload(taskLog.getWorkload(), taskLog.getTaskId());
        this.taskLogDao.deleteObjectById(logId);
    }

    @Override
    public JSONArray statTaskLog(Map<String, Object> filterMap) {
        return this.taskLogDao.statTaskLog(filterMap);
    }
}

