/*
 * Decompiled with CFR 0.152.
 */
package com.centit.task.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.model.basedata.IDataDictionary;
import com.centit.framework.model.basedata.IUserInfo;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.centit.task.dao.TaskInfoDao;
import com.centit.task.dao.TaskLogDao;
import com.centit.task.po.TaskInfo;
import com.centit.task.po.TaskLog;
import com.centit.task.service.TaskInfoService;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskInfoServiceImpl
implements TaskInfoService {
    private static final Logger log = LoggerFactory.getLogger(TaskInfoServiceImpl.class);
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private TaskLogDao taskLogDao;
    private final String TASK_STATE_TEMPLATE = "%s\u66f4\u6539\u4efb\u52a1\u72b6\u6001\u4e3a%s\u3002";
    private final String TASK_TRANSFER_TEMPLATE = "\u4efb\u52a1\u7531%s\u4ece%s\u8f6c\u79fb\u5230%s\u3002";
    private final String TASK_CREATE_TEMPLATE = "%s\u521b\u5efa\u4e86\u4efb\u52a1\uff0c\u5e76\u4e14\u628a\u4efb\u52a1\u5206\u914d\u7ed9\u4e86%s\u3002";
    private final String TASK_TITLE_UPDATE_TEMPLATE = "%s\u628a\u4efb\u52a1\u6807\u9898\u7531%s\u4fee\u6539\u4e3a%s\u3002";
    private final String TASK_CONTENT_UPDATE_TEMPLATE = "%s\u4fee\u6539\u4e86\u4efb\u52a1\u8be6\u60c5\u3002";

    @Override
    @Transactional
    public List<TaskInfo> listTaskInfos(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.taskInfoDao.listObjects(filterMap, pageDesc);
    }

    @Override
    @Transactional
    public TaskInfo getTaskInfoByCode(String taskId) {
        return (TaskInfo)this.taskInfoDao.getObjectById(taskId);
    }

    @Override
    @Transactional
    public void saveTaskInfo(TaskInfo taskInfo) {
        IUserInfo taskOfficerInfo = CodeRepositoryUtil.getUserInfoByCode((String)taskInfo.getUnitCode(), (String)taskInfo.getTaskOfficer());
        if (null == taskOfficerInfo) {
            throw new ObjectException("\u4efb\u52a1\u5206\u914d\u4eba\u4fe1\u606f\u6709\u8bef");
        }
        taskInfo.setWorkload(0L);
        this.taskInfoDao.mergeObject(taskInfo);
        IUserInfo reporterNameInfo = CodeRepositoryUtil.getUserInfoByCode((String)taskInfo.getUnitCode(), (String)taskInfo.getTaskReporter());
        this.updateMemoTaskLog(taskInfo, String.format("%s\u521b\u5efa\u4e86\u4efb\u52a1\uff0c\u5e76\u4e14\u628a\u4efb\u52a1\u5206\u914d\u7ed9\u4e86%s\u3002", reporterNameInfo.getUserName(), taskOfficerInfo.getUserName()));
    }

    @Override
    @Transactional
    public void deleteTaskInfoByCode(String taskId, String userCode) {
        TaskInfo dbTaskInfo = (TaskInfo)this.taskInfoDao.getObjectById(taskId);
        if (!dbTaskInfo.getTaskReporter().equals(userCode)) {
            throw new ObjectException("\u53ea\u6709\u4efb\u52a1\u62a5\u544a\u4eba\u624d\u80fd\u5220\u9664\u4efb\u52a1");
        }
        this.taskLogDao.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"taskId", dbTaskInfo.getTaskId()}));
        this.taskInfoDao.deleteObjectById(taskId);
    }

    @Override
    @Transactional
    public void updateTaskInfo(TaskInfo taskInfo) {
        TaskInfo dbTaskInfo = (TaskInfo)this.taskInfoDao.getObjectById(taskInfo.getTaskId());
        if (null == dbTaskInfo) {
            throw new ObjectException("\u4efb\u52a1\u4e0d\u5b58\u5728!");
        }
        this.taskInfoDao.updateObject(taskInfo);
        this.appendSystemLog(taskInfo, dbTaskInfo);
    }

    @Override
    public void incrementWorkload(long increment, String taskId) {
        this.taskInfoDao.incrementWorkload(increment, taskId);
    }

    @Override
    public void decrementWorkload(long increment, String taskId) {
        this.taskInfoDao.decrementWorkload(increment, taskId);
    }

    private boolean isChange(Supplier<String> supplier, String oldValue) {
        return StringUtils.isNotBlank((CharSequence)supplier.get()) && !supplier.get().equals(oldValue);
    }

    private void updateMemoTaskLog(TaskInfo taskInfo, String logContent) {
        TaskLog taskLog = new TaskLog();
        taskLog.setTaskId(taskInfo.getTaskId());
        taskLog.setLogType("M");
        taskLog.setUserCode("system");
        taskLog.setUnitCode(taskInfo.getUnitCode());
        taskLog.setWorkload(0L);
        taskLog.setLogContent(logContent);
        taskLog.setOsId(taskInfo.getOsId());
        this.taskLogDao.saveNewObject(taskLog);
    }

    private void appendSystemLog(TaskInfo taskInfo, TaskInfo dbTaskInfo) {
        IUserInfo currentUserInfo;
        if (this.isChange(taskInfo::getTaskState, dbTaskInfo.getTaskState())) {
            currentUserInfo = CodeRepositoryUtil.getUserInfoByCode((String)taskInfo.getUnitCode(), (String)taskInfo.getUserCode());
            if (null == currentUserInfo) {
                throw new ObjectException("\u5f53\u524d\u7528\u6237\u4fe1\u606f\u6709\u8bef");
            }
            IDataDictionary taskStateDic = CodeRepositoryUtil.getDataPiece((String)"taskState", (String)taskInfo.getTaskState(), null);
            String taskStateText = null == taskStateDic ? taskInfo.getTaskState() : taskStateDic.getDataValue();
            this.updateMemoTaskLog(taskInfo, String.format("%s\u66f4\u6539\u4efb\u52a1\u72b6\u6001\u4e3a%s\u3002", currentUserInfo.getUserName(), taskStateText));
        }
        if (this.isChange(taskInfo::getTaskOfficer, dbTaskInfo.getTaskOfficer())) {
            IUserInfo taskOfficerUserInfo = CodeRepositoryUtil.getUserInfoByCode((String)taskInfo.getUnitCode(), (String)taskInfo.getTaskOfficer());
            if (null == taskOfficerUserInfo) {
                throw new ObjectException(taskInfo.getTaskOfficer() + " \u7528\u6237\u4e0d\u5b58\u5728!");
            }
            IUserInfo dbUserInfo = CodeRepositoryUtil.getUserInfoByCode((String)dbTaskInfo.getUnitCode(), (String)dbTaskInfo.getTaskOfficer());
            IUserInfo taskInfoUserInfo = CodeRepositoryUtil.getUserInfoByCode((String)taskInfo.getUnitCode(), (String)taskInfo.getUserCode());
            String logContent = String.format("\u4efb\u52a1\u7531%s\u4ece%s\u8f6c\u79fb\u5230%s\u3002", taskInfoUserInfo.getUserName(), dbUserInfo.getUserName(), taskOfficerUserInfo.getUserName());
            this.updateMemoTaskLog(taskInfo, logContent);
        }
        if (this.isChange(taskInfo::getTaskTitle, dbTaskInfo.getTaskTitle())) {
            currentUserInfo = CodeRepositoryUtil.getUserInfoByCode((String)taskInfo.getUnitCode(), (String)taskInfo.getUserCode());
            if (null == currentUserInfo) {
                throw new ObjectException(taskInfo.getTaskOfficer() + " \u7528\u6237\u4e0d\u5b58\u5728!");
            }
            String logContent = String.format("%s\u628a\u4efb\u52a1\u6807\u9898\u7531%s\u4fee\u6539\u4e3a%s\u3002", currentUserInfo.getUserName(), dbTaskInfo.getTaskTitle(), taskInfo.getTaskTitle());
            this.updateMemoTaskLog(taskInfo, logContent);
        }
        if (this.isChange(taskInfo::getTaskContent, dbTaskInfo.getTaskContent())) {
            currentUserInfo = CodeRepositoryUtil.getUserInfoByCode((String)taskInfo.getUnitCode(), (String)taskInfo.getUserCode());
            if (null == currentUserInfo) {
                throw new ObjectException(taskInfo.getTaskOfficer() + " \u7528\u6237\u4e0d\u5b58\u5728!");
            }
            this.updateMemoTaskLog(taskInfo, String.format("%s\u4fee\u6539\u4e86\u4efb\u52a1\u8be6\u60c5\u3002", currentUserInfo.getUserName()));
        }
    }

    @Override
    public JSONArray statTaskInfo(Map<String, Object> filterMap) {
        return this.taskInfoDao.statTaskInfo(filterMap);
    }

    @Override
    public JSONArray statMember(Map<String, Object> filterMap) {
        return this.taskInfoDao.statMember(filterMap);
    }

    @Override
    public JSONArray statPersonalTask(Map<String, Object> filterMap) {
        return this.taskInfoDao.statPersonalTask(filterMap);
    }

    @Override
    public JSONObject statUnitTask(String topUnit) {
        return this.taskInfoDao.statUnitTask(topUnit);
    }

    @Override
    public JSONArray statUnitPerson(String topUnit) {
        return this.taskInfoDao.statUnitPerson(topUnit);
    }
}

