/*
 * Decompiled with CFR 0.152.
 */
package com.centit.task.dao;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.common.WorkTimeSpan;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import com.centit.task.po.TaskInfo;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class TaskInfoDao
extends BaseDaoImpl<TaskInfo, String> {
    protected Logger logger = LoggerFactory.getLogger(TaskInfoDao.class);

    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("taskId", "EQUAL");
        filterField.put("taskTitle", "LIKE");
        filterField.put("taskContent", "LIKE");
        filterField.put("taskOfficer", "EQUAL");
        filterField.put("taskReporter", "EQUAL");
        filterField.put("unitCode", "EQUAL");
        filterField.put("userCode", "EQUAL");
        filterField.put("osId", "EQUAL");
        filterField.put("optId", "EQUAL");
        filterField.put("optMethod", "EQUAL");
        filterField.put("(splitforin)taskState", "IN");
        filterField.put("(splitforin)taskClass", "IN");
        filterField.put("(splitforin)taskPriority", "IN");
        return filterField;
    }

    @Transactional
    public void incrementWorkload(long increment, String taskId) {
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)" UPDATE F_TASK_INFO SET WORKLOAD = WORKLOAD + ?  WHERE TASK_ID = ? ", (Object[])new Object[]{increment, taskId});
        this.logger.info("incrementWorkload \uff1a  UPDATE F_TASK_INFO SET WORKLOAD = WORKLOAD + ?  WHERE TASK_ID = ?  \u53c2\u6570:{}, {} ", (Object)increment, (Object)taskId);
    }

    @Transactional
    public void decrementWorkload(long decrement, String taskId) {
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)" UPDATE F_TASK_INFO SET WORKLOAD =  WORKLOAD - ?    WHERE TASK_ID = ? ", (Object[])new Object[]{decrement, taskId});
        this.logger.info("decrementWorkload \uff1a   UPDATE F_TASK_INFO SET WORKLOAD =  WORKLOAD - ?    WHERE TASK_ID = ?   \u53c2\u6570:{}, {} ", (Object)decrement, (Object)taskId);
    }

    public JSONArray statTaskInfo(Map<String, Object> filterMap) {
        String sql = "SELECT task_state,count(0) task_count,sum(WORKLOAD) do_work,sum(ESTIMATE_WORKLOAD) sum_work FROM f_task_info where task_state in ('A','B','C')[:unitCode | and unit_code=:unitCode] [:taskOfficer | and task_officer=:taskOfficer][:taskReporter | and task_reporter=:taskReporter] [:osId | and os_id=:osId] group by TASK_STATE";
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)sql, filterMap);
        WorkTimeSpan workTimeSpan = new WorkTimeSpan();
        JSONArray jsonArray = DatabaseOptUtils.listObjectsByNamedSqlAsJson((BaseDaoImpl)this, (String)qap.getQuery(), (Map)qap.getParams());
        for (Object object : jsonArray) {
            JSONObject jsonObject = (JSONObject)object;
            String taskState = jsonObject.getString("taskState");
            int doWork = jsonObject.getIntValue("doWork");
            int sumWork = jsonObject.getIntValue("sumWork");
            switch (taskState) {
                case "A": {
                    workTimeSpan.fromNumberAsMinute((long)sumWork);
                    break;
                }
                case "B": {
                    workTimeSpan.fromNumberAsMinute((long)(sumWork - doWork));
                    break;
                }
                case "C": {
                    workTimeSpan.fromNumberAsMinute((long)doWork);
                    break;
                }
            }
            jsonObject.put("workload", (Object)workTimeSpan.toStringAsMinute().toLowerCase());
        }
        return jsonArray;
    }

    public JSONArray statPersonalTask(Map<String, Object> filterMap) {
        String sql = "SELECT os_id,task_state,count(0) task_count,sum(WORKLOAD) do_work,sum(ESTIMATE_WORKLOAD) sum_work FROM f_task_info where task_state in ('A','B','C')[:unitCode | and unit_code=:unitCode] [:taskOfficer | and task_officer=:taskOfficer] group by TASK_STATE,os_id";
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)sql, filterMap);
        WorkTimeSpan workTimeSpan = new WorkTimeSpan();
        JSONArray jsonArray = DatabaseOptUtils.listObjectsByNamedSqlAsJson((BaseDaoImpl)this, (String)qap.getQuery(), (Map)qap.getParams());
        for (Object object : jsonArray) {
            JSONObject jsonObject = (JSONObject)object;
            String osId = jsonObject.getString("osId");
            String osName = CodeRepositoryUtil.getValue((String)"osId", (String)osId);
            jsonObject.put("osName", (Object)osName);
            String taskState = jsonObject.getString("taskState");
            int doWork = jsonObject.getIntValue("doWork");
            int sumWork = jsonObject.getIntValue("sumWork");
            switch (taskState) {
                case "A": {
                    workTimeSpan.fromNumberAsMinute((long)sumWork);
                    break;
                }
                case "B": {
                    workTimeSpan.fromNumberAsMinute((long)(sumWork - doWork));
                    break;
                }
                case "C": {
                    workTimeSpan.fromNumberAsMinute((long)doWork);
                    break;
                }
            }
            jsonObject.put("workload", (Object)workTimeSpan.toStringAsMinute().toLowerCase());
        }
        return jsonArray;
    }

    public JSONArray statMember(Map<String, Object> filterMap) {
        String sql = "SELECT task_Officer,task_state,count(0) task_count,sum(WORKLOAD) do_work,sum(ESTIMATE_WORKLOAD) sum_work FROM f_task_info where task_state in ('A','B','C')[:unitCode | and unit_code=:unitCode] [:osId | and os_id=:osId] group by TASK_STATE,task_Officer";
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)sql, filterMap);
        WorkTimeSpan workTimeSpan = new WorkTimeSpan();
        JSONArray jsonArray = DatabaseOptUtils.listObjectsByNamedSqlAsJson((BaseDaoImpl)this, (String)qap.getQuery(), (Map)qap.getParams());
        for (Object object : jsonArray) {
            JSONObject jsonObject = (JSONObject)object;
            String userCode = jsonObject.getString("taskOfficer");
            String userName = CodeRepositoryUtil.getValue((String)"userCode", (String)userCode);
            jsonObject.put("userName", (Object)userName);
            String taskState = jsonObject.getString("taskState");
            int doWork = jsonObject.getIntValue("doWork");
            int sumWork = jsonObject.getIntValue("sumWork");
            switch (taskState) {
                case "A": {
                    workTimeSpan.fromNumberAsMinute((long)sumWork);
                    break;
                }
                case "B": {
                    workTimeSpan.fromNumberAsMinute((long)(sumWork - doWork));
                    break;
                }
                case "C": {
                    workTimeSpan.fromNumberAsMinute((long)doWork);
                    break;
                }
            }
            jsonObject.put("workload", (Object)workTimeSpan.toStringAsMinute().toLowerCase());
        }
        return jsonArray;
    }

    public JSONObject statUnitTask(String topUnit) {
        String sql = "select sum(if(radio>=0 and radio<25,1,0)) twenty,sum(if(radio>=25 and radio<75,1,0)) seventy,sum(if(radio>=75 and radio<100,1,0)) hundred,sum(if(radio>100,1,0)) over_task from (SELECT WORKLOAD*100/ESTIMATE_WORKLOAD radio FROM f_task_info where [:unitCode | unit_code=:unitCode]) a";
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)sql, (Object)CollectionsOpt.createHashMap((Object[])new Object[]{"unitCode", topUnit}));
        return DatabaseOptUtils.getObjectBySqlAsJson((BaseDaoImpl)this, (String)qap.getQuery(), (Map)qap.getParams());
    }

    public JSONArray statUnitPerson(String topUnit) {
        String sql = "select TASK_OFFICER,sum(ESTIMATE_WORKLOAD) sum_workload from f_task_info where [:unitCode | unit_code=:unitCode] and task_state in ('A','B') group by TASK_OFFICER";
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)sql, (Object)CollectionsOpt.createHashMap((Object[])new Object[]{"unitCode", topUnit}));
        JSONArray jsonArray = DatabaseOptUtils.listObjectsByNamedSqlAsJson((BaseDaoImpl)this, (String)qap.getQuery(), (Map)qap.getParams());
        for (Object object : jsonArray) {
            JSONObject jsonObject = (JSONObject)object;
            String userCode = jsonObject.getString("taskOfficer");
            String userName = CodeRepositoryUtil.getValue((String)"userCode", (String)userCode);
            jsonObject.put("userName", (Object)userName);
        }
        return jsonArray;
    }
}

