/*
 * Decompiled with CFR 0.152.
 */
package com.centit.task.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.support.common.ObjectException;
import com.centit.support.common.WorkTimeSpan;
import com.centit.support.database.utils.PageDesc;
import com.centit.task.po.TaskLog;
import com.centit.task.service.TaskLogService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@Api(value="\u4efb\u52a1\u65e5\u5fd7", tags={"\u4efb\u52a1\u65e5\u5fd7\u63a5\u53e3\u7c7b"})
@RequestMapping(value={"/general/log"})
public class TaskLogController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(TaskLogController.class);
    @Autowired
    private TaskLogService taskLogService;

    @ApiOperation(value="\u4efb\u52a1\u65e5\u5fd7\u5217\u8868", notes="\u4efb\u52a1\u65e5\u5fd7\u5217\u8868")
    @WrapUpResponseBody
    @RequestMapping(method={RequestMethod.GET})
    public PageQueryResult listAllTaskLog(PageDesc pageDesc, HttpServletRequest request) {
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        List<TaskLog> listObjects = this.taskLogService.listTaskLogs(filterMap, pageDesc);
        JSONArray jsonArray = DictionaryMapUtils.objectsToJSONArray(listObjects);
        for (Object object : jsonArray) {
            JSONObject jsonObject = (JSONObject)object;
            if ("system".equals(jsonObject.getString("userCode"))) {
                jsonObject.put("userName", (Object)"\u7cfb\u7edf\u65e5\u5fd7");
            }
            WorkTimeSpan workTimeSpan = new WorkTimeSpan();
            workTimeSpan.fromNumberAsMinute(jsonObject.getLongValue("workload"));
            jsonObject.put("workloadMinute", (Object)workTimeSpan.toStringAsMinute().toLowerCase());
        }
        return PageQueryResult.createResult((Collection)jsonArray, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u4efb\u52a1\u65e5\u5fd7", notes="\u67e5\u8be2\u5355\u4e2a\u4efb\u52a1\u65e5\u5fd7")
    @WrapUpResponseBody
    @RequestMapping(value={"/{logId}"}, method={RequestMethod.GET})
    public TaskLog getTaskLogByCode(@PathVariable String logId) {
        return this.taskLogService.getTaskLogByCode(logId);
    }

    @ApiOperation(value="\u4fdd\u5b58\u4efb\u52a1\u65e5\u5fd7", notes="\u4fdd\u5b58\u4efb\u52a1\u65e5\u5fd7")
    @WrapUpResponseBody
    @RequestMapping(method={RequestMethod.POST})
    public TaskLog saveFlowRole(@RequestBody TaskLog taskLog) {
        if (null == taskLog.getWorkload()) {
            taskLog.setWorkload(0L);
        }
        this.taskLogService.saveTaskLog(taskLog);
        return taskLog;
    }

    @ApiOperation(value="\u5220\u9664\u4efb\u52a1\u65e5\u5fd7", notes="\u5220\u9664\u4efb\u52a1\u65e5\u5fd7")
    @WrapUpResponseBody
    @RequestMapping(value={"/{logId}"}, method={RequestMethod.DELETE})
    public void deleteFlowRoleByCode(@PathVariable String logId, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException("\u60a8\u8fd8\u672a\u767b\u5f55!");
        }
        this.taskLogService.deleteTaskLogByCode(logId, userCode);
    }

    @ApiOperation(value="\u5de5\u4f5c\u91cf\u7edf\u8ba1", notes="\u5de5\u4f5c\u91cf\u7edf\u8ba1")
    @WrapUpResponseBody
    @RequestMapping(value={"/stat"}, method={RequestMethod.GET})
    public JSONArray statTaskLog(HttpServletRequest request) {
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        return this.taskLogService.statTaskLog(filterMap);
    }
}

