/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.transaction;

import com.centit.dde.transaction.AbstractDruidConnectPools;
import com.centit.dde.transaction.AbstractHttpConnectPools;
import com.centit.product.metadata.vo.ISourceInfo;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.network.HttpExecutorContext;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class SourceConnectThreadWrapper
implements Serializable {
    private final Map<ISourceInfo, Object> connectPools = new ConcurrentHashMap<ISourceInfo, Object>(4);

    SourceConnectThreadWrapper() {
    }

    Object fetchConnect(ISourceInfo description) throws Exception {
        if (StringBaseOpt.isNvl((String)description.getSourceType()) || "D".equals(description.getSourceType())) {
            Connection conn = (Connection)this.connectPools.get(description);
            if (conn == null) {
                conn = AbstractDruidConnectPools.getDbcpConnect(description);
                this.connectPools.put(description, conn);
            }
            return conn;
        }
        if ("H".equals(description.getSourceType())) {
            HttpExecutorContext conn = (HttpExecutorContext)this.connectPools.get(description);
            if (conn == null) {
                conn = AbstractHttpConnectPools.getHttpConnect(description);
                this.connectPools.put(description, conn);
            }
            return conn;
        }
        return null;
    }

    void commitAllWork() throws Exception {
        if (this.connectPools.size() == 0) {
            return;
        }
        for (Map.Entry<ISourceInfo, Object> map : this.connectPools.entrySet()) {
            if (!StringBaseOpt.isNvl((String)map.getKey().getSourceType()) && !"D".equals(map.getKey().getSourceType())) continue;
            Connection conn = (Connection)map.getValue();
            conn.commit();
        }
    }

    void rollbackAllWork() throws Exception {
        if (this.connectPools.size() == 0) {
            return;
        }
        for (Map.Entry<ISourceInfo, Object> map : this.connectPools.entrySet()) {
            if (!StringBaseOpt.isNvl((String)map.getKey().getSourceType()) && !"D".equals(map.getKey().getSourceType())) continue;
            Connection conn = (Connection)map.getValue();
            conn.rollback();
        }
    }

    void releaseAllConnect() {
        if (this.connectPools.size() == 0) {
            return;
        }
        for (Map.Entry<ISourceInfo, Object> map : this.connectPools.entrySet()) {
            if (StringBaseOpt.isNvl((String)map.getKey().getSourceType()) || "D".equals(map.getKey().getSourceType())) {
                Connection conn = (Connection)map.getValue();
                AbstractDruidConnectPools.closeConnect(conn);
                continue;
            }
            if (!"H".equals(map.getKey().getSourceType())) continue;
            AbstractHttpConnectPools.releaseHttp(map.getKey());
        }
        this.connectPools.clear();
    }
}

