/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.transaction;

import com.centit.dde.transaction.SourceConnectThreadLocal;
import com.centit.dde.transaction.SourceConnectThreadWrapper;
import com.centit.product.metadata.vo.ISourceInfo;

public abstract class AbstractSourceConnectThreadHolder {
    private static SourceConnectThreadLocal threadLocal = new SourceConnectThreadLocal();

    private AbstractSourceConnectThreadHolder() {
    }

    private static SourceConnectThreadWrapper getConnectThreadWrapper() {
        SourceConnectThreadWrapper wrapper = (SourceConnectThreadWrapper)threadLocal.get();
        if (wrapper == null) {
            wrapper = new SourceConnectThreadWrapper();
            threadLocal.set(wrapper);
        }
        return wrapper;
    }

    public static Object fetchConnect(ISourceInfo description) throws Exception {
        SourceConnectThreadWrapper wrapper = AbstractSourceConnectThreadHolder.getConnectThreadWrapper();
        return wrapper.fetchConnect(description);
    }

    public static void commitAndRelease() throws Exception {
        SourceConnectThreadWrapper wrapper = AbstractSourceConnectThreadHolder.getConnectThreadWrapper();
        try {
            wrapper.commitAllWork();
        }
        finally {
            wrapper.releaseAllConnect();
            threadLocal.superRemove();
        }
    }

    public static void rollbackAndRelease() throws Exception {
        SourceConnectThreadWrapper wrapper = AbstractSourceConnectThreadHolder.getConnectThreadWrapper();
        try {
            wrapper.rollbackAllWork();
        }
        finally {
            wrapper.releaseAllConnect();
            threadLocal.superRemove();
        }
    }
}

