/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.transaction;

import com.centit.product.metadata.vo.ISourceInfo;
import com.centit.support.network.HttpExecutor;
import com.centit.support.network.HttpExecutorContext;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.client.CookieStore;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractHttpConnectPools {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHttpConnectPools.class);
    private static final Map<ISourceInfo, HttpExecutorContext> HTTP_DATA_SOURCE_POOLS = new ConcurrentHashMap<ISourceInfo, HttpExecutorContext>();

    private AbstractHttpConnectPools() {
        throw new IllegalAccessError("Utility class");
    }

    private static HttpExecutorContext mapHttpSource(ISourceInfo dsDesc) throws IOException {
        HttpClientContext context = HttpClientContext.create();
        BasicCookieStore cookieStore = new BasicCookieStore();
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultCookieStore((CookieStore)cookieStore).build();
        if (dsDesc.getDatabaseUrl() != null) {
            HttpExecutor.formPost((HttpExecutorContext)HttpExecutorContext.create((CloseableHttpClient)httpClient).context((HttpContext)context), (String)dsDesc.getDatabaseUrl(), (Object)dsDesc.getExtProps(), (boolean)false);
        }
        context.setCookieStore((CookieStore)cookieStore);
        return HttpExecutorContext.create((CloseableHttpClient)httpClient).context((HttpContext)context);
    }

    static synchronized HttpExecutorContext getHttpConnect(ISourceInfo dsDesc) throws IOException {
        HttpExecutorContext ds = HTTP_DATA_SOURCE_POOLS.get(dsDesc);
        if (ds == null) {
            ds = AbstractHttpConnectPools.mapHttpSource(dsDesc);
            HTTP_DATA_SOURCE_POOLS.put(dsDesc, ds);
        }
        return ds;
    }

    static void releaseHttp(ISourceInfo dsDesc) {
        HTTP_DATA_SOURCE_POOLS.remove(dsDesc);
    }
}

