/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.transaction;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.centit.product.metadata.vo.ISourceInfo;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.DBType;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractDruidConnectPools {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDruidConnectPools.class);
    private static final Map<ISourceInfo, DruidDataSource> DRUID_DATA_SOURCE_POOLS = new ConcurrentHashMap<ISourceInfo, DruidDataSource>();

    private AbstractDruidConnectPools() {
        throw new IllegalAccessError("Utility class");
    }

    private static DruidDataSource mapDataSource(ISourceInfo dsDesc) {
        DruidDataSource ds = new DruidDataSource();
        ds.setDriverClassName(DBType.getDbDriver((DBType)DBType.mapDBType((String)dsDesc.getDatabaseUrl())));
        ds.setUsername(dsDesc.getUsername());
        ds.setPassword(dsDesc.getClearPassword());
        ds.setUrl(dsDesc.getDatabaseUrl());
        ds.setInitialSize(NumberBaseOpt.castObjectToInteger((Object)dsDesc.getExtProp("initialSize"), (Integer)5).intValue());
        ds.setMaxActive(NumberBaseOpt.castObjectToInteger((Object)dsDesc.getExtProp("maxTotal"), (Integer)10).intValue());
        ds.setMaxWait((long)NumberBaseOpt.castObjectToInteger((Object)dsDesc.getExtProp("maxWaitMillis"), (Integer)10000).intValue());
        ds.setMinIdle(NumberBaseOpt.castObjectToInteger((Object)dsDesc.getExtProp("minIdle"), (Integer)5).intValue());
        ds.setValidationQuery(StringBaseOpt.castObjectToString((Object)dsDesc.getExtProp("validationQuery"), (String)"select 1"));
        ds.setTestWhileIdle(BooleanBaseOpt.castObjectToBoolean((Object)dsDesc.getExtProp("testWhileIdle"), (Boolean)true).booleanValue());
        ds.setValidationQueryTimeout(NumberBaseOpt.castObjectToInteger((Object)dsDesc.getExtProp("validationQueryTimeout"), (Integer)10000).intValue());
        ds.setKeepAlive(BooleanBaseOpt.castObjectToBoolean((Object)dsDesc.getExtProp("keepAlive"), (Boolean)true).booleanValue());
        ds.setTimeBetweenEvictionRunsMillis((long)NumberBaseOpt.castObjectToInteger((Object)dsDesc.getExtProp("timeBetweenEvictionRunsMillis"), (Integer)600000).intValue());
        ds.setMinEvictableIdleTimeMillis((long)NumberBaseOpt.castObjectToInteger((Object)dsDesc.getExtProp("timeBetweenEvictionRunsMillis"), (Integer)300000).intValue());
        ds.setRemoveAbandoned(BooleanBaseOpt.castObjectToBoolean((Object)dsDesc.getExtProp("removeAbandoned"), (Boolean)true).booleanValue());
        ds.setRemoveAbandonedTimeout(NumberBaseOpt.castObjectToInteger((Object)dsDesc.getExtProp("removeAbandonedTimeout"), (Integer)80).intValue());
        ds.setLogAbandoned(BooleanBaseOpt.castObjectToBoolean((Object)dsDesc.getExtProp("logAbandoned"), (Boolean)true).booleanValue());
        return ds;
    }

    static synchronized Connection getDbcpConnect(ISourceInfo dsDesc) throws SQLException {
        DruidDataSource ds = DRUID_DATA_SOURCE_POOLS.get(dsDesc);
        if (ds == null) {
            ds = AbstractDruidConnectPools.mapDataSource(dsDesc);
            DRUID_DATA_SOURCE_POOLS.put(dsDesc, ds);
        }
        DruidPooledConnection conn = ds.getConnection();
        conn.setAutoCommit(false);
        return conn;
    }

    static void closeConnect(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

