/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.dao.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.centit.dde.adapter.dao.CallApiLogDao;
import com.centit.dde.adapter.po.CallApiLog;
import com.centit.dde.adapter.po.CallApiLogDetail;
import com.centit.dde.adapter.po.CallApiLogDetails;
import com.centit.search.document.ESDocument;
import com.centit.search.service.ESServerConfig;
import com.centit.search.service.Impl.ESIndexer;
import com.centit.search.service.Impl.ESSearcher;
import com.centit.search.service.IndexerSearcherFactory;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.database.utils.PageDesc;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.metrics.ParsedSum;
import org.elasticsearch.search.aggregations.metrics.SumAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="callApiLogDao")
public class CallApiLogDaoImpl
implements CallApiLogDao {
    private static final Logger logger = LoggerFactory.getLogger(CallApiLogDaoImpl.class);
    private final ESIndexer callApiLogIndexer;
    private final ESSearcher callApiLogSearcher;
    private final ESIndexer callApiLogDetailIndexer;
    private final ESSearcher callApiLogDetailSearcher;
    private final ESServerConfig esServerConfig;

    @Autowired
    public CallApiLogDaoImpl(@Autowired ESServerConfig esServerConfig) {
        this.esServerConfig = esServerConfig;
        this.callApiLogIndexer = IndexerSearcherFactory.obtainIndexer((ESServerConfig)esServerConfig, CallApiLog.class);
        this.callApiLogSearcher = IndexerSearcherFactory.obtainSearcher((ESServerConfig)esServerConfig, CallApiLog.class);
        this.callApiLogDetailIndexer = IndexerSearcherFactory.obtainIndexer((ESServerConfig)esServerConfig, CallApiLogDetails.class);
        this.callApiLogDetailSearcher = IndexerSearcherFactory.obtainSearcher((ESServerConfig)esServerConfig, CallApiLogDetails.class);
    }

    public void saveLog(CallApiLog callApiLog) {
        this.callApiLogIndexer.saveNewDocument((ESDocument)callApiLog);
    }

    public void saveLogDetails(CallApiLog callApiLog) {
        CallApiLogDetails details = new CallApiLogDetails();
        details.setLogId(callApiLog.getLogId());
        details.setTaskId(callApiLog.getTaskId());
        details.setRunBeginTime(callApiLog.getRunBeginTime());
        details.setDetailLogs(callApiLog.getDetailLogs());
        this.callApiLogDetailIndexer.saveNewDocument((ESDocument)details);
    }

    public CallApiLog getLog(String logId) {
        JSONObject object = this.callApiLogSearcher.getDocumentById("logId", logId);
        if (object == null) {
            return null;
        }
        return (CallApiLog)object.toJavaObject(CallApiLog.class, new JSONReader.Feature[0]);
    }

    public List<CallApiLogDetail> listLogDetails(String logId) {
        JSONObject object = this.callApiLogDetailSearcher.getDocumentById("logId", logId);
        if (object == null) {
            return null;
        }
        return JSONArray.parseArray((String)object.getString("detailLogs"), CallApiLogDetail.class);
    }

    public CallApiLog getLogWithDetail(String logId) {
        CallApiLog callLog = this.getLog(logId);
        if (callLog == null) {
            return null;
        }
        callLog.setDetailLogs(this.listLogDetails(logId));
        return callLog;
    }

    public void deleteLogById(String logId) {
    }

    public List<Map<String, Object>> listLogsByProperties(Map<String, Object> param, PageDesc pageDesc) {
        Pair queryOut = this.callApiLogSearcher.search(param, null, pageDesc.getPageNo(), pageDesc.getPageSize());
        pageDesc.setTotalRows(Integer.valueOf(((Long)queryOut.getLeft()).intValue()));
        List objectList = (List)queryOut.getRight();
        if (objectList == null) {
            return null;
        }
        for (Map obj : objectList) {
            obj.put("runBeginTime", DatetimeOpt.smartPraseDate((String)((String)obj.get("runBeginTime"))));
            obj.put("runEndTime", DatetimeOpt.smartPraseDate((String)((String)obj.get("runEndTime"))));
        }
        return objectList;
    }

    public JSONArray statApiCallSumByHour(String taskId, Date startDate, Date endDate) {
        SearchRequest searchRequest = new SearchRequest(new String[]{"callapilog"});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"taskId", (String)taskId));
        RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)"runBeginTime").gte((Object)startDate).lte((Object)endDate);
        boolQuery.must((QueryBuilder)rangeQuery);
        sourceBuilder.query((QueryBuilder)boolQuery);
        long intervals = DatetimeOpt.calcSpanDays((Date)startDate, (Date)endDate) >= 5 ? 86400000L : 3600000L;
        DateHistogramAggregationBuilder dateHistogramAggregation = (DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"hourly").field("runBeginTime")).interval(intervals).format("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        SumAggregationBuilder errorPiecesSum = (SumAggregationBuilder)AggregationBuilders.sum((String)"errorPiecesSum").field("errorPieces");
        SumAggregationBuilder successPiecesSum = (SumAggregationBuilder)AggregationBuilders.sum((String)"successPiecesSum").field("successPieces");
        dateHistogramAggregation.subAggregation((AggregationBuilder)errorPiecesSum);
        dateHistogramAggregation.subAggregation((AggregationBuilder)successPiecesSum);
        sourceBuilder.aggregation((AggregationBuilder)dateHistogramAggregation);
        searchRequest.source(sourceBuilder);
        JSONArray result = new JSONArray();
        try (RestHighLevelClient client = this.callApiLogSearcher.fetchClient();){
            SearchResponse searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
            Histogram hourlyHistogram = (Histogram)searchResponse.getAggregations().get("hourly");
            for (Histogram.Bucket hourlyBucket : hourlyHistogram.getBuckets()) {
                String keyAsString = hourlyBucket.getKeyAsString();
                ParsedSum errorPiecesValue = (ParsedSum)hourlyBucket.getAggregations().get("errorPiecesSum");
                ParsedSum successPiecesValue = (ParsedSum)hourlyBucket.getAggregations().get("successPiecesSum");
                JSONObject sums = new JSONObject();
                sums.put((Object)"runBeginTime", (Object)DatetimeOpt.smartPraseDate((String)keyAsString));
                sums.put((Object)"errorPieces", (Object)errorPiecesValue.getValue());
                sums.put((Object)"successPieces", (Object)successPiecesValue.getValue());
                result.add((Object)sums);
            }
        }
        catch (IOException | ElasticsearchException e) {
            logger.error("Error occurred while processing task ID: {}, start date: {}, end date: {}", new Object[]{taskId, startDate, endDate, e});
        }
        return result;
    }
}

