/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.dao.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.centit.dde.adapter.dao.CallApiLogDao;
import com.centit.dde.adapter.po.CallApiLog;
import com.centit.dde.adapter.po.CallApiLogDetail;
import com.centit.dde.adapter.po.CallApiLogDetails;
import com.centit.search.document.ESDocument;
import com.centit.search.service.ESServerConfig;
import com.centit.search.service.Impl.ESIndexer;
import com.centit.search.service.Impl.ESSearcher;
import com.centit.search.service.IndexerSearcherFactory;
import com.centit.support.database.utils.PageDesc;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="callApiLogDao")
public class CallApiLogDaoImpl
implements CallApiLogDao {
    private static final Logger logger = LoggerFactory.getLogger(CallApiLogDaoImpl.class);
    private final ESIndexer callApiLogIndexer;
    private final ESSearcher callApiLogSearcher;
    private final ESIndexer callApiLogDetailIndexer;
    private final ESSearcher callApiLogDetailSearcher;
    private final ESServerConfig esServerConfig;

    @Autowired
    public CallApiLogDaoImpl(@Autowired ESServerConfig esServerConfig) {
        this.esServerConfig = esServerConfig;
        this.callApiLogIndexer = IndexerSearcherFactory.obtainIndexer((ESServerConfig)esServerConfig, CallApiLog.class);
        this.callApiLogSearcher = IndexerSearcherFactory.obtainSearcher((ESServerConfig)esServerConfig, CallApiLog.class);
        this.callApiLogDetailIndexer = IndexerSearcherFactory.obtainIndexer((ESServerConfig)esServerConfig, CallApiLogDetails.class);
        this.callApiLogDetailSearcher = IndexerSearcherFactory.obtainSearcher((ESServerConfig)esServerConfig, CallApiLogDetails.class);
    }

    public void saveLog(CallApiLog callApiLog) {
        this.callApiLogIndexer.saveNewDocument((ESDocument)callApiLog);
    }

    public void saveLogDetails(CallApiLog callApiLog) {
        CallApiLogDetails details = new CallApiLogDetails();
        details.setLogId(callApiLog.getLogId());
        details.setTaskId(callApiLog.getTaskId());
        details.setRunBeginTime(callApiLog.getRunBeginTime());
        details.setDetailLogs(callApiLog.getDetailLogs());
        this.callApiLogDetailIndexer.saveNewDocument((ESDocument)details);
    }

    public CallApiLog getLog(String logId) {
        JSONObject object = this.callApiLogSearcher.getDocumentById("logId", logId);
        if (object == null) {
            return null;
        }
        return (CallApiLog)object.toJavaObject(CallApiLog.class, new JSONReader.Feature[0]);
    }

    public List<CallApiLogDetail> listLogDetails(String logId) {
        JSONObject object = this.callApiLogDetailSearcher.getDocumentById("logId", logId);
        if (object == null) {
            return null;
        }
        return JSONArray.parseArray((String)object.getString("detailLogs"), CallApiLogDetail.class);
    }

    public CallApiLog getLogWithDetail(String logId) {
        CallApiLog callLog = this.getLog(logId);
        if (callLog == null) {
            return null;
        }
        callLog.setDetailLogs(this.listLogDetails(logId));
        return callLog;
    }

    public void deleteLogById(String logId) {
        this.callApiLogIndexer.deleteDocument(logId);
    }

    public void deleteLogDetailById(String logId) {
        this.callApiLogDetailIndexer.deleteDocument(logId);
    }

    public List<Map<String, Object>> listLogsByProperties(Map<String, Object> param, PageDesc pageDesc) {
        Pair queryOut = this.callApiLogSearcher.search(param, null, pageDesc.getPageNo(), pageDesc.getPageSize());
        pageDesc.setTotalRows(Integer.valueOf(((Long)queryOut.getLeft()).intValue()));
        return (List)queryOut.getRight();
    }

    public Map<String, Object> getLogStatisticsInfo(Map<String, Object> queryparameter) {
        return null;
    }

    public int deleteTaskLog(String packetId, Date runBeginTime, boolean isError) {
        return 0;
    }
}

