/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.dao.impl;

import com.centit.dde.adapter.dao.DataPacketDao;
import com.centit.dde.adapter.po.DataPacket;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.stereotype.Repository;

@Repository(value="this")
public class DataPacketDaoImpl
extends BaseDaoImpl<DataPacket, String>
implements DataPacketDao {
    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>(1);
        filterField.put("(splitforin)optids", "opt_id in (:optids)");
        return filterField;
    }

    public void updateDataPacketOptJson(String packetId, String dataPacketOptJson) {
        DatabaseOptUtils.batchUpdateObject((BaseDaoImpl)this, DataPacket.class, (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"dataOptDescJson", dataPacketOptJson}), (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"packetId", packetId}));
    }

    public void publishDataPacket(DataPacket dataPacket) {
        this.mergeObject((Serializable)dataPacket);
        this.saveObjectReferences((Serializable)dataPacket);
    }

    public int[] batchUpdateOptIdByApiId(final String optId, final List<String> apiIds) {
        String sql = "UPDATE q_data_packet SET OPT_ID=?, PUBLISH_DATE =?, IS_DISABLE='F' WHERE PACKET_ID = ?";
        int[] dataPacket = this.getJdbcTemplate().batchUpdate(sql, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                ps.setString(1, optId);
                ps.setTimestamp(2, DatetimeOpt.currentSqlTimeStamp());
                ps.setString(3, (String)apiIds.get(i));
            }

            public int getBatchSize() {
                return apiIds.size();
            }
        });
        return dataPacket;
    }

    public void updateDisableStatus(String packetId, String disable) {
        String sql = "UPDATE q_data_packet SET is_disable= ? WHERE PACKET_ID = ? ";
        this.getJdbcTemplate().update(sql, new Object[]{disable, packetId});
    }

    public void batchDeleteByPacketIds(final String[] packetIds) {
        String delSql = "DELETE FROM q_data_packet WHERE PACKET_ID = ? ";
        this.getJdbcTemplate().batchUpdate(delSql, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                ps.setString(1, packetIds[i]);
            }

            public int getBatchSize() {
                return packetIds.length;
            }
        });
    }

    public void updatePackedLogLevel(int logLevel, List<String> packetIds) {
        String sql = "UPDATE q_data_packet SET log_level= :logLevel WHERE PACKET_ID in (:apis) ";
        DatabaseOptUtils.doExecuteNamedSql((BaseDaoImpl)this, (String)sql, (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"logLevel", logLevel, "apis", packetIds}));
        sql = "UPDATE q_data_packet_draft SET log_level= :logLevel WHERE PACKET_ID in (:apis) ";
        DatabaseOptUtils.doExecuteNamedSql((BaseDaoImpl)this, (String)sql, (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"logLevel", logLevel, "apis", packetIds}));
    }

    public void updateApplicationLogLevel(int logLevel, String osId) {
        String sql = "UPDATE q_data_packet SET log_level= ? WHERE os_id = ?";
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{logLevel, osId});
        sql = "UPDATE q_data_packet_draft SET log_level= ? WHERE os_id = ?";
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{logLevel, osId});
    }

    public int clearTrashStand(String osId) {
        String delSql = "DELETE FROM q_data_packet WHERE IS_DISABLE = 'T' AND OS_ID=? ";
        int delCount = DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)delSql, (Object[])new Object[]{osId});
        return delCount;
    }
}

