/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.routemeta;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.dde.adapter.dao.DataPacketDao;
import com.centit.dde.routemeta.ApiRouteTree;
import com.centit.dde.routemeta.RouteMetadataService;
import com.centit.support.common.CachedMap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class RouteMetadataServiceImpl
implements RouteMetadataService {
    protected static final Logger logger = LoggerFactory.getLogger(RouteMetadataServiceImpl.class);
    private final CachedMap<String, ApiRouteTree> optTreeNodeCache = new CachedMap(this::buildMetadataTree, 900L);
    @Autowired
    private DataPacketDao dataPacketDao;

    public static List<String> parseRequestUrl(String uri) {
        String[] uriPieces = uri.split("/");
        ArrayList<String> path = new ArrayList<String>();
        try {
            int i;
            int n = uriPieces.length;
            for (i = 0; i < n && !"gateway".equals(uriPieces[i]); ++i) {
            }
            ++i;
            while (i < n) {
                String piece = URLDecoder.decode(uriPieces[i], "UTF-8");
                if (StringUtils.isNotBlank((CharSequence)piece)) {
                    path.add(piece);
                }
                ++i;
            }
        }
        catch (UnsupportedEncodingException e) {
            return path;
        }
        return path;
    }

    public static List<String> parseRouteUrl(String uri) {
        String[] uriPieces = uri.split("/");
        ArrayList<String> path = new ArrayList<String>();
        for (String piece : uriPieces) {
            if (!StringUtils.isNotBlank((CharSequence)piece)) continue;
            path.add(piece);
        }
        return path;
    }

    private ApiRouteTree buildMetadataTree(String topUnit) {
        ApiRouteTree routeTree = new ApiRouteTree();
        JSONArray apiList = this.dataPacketDao.listApiWithRoute(topUnit);
        for (Object obj : apiList) {
            if (!(obj instanceof JSONObject)) continue;
            JSONObject apiJson = (JSONObject)obj;
            String method = apiJson.getString("taskType");
            String routeUrl = apiJson.getString("routeUrl");
            String packetId = apiJson.getString("packetId");
            if ("1".equals(method)) {
                method = "GET";
            } else if ("3".equals(method)) {
                method = "POST";
            } else if ("5".equals(method)) {
                method = "PUT";
            } else {
                if (!"6".equals(method)) continue;
                method = "DELETE";
            }
            if (StringUtils.isBlank((CharSequence)routeUrl) || StringUtils.isBlank((CharSequence)packetId)) continue;
            List<String> pieces = RouteMetadataServiceImpl.parseRouteUrl(routeUrl);
            ApiRouteTree packetNode = routeTree.fetchChildNode(method);
            for (String piece : pieces) {
                packetNode = packetNode.fetchChildNode(piece);
            }
            if (StringUtils.isBlank((CharSequence)packetNode.getPacketId())) {
                packetNode.setPacketId(packetId);
                continue;
            }
            logger.error("API route url \u51b2\u7a81\uff0c url\uff1a{} packetId\uff1a{} - {}", new Object[]{routeUrl, packetId, packetNode.getPacketId()});
        }
        return routeTree;
    }

    @Override
    public void rebuildMetadataTree(String topUnit) {
        this.optTreeNodeCache.evictIdentifiedCache((Object)topUnit);
    }

    @Override
    public Pair<String, List<String>> mapUrlToPacketId(String url, String method) {
        List<String> pieces = RouteMetadataServiceImpl.parseRequestUrl(url);
        if (pieces == null || pieces.isEmpty()) {
            return null;
        }
        ApiRouteTree routeNode = (ApiRouteTree)this.optTreeNodeCache.getCachedValue((Object)pieces.get(0));
        ApiRouteTree packetNode = routeNode.getChildNode(method);
        ArrayList<String> params = new ArrayList<String>();
        for (int i = 1; i < pieces.size(); ++i) {
            if (packetNode == null) {
                return null;
            }
            ApiRouteTree nextNode = packetNode.getChildNode(pieces.get(i));
            if (nextNode == null) {
                nextNode = packetNode.getChildNode("*");
                params.add(pieces.get(i));
            }
            packetNode = nextNode;
        }
        return packetNode == null ? null : new ImmutablePair((Object)packetNode.packetId, params);
    }

    @Override
    public String getPublishPacketId(String topUnit, String url, String method) {
        List<String> pieces = RouteMetadataServiceImpl.parseRouteUrl(url);
        ApiRouteTree routeNode = (ApiRouteTree)this.optTreeNodeCache.getCachedValue((Object)topUnit);
        ApiRouteTree packetNode = routeNode.getChildNode(method);
        for (String piece : pieces) {
            if (packetNode == null) {
                return null;
            }
            ApiRouteTree nextNode = packetNode.getChildNode(piece);
            if (nextNode == null) {
                nextNode = packetNode.getChildNode("*");
            }
            packetNode = nextNode;
        }
        return packetNode == null ? null : packetNode.getPacketId();
    }
}

