/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.controller;

import com.alibaba.fastjson2.JSON;
import com.centit.dde.adapter.po.DataPacket;
import com.centit.dde.adapter.po.DataPacketDraft;
import com.centit.dde.adapter.po.DataPacketInterface;
import com.centit.dde.core.DataOptContext;
import com.centit.dde.core.DataOptResult;
import com.centit.dde.services.BizModelService;
import com.centit.dde.services.DataPacketDraftService;
import com.centit.dde.services.DataPacketService;
import com.centit.fileserver.utils.UploadDownloadUtils;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.OsInfo;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.file.FileIOOpt;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public abstract class DoApiController
extends BaseController {
    @Autowired
    protected PlatformEnvironment platformEnvironment;
    @Autowired
    protected DataPacketService dataPacketService;
    @Autowired
    protected DataPacketDraftService dataPacketDraftService;
    @Autowired
    protected BizModelService bizmodelService;
    protected Map<String, DataPacket> dataPacketCachedMap = new ConcurrentHashMap<String, DataPacket>(10000);

    private void judgePower(@PathVariable String packetId, String loginUser, String runType, HttpServletRequest request) {
        if ("D".equals(runType)) {
            if (StringUtils.isBlank((CharSequence)loginUser)) {
                throw new ObjectException(302, this.getI18nMessage("error.302.user_not_login", request, new Object[0]));
            }
            DataPacketDraft dataPacket = this.dataPacketDraftService.getDataPacket(packetId);
            List userGroups = this.platformEnvironment.listWorkGroup(dataPacket.getOsId(), loginUser, null);
            if (CollectionUtils.isEmpty((Collection)userGroups)) {
                throw new ObjectException(203, this.getI18nMessage("error.403.access_forbidden", request, new Object[0]));
            }
        }
    }

    protected void returnObject(String packetId, String runType, String taskType, List<String> urlParams, HttpServletRequest request, HttpServletResponse response) throws IOException {
        DataOptResult result;
        Map cookies;
        DataPacketDraft dataPacketInterface;
        if ("D".equals(runType)) {
            dataPacketInterface = this.dataPacketDraftService.getDataPacket(packetId);
        } else {
            DataPacket dataPacket = this.dataPacketService.getDataPacket(packetId);
            if (dataPacket == null) {
                this.dataPacketCachedMap.remove(packetId);
                dataPacketInterface = null;
            } else {
                DataPacket cachedPacket = this.dataPacketCachedMap.get(packetId);
                if (cachedPacket == null || DatetimeOpt.compareTwoDate((Date)dataPacket.getPublishDate(), (Date)cachedPacket.getPublishDate()) != 0) {
                    dataPacketInterface = dataPacket;
                    this.dataPacketCachedMap.put(packetId, dataPacket);
                } else {
                    dataPacketInterface = cachedPacket;
                }
            }
        }
        if (dataPacketInterface == null) {
            throw new ObjectException(604, this.getI18nMessage("dde.604.api_not_found", request, new Object[]{packetId}));
        }
        if ("4".equals(dataPacketInterface.getTaskType())) {
            throw new ObjectException(405, this.getI18nMessage("dde.405.method_not_support", request, new Object[]{packetId}));
        }
        if (!taskType.equals(dataPacketInterface.getTaskType()) && !"2".equals(dataPacketInterface.getTaskType())) {
            throw new ObjectException(405, this.getI18nMessage("dde.405.request_type_not_match", request, new Object[]{packetId}));
        }
        if ("N".equals(runType) && !dataPacketInterface.canRunAsNormal()) {
            throw new ObjectException(405, this.getI18nMessage("dde.405.api_is_disable", request, new Object[]{packetId}));
        }
        HashMap<String, String> params = new HashMap<String, String>(dataPacketInterface.getPacketParamsValue());
        params.putAll(DoApiController.collectRequestParameters((HttpServletRequest)request));
        DataOptContext dataOptContext = new DataOptContext(this.messageSource, WebOptUtils.getCurrentLocale((HttpServletRequest)request));
        dataOptContext.setRunType(runType);
        Object obj = params.get("debugId");
        if (obj != null) {
            dataOptContext.setDebugId(StringBaseOpt.castObjectToString(obj));
        }
        if ((obj = params.get("breakStepNo")) != null) {
            dataOptContext.setBreakStepNo(NumberBaseOpt.castObjectToInteger(obj, (Integer)-1));
        }
        if ("3".equals(taskType) || "5".equals(taskType) || "POST".equalsIgnoreCase(request.getMethod()) || "PUT".equalsIgnoreCase(request.getMethod())) {
            String bodyString;
            String contentType = request.getHeader("Content-Type");
            if (StringUtils.contains((CharSequence)contentType, (CharSequence)"application/json")) {
                bodyString = FileIOOpt.readStringFromInputStream((InputStream)request.getInputStream(), (String)String.valueOf(StandardCharsets.UTF_8));
                dataOptContext.setStackData("__request_body", JSON.parse((String)bodyString));
            } else if (StringUtils.contains((CharSequence)contentType, (CharSequence)"application/x-www-form-urlencoded")) {
                HashMap bodyMap = new HashMap(32);
                for (Map.Entry ent : request.getParameterMap().entrySet()) {
                    if (((String[])ent.getValue()).length == 1) {
                        bodyMap.put(ent.getKey(), ((String[])ent.getValue())[0]);
                        continue;
                    }
                    bodyMap.put(ent.getKey(), (String)ent.getValue());
                }
                dataOptContext.setStackData("__request_body", bodyMap);
            } else if (StringUtils.contains((CharSequence)contentType, (CharSequence)"application/octet-stream")) {
                InputStream inputStream;
                String fileName = request.getHeader("filename");
                String fileName2 = StringBaseOpt.castObjectToString(params.get("fileName"));
                if (StringUtils.isBlank((CharSequence)fileName) && StringUtils.isBlank((CharSequence)(fileName = request.getHeader("fileName"))) && StringUtils.isNotBlank((CharSequence)fileName2)) {
                    fileName = fileName2;
                }
                if (StringUtils.isNotBlank((CharSequence)fileName) && StringUtils.isBlank((CharSequence)fileName2)) {
                    params.put("fileName", fileName);
                }
                if ((inputStream = (InputStream)UploadDownloadUtils.fetchInputStreamFromMultipartResolver((HttpServletRequest)request).getRight()) != null) {
                    dataOptContext.setStackData("__request_file", (Object)CollectionsOpt.createHashMap((Object[])new Object[]{"fileName", fileName, "fileSize", inputStream.available(), "fileContent", inputStream}));
                }
            } else if (StringUtils.contains((CharSequence)contentType, (CharSequence)"text/plain")) {
                bodyString = FileIOOpt.readStringFromInputStream((InputStream)request.getInputStream(), (String)String.valueOf(StandardCharsets.UTF_8));
                dataOptContext.setStackData("__request_body", (Object)bodyString);
            } else if (StringUtils.contains((CharSequence)contentType, (CharSequence)"multipart/form-data")) {
                CommonsMultipartResolver resolver = new CommonsMultipartResolver(request.getSession().getServletContext());
                MultipartHttpServletRequest multiRequest = resolver.resolveMultipart(request);
                HashMap bodyMap = new HashMap(32);
                Map mParams = multiRequest.getParameterMap();
                if (mParams != null) {
                    for (Map.Entry entry : mParams.entrySet()) {
                        if (entry.getValue() == null) continue;
                        if (((String[])entry.getValue()).length == 1) {
                            bodyMap.put(entry.getKey(), ((String[])entry.getValue())[0]);
                            continue;
                        }
                        bodyMap.put(entry.getKey(), entry.getValue());
                    }
                }
                Map map = multiRequest.getFileMap();
                for (Map.Entry entry : map.entrySet()) {
                    String bodyString2;
                    CommonsMultipartFile cMultipartFile = (CommonsMultipartFile)entry.getValue();
                    FileItem fi = cMultipartFile.getFileItem();
                    String fieldName = fi.getFieldName();
                    String itemType = fi.getHeaders().getHeader("Content-Type");
                    if (!fi.isFormField() || itemType.contains("application/octet-stream")) {
                        InputStream inputStream;
                        String filename = fi.getHeaders().getHeader("filename");
                        if (StringUtils.isBlank((CharSequence)filename) && StringUtils.isBlank((CharSequence)(filename = StringBaseOpt.castObjectToString(params.get("filename"))))) {
                            filename = StringBaseOpt.castObjectToString(params.get("fileName"));
                        }
                        String fileName2 = StringBaseOpt.castObjectToString(params.get("fileName"));
                        if (StringUtils.isNotBlank((CharSequence)filename) && StringUtils.isBlank((CharSequence)fileName2)) {
                            params.put("fileName", filename);
                        }
                        if ((inputStream = fi.getInputStream()) == null) continue;
                        Map fileData = CollectionsOpt.createHashMap((Object[])new Object[]{"fileName", filename, "fileSize", inputStream.available(), "fileContent", inputStream});
                        dataOptContext.setStackData("__request_file", (Object)fileData);
                        bodyMap.put(fieldName, fileData);
                        continue;
                    }
                    if (itemType.contains("application/json")) {
                        bodyString2 = fi.getString();
                        bodyMap.put(fieldName, JSON.parse((String)bodyString2));
                        continue;
                    }
                    bodyString2 = fi.getString();
                    bodyMap.put(fieldName, bodyString2);
                }
                dataOptContext.setStackData("__request_body", bodyMap);
            } else {
                throw new ObjectException(613, this.getI18nMessage("dde.613.form_type_not_support", request, new Object[]{contentType}));
            }
        }
        dataOptContext.setStackData("__request_params", params);
        if (urlParams != null && !urlParams.isEmpty()) {
            dataOptContext.setStackData("__request_url_params", urlParams);
        }
        if ((cookies = WebOptUtils.fetchRequestCookies((HttpServletRequest)request)) != null) {
            dataOptContext.setStackData("__request_cookies", (Object)cookies);
        }
        Map headers = WebOptUtils.fetchRequestHeaders((HttpServletRequest)request);
        if (cookies != null) {
            dataOptContext.setStackData("__request_headers", (Object)headers);
        }
        OsInfo osInfo = this.platformEnvironment.getOsInfo(dataPacketInterface.getOsId());
        dataOptContext.setStackData("__application_info", (Object)osInfo);
        CentitUserDetails userDetails = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        if (userDetails != null) {
            dataOptContext.setStackData("__session_data", (Object)userDetails);
            dataOptContext.setTopUnit(userDetails.getTopUnitCode());
        }
        if ((result = this.bizmodelService.runBizModel((DataPacketInterface)dataPacketInterface, dataOptContext)).getResultType() == 3) {
            InputStream in = result.getReturnFileStream();
            if (in != null) {
                UploadDownloadUtils.downFileRange((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)in, (long)in.available(), (String)result.getReturnFilename(), (String)request.getParameter("downloadType"), null);
            } else {
                JsonResultUtils.writeOriginalObject((Object)ResponseData.makeErrorMessage((int)604, (String)this.getI18nMessage("dde.604.return_file_not_found", request, new Object[0])), (HttpServletResponse)response);
            }
            return;
        }
        if (result.getResultType() == 2) {
            JsonResultUtils.writeOriginalObject((Object)result.getResultObject(), (HttpServletResponse)response);
        } else {
            JsonResultUtils.writeOriginalObject((Object)result.toResponseData(), (HttpServletResponse)response);
        }
    }
}

