/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.controller;

import com.alibaba.fastjson2.JSONArray;
import com.centit.dde.adapter.po.CallApiLog;
import com.centit.dde.adapter.po.CallApiLogDetail;
import com.centit.dde.services.TaskLogManager;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"taskLog"})
@Api(value="\u4efb\u52a1\u65e5\u5fd7", tags={"\u4efb\u52a1\u65e5\u5fd7"})
public class TaskLogController
extends BaseController {
    private static final Log log = LogFactory.getLog(TaskLogController.class);
    private final TaskLogManager taskLogManager;

    @Autowired
    public TaskLogController(TaskLogManager taskLogManager) {
        this.taskLogManager = taskLogManager;
    }

    @DeleteMapping(value={"/{logId}"})
    @ApiOperation(value="\u5220\u9664\u65e5\u5fd7")
    @ApiImplicitParam(name="logId", value="\u65e5\u5fd7ID")
    @WrapUpResponseBody
    public void delTaskLog(@PathVariable String logId) {
        this.taskLogManager.deleteTaskLogById(logId);
    }

    @GetMapping
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u65e5\u5fd7")
    @WrapUpResponseBody
    public PageQueryResult<Map<String, Object>> listTaskLog(PageDesc pageDesc, HttpServletRequest request) {
        Map parameters = TaskLogController.collectRequestParameters((HttpServletRequest)request);
        List callApiLogs = this.taskLogManager.listTaskLog(parameters, pageDesc);
        return PageQueryResult.createResult((Collection)callApiLogs, (PageDesc)pageDesc);
    }

    @GetMapping(value={"/{logId}"})
    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u65e5\u5fd7")
    @ApiImplicitParam(name="logId", value="\u65e5\u5fd7ID")
    @WrapUpResponseBody
    public CallApiLog getTaskLog(@PathVariable String logId) {
        return this.taskLogManager.getLogWithDetail(logId);
    }

    @GetMapping(value={"/details/{logId}"})
    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u65e5\u5fd7")
    @ApiImplicitParam(name="logId", value="\u65e5\u5fd7ID")
    @WrapUpResponseBody
    public List<CallApiLogDetail> getTaskLogDetails(@PathVariable String logId) {
        return this.taskLogManager.listLogDetails(logId);
    }

    @GetMapping(value={"/callByHour"})
    @ApiOperation(value="\u65e5\u5fd7\u7edf\u8ba1")
    @WrapUpResponseBody
    public JSONArray statApiCallSumByHour(String taskId, String statType) {
        Date currentDate = DatetimeOpt.currentUtilDate();
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)statType, (CharSequence[])new CharSequence[]{"week"})) {
            return this.taskLogManager.statApiCallSumByHour(taskId, DatetimeOpt.addMonths((Date)currentDate, (int)-1), currentDate);
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)statType, (CharSequence[])new CharSequence[]{"month"})) {
            return this.taskLogManager.statApiCallSumByHour(taskId, DatetimeOpt.addDays((Date)currentDate, (int)-7), currentDate);
        }
        return this.taskLogManager.statApiCallSumByHour(taskId, DatetimeOpt.addDays((Date)currentDate, (int)-1), currentDate);
    }
}

