/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.controller;

import com.centit.dde.controller.DoApiController;
import com.centit.dde.routemeta.RouteMetadataService;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.framework.security.CentitSecurityMetadata;
import com.centit.support.common.ObjectException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="api\u7f51\u5173", tags={"api\u7f51\u5173 - gateway"})
@RestController
@RequestMapping(value={"gateway"})
public class ApiRouteController
extends DoApiController {
    @Autowired
    private RouteMetadataService routeMetadataService;

    private void judgePower(String packetId, HttpServletRequest request) {
        List needRoles = CentitSecurityMetadata.getApiRoleList((String)packetId);
        if (needRoles == null || needRoles.isEmpty()) {
            return;
        }
        CentitUserDetails ud = WebOptUtils.assertUserDetails((HttpServletRequest)request);
        Collection userRoles = ud.getAuthorities();
        if (userRoles != null) {
            Iterator userRolesItr = userRoles.iterator();
            Iterator needRolesItr = needRoles.iterator();
            String needRole = ((ConfigAttribute)needRolesItr.next()).getAttribute();
            String userRole = ((GrantedAuthority)userRolesItr.next()).getAuthority();
            while (true) {
                int n;
                if ((n = needRole.compareTo(userRole)) == 0) {
                    return;
                }
                if (n < 0) {
                    if (!needRolesItr.hasNext()) break;
                    needRole = ((ConfigAttribute)needRolesItr.next()).getAttribute();
                    continue;
                }
                if (!userRolesItr.hasNext()) break;
                userRole = ((GrantedAuthority)userRolesItr.next()).getAuthority();
            }
        }
        StringBuilder errorMsgBuilder = new StringBuilder("no auth: ").append(packetId).append("; need role: ");
        boolean firstRole = true;
        for (ConfigAttribute ca : needRoles) {
            if (firstRole) {
                firstRole = false;
            } else {
                errorMsgBuilder.append(", ");
            }
            errorMsgBuilder.append(ca.getAttribute().substring(2));
        }
        errorMsgBuilder.append(".");
        throw new ObjectException(403, errorMsgBuilder.toString());
    }

    @GetMapping(value={"/**"})
    @ApiOperation(value="\u6267\u884cget\u65b9\u6cd5")
    public void doGetApi(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Pair<String, List<String>> apiInfo = this.routeMetadataService.mapUrlToPacketId(request.getRequestURI(), "GET");
        if (apiInfo == null) {
            throw new ObjectException(404, "\u672a\u627e\u5230\u5bf9\u5e94\u7684api\u63a5\u53e3, GET:" + request.getRequestURI());
        }
        this.judgePower((String)apiInfo.getLeft(), request);
        this.returnObject((String)apiInfo.getLeft(), "N", "1", (List)apiInfo.getRight(), request, response);
    }

    @PostMapping(value={"/**"})
    @ApiOperation(value="\u53d1\u5e03\uff1a\u7acb\u5373\u6267\u884c\u4efb\u52a1POST")
    public void runPostTaskExchange(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Pair<String, List<String>> apiInfo = this.routeMetadataService.mapUrlToPacketId(request.getRequestURI(), "POST");
        if (apiInfo == null) {
            throw new ObjectException(404, "\u672a\u627e\u5230\u5bf9\u5e94\u7684api\u63a5\u53e3, POST:" + request.getRequestURI());
        }
        this.judgePower((String)apiInfo.getLeft(), request);
        this.returnObject((String)apiInfo.getLeft(), "N", "3", (List)apiInfo.getRight(), request, response);
    }

    @PutMapping(value={"/**"})
    @ApiOperation(value="\u53d1\u5e03\uff1a\u7acb\u5373\u6267\u884c\u4efb\u52a1PUT")
    public void runPutTaskExchange(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Pair<String, List<String>> apiInfo = this.routeMetadataService.mapUrlToPacketId(request.getRequestURI(), "PUT");
        if (apiInfo == null) {
            throw new ObjectException(404, "\u672a\u627e\u5230\u5bf9\u5e94\u7684api\u63a5\u53e3, PUT:" + request.getRequestURI());
        }
        this.judgePower((String)apiInfo.getLeft(), request);
        this.returnObject((String)apiInfo.getLeft(), "N", "5", (List)apiInfo.getRight(), request, response);
    }

    @DeleteMapping(value={"/**"})
    @ApiOperation(value="\u53d1\u5e03\uff1a\u7acb\u5373\u6267\u884c\u4efb\u52a1DELETE")
    public void runDelTaskExchange(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Pair<String, List<String>> apiInfo = this.routeMetadataService.mapUrlToPacketId(request.getRequestURI(), "DELETE");
        if (apiInfo == null) {
            throw new ObjectException(404, "\u672a\u627e\u5230\u5bf9\u5e94\u7684api\u63a5\u53e3, DELETE:" + request.getRequestURI());
        }
        this.judgePower((String)apiInfo.getLeft(), request);
        this.returnObject((String)apiInfo.getLeft(), "N", "6", (List)apiInfo.getRight(), request, response);
    }
}

