/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.controller;

import com.alibaba.fastjson2.JSONObject;
import com.centit.dde.adapter.po.CallApiLog;
import com.centit.dde.adapter.po.CallApiLogDetail;
import com.centit.dde.services.TaskLogManager;
import com.centit.dde.vo.DelTaskLogParameter;
import com.centit.dde.vo.StatisticsParameter;
import com.centit.framework.common.ResponseData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"taskLog"})
@Api(value="\u4efb\u52a1\u65e5\u5fd7", tags={"\u4efb\u52a1\u65e5\u5fd7"})
public class TaskLogController
extends BaseController {
    private static final Log log = LogFactory.getLog(TaskLogController.class);
    private final TaskLogManager taskLogManager;

    @Autowired
    public TaskLogController(TaskLogManager taskLogManager) {
        this.taskLogManager = taskLogManager;
    }

    @DeleteMapping(value={"/{logId}"})
    @ApiOperation(value="\u5220\u9664\u65e5\u5fd7")
    @ApiImplicitParam(name="logId", value="\u65e5\u5fd7ID")
    @WrapUpResponseBody
    public void delTaskLog(@PathVariable String logId) {
        this.taskLogManager.deleteTaskLogById(logId);
    }

    @GetMapping
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u65e5\u5fd7")
    @WrapUpResponseBody
    public PageQueryResult<Map<String, Object>> listTaskLog(PageDesc pageDesc, HttpServletRequest request) {
        Map parameters = TaskLogController.collectRequestParameters((HttpServletRequest)request);
        List callApiLogs = this.taskLogManager.listTaskLog(parameters, pageDesc);
        return PageQueryResult.createResult((Collection)callApiLogs, (PageDesc)pageDesc);
    }

    @GetMapping(value={"/{logId}"})
    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u65e5\u5fd7")
    @ApiImplicitParam(name="logId", value="\u65e5\u5fd7ID")
    @WrapUpResponseBody
    public CallApiLog getTaskLog(@PathVariable String logId) {
        return this.taskLogManager.getLogWithDetail(logId);
    }

    @GetMapping(value={"/details/{logId}"})
    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u65e5\u5fd7")
    @ApiImplicitParam(name="logId", value="\u65e5\u5fd7ID")
    @WrapUpResponseBody
    public List<CallApiLogDetail> getTaskLogDetails(@PathVariable String logId) {
        return this.taskLogManager.listLogDetails(logId);
    }

    @PostMapping(value={"/statistics"})
    @ApiOperation(value="\u65e5\u5fd7\u7edf\u8ba1")
    @WrapUpResponseBody
    public Map<String, Object> getLogStatisticsInfo(@RequestBody StatisticsParameter parameter) {
        return this.taskLogManager.getLogStatisticsInfo(parameter);
    }

    @PostMapping(value={"delLogInfoAndLogDetail"})
    @ApiOperation(value="\u5220\u9664\u67d0\u4e2a\u65f6\u95f4\u6bb5\u4e4b\u524d\u7684\u65e5\u5fd7")
    @WrapUpResponseBody
    public ResponseData delLogInfoAndLogDetail(@RequestBody DelTaskLogParameter delTaskLogParameter) {
        if (StringUtils.isBlank((CharSequence)delTaskLogParameter.getPacketId())) {
            return ResponseData.makeErrorMessage((String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)delTaskLogParameter.getRunBeginTime())) {
            return ResponseData.makeErrorMessage((String)"\u5220\u9664\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        int taskLogCount = this.taskLogManager.deleteTaskLog(delTaskLogParameter);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"taskLogCount", (Object)taskLogCount);
        return ResponseData.makeResponseData((Map)jsonObject);
    }
}

