/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.controller;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.centit.dde.adapter.po.DataPacket;
import com.centit.dde.adapter.po.DataPacketDraft;
import com.centit.dde.services.DataPacketDraftService;
import com.centit.dde.services.DataPacketService;
import com.centit.dde.services.DataPacketTemplateService;
import com.centit.dde.utils.LoginUserPermissionCheck;
import com.centit.dde.vo.HttpParameter;
import com.centit.dde.vo.MetaDataParameter;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.product.metadata.po.MetaColumn;
import com.centit.product.metadata.po.MetaTable;
import com.centit.product.metadata.service.MetaDataCache;
import com.centit.product.oa.team.utils.ResourceBaseController;
import com.centit.product.oa.team.utils.ResourceLock;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.security.SecurityOptUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u672a\u53d1\u5e03API\u7f51\u5173\u63a5\u53e3\u7ba1\u7406", tags={"\u672a\u53d1\u5e03API\u7f51\u5173\u63a5\u53e3\u7ba1\u7406"})
@RestController
@RequestMapping(value={"packetDraft"})
public class DataPacketDraftController
extends ResourceBaseController {
    private final DataPacketDraftService dataPacketDraftService;
    @Autowired
    private DataPacketTemplateService dataPacketTemplateService;
    @Autowired
    private DataPacketService dataPacketService;
    @Autowired
    private PlatformEnvironment platformEnvironment;
    @Autowired
    private MetaDataCache metaDataCache;

    public String getOptId() {
        return "apiDesgin";
    }

    public DataPacketDraftController(DataPacketDraftService dataPacketDraftService) {
        this.dataPacketDraftService = dataPacketDraftService;
    }

    @ApiOperation(value="\u65b0\u589eAPI\u7f51\u5173")
    @PostMapping
    @WrapUpResponseBody
    public DataPacketDraft createDataPacket(@RequestBody DataPacketDraft dataPacketDraft, HttpServletRequest request) {
        LoginUserPermissionCheck.loginUserPermissionCheck(this.platformEnvironment, dataPacketDraft.getOsId(), request);
        dataPacketDraft.setRecorder(WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        dataPacketDraft.setDataOptDescJson(dataPacketDraft.getDataOptDescJson());
        dataPacketDraft.setLogLevel(Integer.valueOf(1));
        this.dataPacketDraftService.createDataPacket(dataPacketDraft);
        return dataPacketDraft;
    }

    @ApiOperation(value="\u65b0\u589eHTTP\u8c03\u7528\u7c7b\u578bAPI")
    @PostMapping(value={"/http-type"})
    @WrapUpResponseBody
    @Transactional(rollbackFor={Exception.class})
    public DataPacketDraft createHttpTypeApi(@RequestBody HttpParameter httpParames, HttpServletRequest request) {
        DataPacketDraft dataPacketDraft = new DataPacketDraft();
        dataPacketDraft.setOsId(httpParames.getOsId());
        LoginUserPermissionCheck.loginUserPermissionCheck(this.platformEnvironment, dataPacketDraft.getOsId(), request);
        String loginUser = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)loginUser)) {
            loginUser = WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"userCode"});
        }
        dataPacketDraft.setRecorder(loginUser);
        JSONObject dataPacketTemplate = this.dataPacketTemplateService.getDataPacketTemplateByType(Integer.valueOf(8));
        JSONObject content = dataPacketTemplate.getJSONObject("content");
        String taskType = content.getString("taskType");
        JSONArray nodes = content.getJSONArray("nodes");
        for (Object node : nodes) {
            JSONObject nodeData = (JSONObject)node;
            JSONObject properties = nodeData.getJSONObject("properties");
            if (!"htts".equals(properties.getString("type"))) continue;
            if (StringUtils.isNotBlank((CharSequence)httpParames.getRequestBody())) {
                properties.put((Object)"querySQL", (Object)httpParames.getRequestBody());
            }
            if (httpParames.getParamesList() != null && httpParames.getParamesList().length > 0) {
                properties.put((Object)"parameterList", (Object)httpParames.getParamesList());
            }
            properties.put((Object)"httpUrl", (Object)httpParames.getMethodName());
            properties.put((Object)"loginService", (Object)httpParames.getLoginUrlCode());
            properties.put((Object)"requestMode", (Object)httpParames.getMethodType());
            properties.put((Object)"databaseId", (Object)httpParames.getHttpUrlCode());
        }
        JSONObject schemaProps = dataPacketTemplate.getJSONObject("schemaProps");
        dataPacketDraft.setSchemaProps(schemaProps);
        dataPacketDraft.setBufferFreshPeriod(Integer.valueOf(-1));
        dataPacketDraft.setIsValid(Boolean.valueOf(true));
        dataPacketDraft.setTaskType(taskType);
        dataPacketDraft.setOptId(httpParames.getOptId());
        dataPacketDraft.setOsId(httpParames.getOsId());
        dataPacketDraft.setLogLevel(Integer.valueOf(1));
        dataPacketDraft.setPacketName(httpParames.getPacketName());
        dataPacketDraft.setPacketDesc(httpParames.getPacketName());
        dataPacketDraft.setDataOptDescJson(content);
        this.dataPacketDraftService.createDataPacket(dataPacketDraft);
        return dataPacketDraft;
    }

    @ApiOperation(value="\u65b0\u589e\u5143\u6570\u636e\u7c7b\u578bAPI")
    @PostMapping(value={"/metadata/api"})
    @WrapUpResponseBody
    @Transactional(rollbackFor={Exception.class})
    public List<DataPacketDraft> createMetaDataApi(@RequestBody MetaDataParameter metaDataOrHttpParams, HttpServletRequest request) throws ParseException {
        Integer[] createType;
        DataPacketDraft dataPacket = new DataPacketDraft();
        dataPacket.setOsId(metaDataOrHttpParams.getOsId());
        LoginUserPermissionCheck.loginUserPermissionCheck(this.platformEnvironment, dataPacket.getOsId(), request);
        String loginUser = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)loginUser)) {
            loginUser = WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"userCode"});
        }
        ArrayList<DataPacketDraft> dataPacketDraftList = new ArrayList<DataPacketDraft>();
        for (Integer type : createType = metaDataOrHttpParams.getCreateType()) {
            DataPacketDraft dataPacketDraft = this.createDataPacket(metaDataOrHttpParams, type);
            dataPacketDraft.setRecorder(loginUser);
            this.dataPacketDraftService.createDataPacket(dataPacketDraft);
            dataPacketDraft.setPublishDate(DatetimeOpt.truncateToSecond((Date)DatetimeOpt.currentUtilDate()));
            this.dataPacketDraftService.publishDataPacket(dataPacketDraft);
            dataPacketDraftList.add(dataPacketDraft);
        }
        return dataPacketDraftList;
    }

    private DataPacketDraft createDataPacket(MetaDataParameter metaDataOrHttpParams, Integer type) {
        DataPacketDraft dataPacketDraft = new DataPacketDraft();
        dataPacketDraft.setBufferFreshPeriod(Integer.valueOf(-1));
        dataPacketDraft.setIsValid(Boolean.valueOf(true));
        dataPacketDraft.setTemplateType(type);
        dataPacketDraft.setOptId(metaDataOrHttpParams.getOptId());
        dataPacketDraft.setOsId(metaDataOrHttpParams.getOsId());
        JSONObject dataPacketTemplate = this.dataPacketTemplateService.getDataPacketTemplateByType(type);
        String tableName = metaDataOrHttpParams.getTableName();
        String packetTemplateName = dataPacketTemplate.getString("packetTemplateName");
        String replace = packetTemplateName.replace("{name}", tableName);
        dataPacketDraft.setTaskType(dataPacketTemplate.getString("taskType"));
        dataPacketDraft.setPacketName(replace);
        dataPacketDraft.setPacketDesc(replace);
        String dataBaseCode = metaDataOrHttpParams.getDatabaseCode();
        String tableId = metaDataOrHttpParams.getTableId();
        JSONObject content = dataPacketTemplate.getJSONObject("content");
        JSONArray nodes = content.getJSONArray("nodes");
        for (Object node : nodes) {
            JSONObject nodeData = (JSONObject)node;
            JSONObject properties = nodeData.getJSONObject("properties");
            String metadataType = properties.getString("type");
            if (StringUtils.startsWith((CharSequence)metadataType, (CharSequence)"metadata")) {
                properties.put((Object)"tableId", (Object)tableId);
                properties.put((Object)"templateType", (Object)(type == 6 || type == 7 ? 1 : type));
                properties.put((Object)"databaseName", (Object)dataBaseCode);
                continue;
            }
            if (!StringUtils.equals((CharSequence)metadataType, (CharSequence)"generateExcel")) continue;
            MetaTable metaTable = this.metaDataCache.getTableInfo(tableId);
            properties.put((Object)"fileName", (Object)("\u5bfc\u51fa" + metaTable.getTableLabelName() + ".xlsx"));
            JSONArray configArray = new JSONArray();
            for (MetaColumn column : metaTable.getColumns()) {
                JSONObject col = new JSONObject();
                col.put((Object)"columnName", (Object)column.getFieldLabelName());
                if (StringUtils.isBlank((CharSequence)column.getReferenceType()) || "0".equals(column.getReferenceType())) {
                    col.put((Object)"expression", (Object)column.getPropertyName());
                } else {
                    col.put((Object)"expression", (Object)(column.getPropertyName() + "Desc"));
                }
                configArray.add((Object)col);
            }
            properties.put((Object)"config", (Object)configArray);
        }
        JSONObject schemaProps = dataPacketTemplate.getJSONObject("schemaProps");
        dataPacketDraft.setSchemaProps(schemaProps);
        dataPacketDraft.setMetadataTableId(tableId);
        dataPacketDraft.setLogLevel(Integer.valueOf(1));
        dataPacketDraft.setNeedRollback("T");
        dataPacketDraft.setDataOptDescJson(content);
        return dataPacketDraft;
    }

    @ApiOperation(value="\u7f16\u8f91API\u7f51\u5173")
    @ApiImplicitParam(name="packetId", value="apiID\u53f7", required=true, paramType="path", dataType="String")
    @PutMapping(value={"/{packetId}"})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0api", tag="{arg0}", newValue="\u65e0")
    @WrapUpResponseBody
    public void updateDataPacket(@PathVariable String packetId, @RequestBody String packetJsonStr, HttpServletRequest request) throws ParseException {
        DataPacketDraft dataPacketDraft = (DataPacketDraft)JSONObject.parseObject((String)SecurityOptUtils.decodeSecurityString((String)packetJsonStr), DataPacketDraft.class);
        if (dataPacketDraft == null) {
            throw new ObjectException(412, "\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        LoginUserPermissionCheck.loginUserPermissionCheck(this.platformEnvironment, dataPacketDraft.getOsId(), request);
        dataPacketDraft.setPacketId(packetId);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateStr = dateFormat.format(new Date());
        dataPacketDraft.setUpdateDate(dateFormat.parse(dateStr));
        dataPacketDraft.setDataOptDescJson(dataPacketDraft.getDataOptDescJson());
        this.dataPacketDraftService.updateDataPacket(dataPacketDraft);
    }

    @ApiOperation(value="API\u7f51\u5173\u53d1\u5e03")
    @PutMapping(value={"publish/{packetId}"})
    @WrapUpResponseBody
    @Transactional(rollbackFor={Exception.class})
    public void publishDataPacket(@PathVariable String packetId, HttpServletRequest request) throws ParseException {
        DataPacketDraft dataPacketDraft = this.dataPacketDraftService.getDataPacket(packetId);
        if (dataPacketDraft == null) {
            throw new ObjectException(412, "\u53d1\u5e03\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        LoginUserPermissionCheck.loginUserPermissionCheck(this.platformEnvironment, dataPacketDraft.getOsId(), request);
        dataPacketDraft.setPublishDate(DatetimeOpt.truncateToSecond((Date)DatetimeOpt.currentUtilDate()));
        this.dataPacketDraftService.publishDataPacket(dataPacketDraft);
    }

    @ApiOperation(value="\u7f16\u8f91API\u7f51\u5173\u6570\u636e\u5904\u7406\u63cf\u8ff0\u4fe1\u606f")
    @PutMapping(value={"/opt/{packetId}"})
    @WrapUpResponseBody
    public void updateDataPacketOpt(@PathVariable String packetId, @RequestBody String dataOptDescJson, HttpServletRequest request) {
        ResourceLock.lockResource((String)packetId, (String)WebOptUtils.getCurrentUserCode((HttpServletRequest)request), (HttpServletRequest)request);
        DataPacketDraft dataPacketDraft = this.dataPacketDraftService.getDataPacket(packetId);
        if (dataPacketDraft == null) {
            throw new ObjectException(412, "\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        LoginUserPermissionCheck.loginUserPermissionCheck(this.platformEnvironment, dataPacketDraft.getOsId(), request);
        this.dataPacketDraftService.updateDataPacketOptJson(packetId, dataOptDescJson);
    }

    @ApiOperation(value="\u7269\u7406\u5220\u9664API\u7f51\u5173")
    @DeleteMapping(value={"/{packetId}"})
    @WrapUpResponseBody
    @Transactional(rollbackFor={Exception.class})
    public void deleteDataPacket(@PathVariable String packetId, HttpServletRequest request) {
        DataPacketDraft dataPacketDraft = this.dataPacketDraftService.getDataPacket(packetId);
        if (dataPacketDraft == null) {
            throw new ObjectException(412, "\u5220\u9664\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        LoginUserPermissionCheck.loginUserPermissionCheck(this.platformEnvironment, dataPacketDraft.getOsId(), request);
        this.platformEnvironment.deleteOptMethod(dataPacketDraft.getOptCode());
        this.dataPacketService.deleteDataPacket(packetId);
        this.dataPacketDraftService.deleteDataPacket(packetId);
    }

    @ApiOperation(value="\u4fee\u6539API\u53ef\u7528\u72b6\u6001(T:\u7981\u7528\uff0cF:\u542f\u7528)")
    @PutMapping(value={"/{packetId}/{disableType}"})
    @WrapUpResponseBody
    @Transactional(rollbackFor={Exception.class})
    public void updateDisableStatus(@PathVariable String packetId, @PathVariable String disableType, HttpServletRequest request) {
        DataPacketDraft dataPacketDraft = this.dataPacketDraftService.getDataPacket(packetId);
        if (dataPacketDraft == null) {
            throw new ObjectException(412, "\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        LoginUserPermissionCheck.loginUserPermissionCheck(this.platformEnvironment, dataPacketDraft.getOsId(), request);
        if ("F".equals(disableType) || "T".equals(disableType)) {
            DataPacket dataPacket = this.dataPacketService.getDataPacket(packetId);
            if (dataPacket != null) {
                this.dataPacketService.updateDisableStatus(packetId, disableType);
            }
        } else {
            throw new ObjectException(412, "\u975e\u6cd5\u4f20\u53c2\uff0c\u53c2\u6570\u5fc5\u987b\u4e3aT\u6216F,\u4f20\u5165\u7684\u53c2\u6570\u4e3a\uff1a" + disableType);
        }
        this.dataPacketDraftService.updateDisableStatus(packetId, disableType);
        if (dataPacketDraft.getOptCode() != null) {
            this.platformEnvironment.deleteOptMethod(dataPacketDraft.getOptCode());
        }
    }

    @ApiOperation(value="\u67e5\u8be2API\u7f51\u5173")
    @GetMapping
    @WrapUpResponseBody
    public PageQueryResult<Object> listDataPacket(HttpServletRequest request, PageDesc pageDesc) {
        JSONArray returnList = this.dataPacketDraftService.listDataPacketForList(BaseController.collectRequestParameters((HttpServletRequest)request), pageDesc);
        if (returnList != null) {
            for (Object obj : returnList) {
                if (!(obj instanceof JSONObject)) continue;
                JSONObject jsonObject = (JSONObject)obj;
                String optId = jsonObject.getString("optId");
                String optName = CodeRepositoryUtil.getValue((String)"optId", (String)optId);
                jsonObject.put((Object)"optName", (Object)optName);
            }
        }
        return PageQueryResult.createResult((Collection)returnList, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2aAPI\u7f51\u5173")
    @GetMapping(value={"/{packetId}"})
    @WrapUpResponseBody
    public DataPacketDraft getDataPacket(@PathVariable String packetId) {
        DataPacketDraft dataPacketDraft = this.dataPacketDraftService.getDataPacket(packetId);
        if (dataPacketDraft != null && dataPacketDraft.getIsDisable().booleanValue()) {
            return null;
        }
        return dataPacketDraft;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u548c\u6e05\u7a7a\u56de\u6536\u7ad9")
    @PostMapping(value={"/batchDeleteByPacketIds"})
    @ApiImplicitParam(name="jsonObject", value="\u6279\u91cf\u5220\u9664-\u53c2\u6570\uff1a{packetIds:[\"packetId\"],osId:\"osId\"};\u6e05\u7a7a\u56de\u6536\u7ad9-\u53c2\u6570\uff1a{osId:\"osId\"}")
    @WrapUpResponseBody
    public void batchDeleteByPacketIds(@RequestBody JSONObject jsonObject, HttpServletRequest request) {
        JSONArray packetIds = jsonObject.getJSONArray("packetIds");
        String osId = jsonObject.getString("osId");
        LoginUserPermissionCheck.loginUserPermissionCheck(this.platformEnvironment, osId, request);
        if (packetIds != null && packetIds.size() > 0) {
            String[] ids = (String[])packetIds.toArray((Object[])new String[packetIds.size()]);
            this.dataPacketDraftService.batchDeleteByPacketIds(ids);
            this.dataPacketService.batchDeleteByPacketIds(ids);
        } else if (StringUtils.isNotBlank((CharSequence)osId)) {
            this.dataPacketDraftService.clearTrashStand(osId);
            this.dataPacketService.clearTrashStand(osId);
        }
    }

    @ApiOperation(value="API\u590d\u5236\u63a5\u53e3")
    @PostMapping(value={"/ApiCopy"})
    @ApiImplicitParam(name="jsonObject", value="API\u590d\u5236\u63a5\u53e3-\u53c2\u6570\uff1a{\"packetId\":\"\",\"packetName\":\"\",\"optId\":\"\"}")
    @WrapUpResponseBody
    public ResponseData ApiCopy(@RequestBody JSONObject jsonObject, HttpServletRequest request) {
        String copyPacketId = jsonObject.getString("packetId");
        String packetName = jsonObject.getString("packetName");
        String optId = jsonObject.getString("optId");
        if (StringUtils.isBlank((CharSequence)copyPacketId) || StringUtils.isBlank((CharSequence)packetName) || StringUtils.isBlank((CharSequence)optId)) {
            return ResponseData.makeErrorMessage((String)"\u7f3a\u5c11\u53c2\u6570\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01");
        }
        DataPacketDraft dataPacket = this.dataPacketDraftService.getDataPacket(copyPacketId);
        if (dataPacket == null) {
            return ResponseData.makeErrorMessage((String)"\u590d\u5236\u7684API\u63a5\u53e3\u4e0d\u5b58\u5728\uff01");
        }
        LoginUserPermissionCheck.loginUserPermissionCheck(this.platformEnvironment, dataPacket.getOsId(), request);
        String packetId = UuidOpt.getUuidAsString32();
        dataPacket.setPacketId(packetId);
        dataPacket.setPacketName(packetName);
        dataPacket.setOptId(optId);
        dataPacket.setPublishDate(null);
        JSONObject schemaJson = dataPacket.getSchemaProps();
        if (schemaJson != null) {
            String schemaString = JSONObject.toJSONString((Object)schemaJson, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
            schemaString = StringUtils.replace((String)schemaString, (String)copyPacketId, (String)packetId);
            schemaJson = JSONObject.parseObject((String)schemaString);
            dataPacket.setSchemaProps(schemaJson);
        }
        this.dataPacketDraftService.createDataPacket(dataPacket);
        return ResponseData.successResponse;
    }
}

