/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.controller;

import com.centit.dde.po.DataPacket;
import com.centit.dde.service.ExchangeService;
import com.centit.dde.services.DataPacketService;
import com.centit.dde.services.GenerateFieldsService;
import com.centit.fileserver.common.FileStore;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.ip.service.IntegrationEnvironment;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u6570\u636e\u5305", tags={"\u6570\u636e\u5305"})
@RestController
@RequestMapping(value={"packet"})
public class DataPacketController
extends BaseController {
    private FileStore fileStore;
    private final DataPacketService dataPacketService;
    private final ExchangeService exchangeService;
    private final GenerateFieldsService generateFieldsService;
    private final IntegrationEnvironment integrationEnvironment;

    @Autowired(required=false)
    public void setFileStore(FileStore fileStore) {
        this.fileStore = fileStore;
    }

    public DataPacketController(DataPacketService dataPacketService, GenerateFieldsService generateFieldsService, IntegrationEnvironment integrationEnvironment, ExchangeService exchangeService) {
        this.dataPacketService = dataPacketService;
        this.generateFieldsService = generateFieldsService;
        this.integrationEnvironment = integrationEnvironment;
        this.exchangeService = exchangeService;
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e\u5305")
    @PostMapping
    @WrapUpResponseBody
    public void createDataPacket(@RequestBody DataPacket dataPacket, HttpServletRequest request) {
        dataPacket.setRecorder(WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        dataPacket.setDataOptDescJson(dataPacket.getDataOptDescJson());
        this.dataPacketService.createDataPacket(dataPacket);
    }

    @ApiOperation(value="\u7f16\u8f91\u6570\u636e\u5305")
    @PutMapping(value={"/{packetId}"})
    @WrapUpResponseBody
    public void updateDataPacket(@PathVariable String packetId, @RequestBody DataPacket dataPacket) {
        dataPacket.setPacketId(packetId);
        dataPacket.setDataOptDescJson(dataPacket.getDataOptDescJson());
        this.dataPacketService.updateDataPacket(dataPacket);
    }

    @ApiOperation(value="\u7f16\u8f91\u6570\u636e\u5305\u6570\u636e\u5904\u7406\u63cf\u8ff0\u4fe1\u606f")
    @PutMapping(value={"/opt/{packetId}"})
    @WrapUpResponseBody
    public void updateDataPacketOpt(@PathVariable String packetId, @RequestBody String dataOptDescJson) {
        this.dataPacketService.updateDataPacketOptJson(packetId, dataOptDescJson);
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e\u5305")
    @DeleteMapping(value={"/{packetId}"})
    @WrapUpResponseBody
    public void deleteDataPacket(@PathVariable String packetId) {
        this.dataPacketService.deleteDataPacket(packetId);
    }

    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u5305")
    @GetMapping
    @WrapUpResponseBody
    public PageQueryResult<DataPacket> listDataPacket(HttpServletRequest request, PageDesc pageDesc) {
        List list = this.dataPacketService.listDataPacket(BaseController.collectRequestParameters((HttpServletRequest)request), pageDesc);
        return PageQueryResult.createResult((Collection)list, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u6570\u636e\u5305")
    @GetMapping(value={"/{packetId}"})
    @WrapUpResponseBody
    public DataPacket getDataPacket(@PathVariable String packetId) {
        return this.dataPacketService.getDataPacket(packetId);
    }

    @GetMapping(value={"/exist/{applicationId}/{interfaceName}"})
    @ApiOperation(value="\u63a5\u53e3\u540d\u79f0\u662f\u5426\u5df2\u5b58\u5728")
    @WrapUpResponseBody
    public Boolean isExist(@PathVariable String applicationId, @PathVariable String interfaceName) {
        HashMap<String, String> params = new HashMap<String, String>(10);
        params.put("interfaceName", interfaceName);
        params.put("applicationId", applicationId);
        List list = this.dataPacketService.listDataPacket(params, new PageDesc());
        return list.size() > 0;
    }
}

