/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.ftp;

import com.centit.dde.core.BizOperation;
import com.centit.product.adapter.po.SourceInfo;
import com.centit.product.metadata.dao.SourceInfoDao;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public abstract class FtpOperation
implements BizOperation {
    public SourceInfoDao sourceInfoDao;

    public FtpOperation(SourceInfoDao sourceInfoDao) {
        this.sourceInfoDao = sourceInfoDao;
    }

    public FTPClient connectFtp(String sourceId) {
        SourceInfo ftpService = this.sourceInfoDao.getDatabaseInfoById(sourceId);
        if (ftpService == null) {
            return null;
        }
        String ftpUrl = ftpService.getDatabaseUrl();
        int ftpPort = NumberBaseOpt.castObjectToInteger((Object)ftpService.getExtProp("ftpPort"), (Integer)21);
        String proxyHost = StringBaseOpt.castObjectToString((Object)ftpService.getExtProp("proxyHost"));
        boolean hasProxy = StringUtils.isNotBlank((CharSequence)proxyHost);
        Proxy proxy = null;
        try {
            if (hasProxy) {
                String proxyType = StringBaseOpt.castObjectToString((Object)ftpService.getExtProp("proxyType"));
                Proxy.Type type = "direct".equalsIgnoreCase(proxyType) ? Proxy.Type.DIRECT : ("socks".equalsIgnoreCase(proxyType) ? Proxy.Type.SOCKS : Proxy.Type.HTTP);
                int proxyPort = NumberBaseOpt.castObjectToInteger((Object)ftpService.getExtProp("proxyPort"), (Integer)8080);
                proxy = new Proxy(type, new InetSocketAddress(InetAddress.getByName(proxyHost), proxyPort));
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
        try {
            FTPClient ftp = new FTPClient();
            if (hasProxy) {
                ftp.setProxy(proxy);
            }
            ftp.connect(ftpUrl, ftpPort);
            ftp.login(ftpService.getUsername(), ftpService.getClearPassword());
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftp.disconnect();
                return null;
            }
            return ftp;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void disConnectFtp(FTPClient ftp) {
        try {
            ftp.logout();
            ftp.disconnect();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

