/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde;

import com.alibaba.fastjson2.JSONObject;
import com.centit.dde.bizopt.BuiltInOperation;
import com.centit.dde.core.BizModel;
import com.centit.dde.core.BizOperation;
import com.centit.dde.core.DataOptContext;
import com.centit.dde.core.DataSet;
import com.centit.dde.utils.BizModelJSONTransform;
import com.centit.dde.utils.DataRowVariableTranslate;
import com.centit.dde.utils.DataSetOptUtil;
import com.centit.framework.common.ResponseData;
import com.centit.product.adapter.api.ISourceInfo;
import com.centit.product.adapter.po.SourceInfo;
import com.centit.product.metadata.dao.SourceInfoDao;
import com.centit.product.metadata.transaction.AbstractSourceConnectThreadHolder;
import com.centit.search.document.ESDocument;
import com.centit.search.document.FileDocument;
import com.centit.search.document.ObjectDocument;
import com.centit.search.service.ESServerConfig;
import com.centit.search.service.Impl.ESIndexer;
import com.centit.search.service.IndexerSearcherFactory;
import com.centit.search.utils.TikaTextExtractor;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.compiler.VariableFormula;
import com.centit.support.compiler.VariableTranslate;
import com.centit.support.json.JSONTransformDataSupport;
import com.centit.support.json.JSONTransformer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.xcontent.XContentType;

public class EsWriteBizOperation
implements BizOperation {
    private final ESServerConfig esServerConfig;
    private SourceInfoDao sourceInfoDao;

    public EsWriteBizOperation(ESServerConfig esServerConfig, SourceInfoDao sourceInfoDao) {
        this.esServerConfig = esServerConfig;
        this.sourceInfoDao = sourceInfoDao;
    }

    public ResponseData runOpt(BizModel bizModel, JSONObject bizOptJson, DataOptContext dataOptContext) throws Exception {
        String operationType = bizOptJson.getString("operationType");
        if (StringUtils.isBlank((CharSequence)operationType)) {
            return ResponseData.makeErrorMessage((String)"\u8bf7\u9009\u62e9\u64cd\u4f5c\u7c7b\u578b\uff01");
        }
        String indexType = bizOptJson.getString("indexType");
        if ("custom".equals(indexType)) {
            return this.customDocOperation(bizModel, bizOptJson, operationType);
        }
        boolean indexFile = "indexFile".equals(bizOptJson.get("indexType"));
        ESIndexer esIndexer = indexFile ? IndexerSearcherFactory.obtainIndexer((ESServerConfig)this.esServerConfig, FileDocument.class) : IndexerSearcherFactory.obtainIndexer((ESServerConfig)this.esServerConfig, ObjectDocument.class);
        return indexFile ? this.fileDocumentOperation(bizModel, bizOptJson, dataOptContext, esIndexer, operationType) : this.objectDocumentOperation(bizModel, bizOptJson, dataOptContext, esIndexer, operationType);
    }

    private ResponseData customDocOperation(BizModel bizModel, JSONObject bizOptJson, String operationType) throws Exception {
        String databaseCode = BuiltInOperation.getJsonFieldString((JSONObject)bizOptJson, (String)"databaseName", null);
        SourceInfo esInfo = this.sourceInfoDao.getDatabaseInfoById(databaseCode);
        String indexName = BuiltInOperation.getJsonFieldString((JSONObject)bizOptJson, (String)"indexName", null);
        if (StringUtils.isBlank((CharSequence)indexName)) {
            return ResponseData.makeErrorMessage((String)"\u8bf7\u6307\u5b9a\u7d22\u5f15\u540d\u79f0\uff01");
        }
        DataSet dataSet = bizModel.getDataSet(bizOptJson.getString("source"));
        if (dataSet == null) {
            return ResponseData.makeErrorMessage((String)"\u6587\u6863\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String primaryKeyName = bizOptJson.getString("primaryKey");
        if (StringUtils.isBlank((CharSequence)primaryKeyName)) {
            return ResponseData.makeErrorMessage((String)"\u8bf7\u6307\u5b9a\u6587\u6863\u4e3b\u952e\u5b57\u6bb5\u540d\u79f0\uff01");
        }
        RestHighLevelClient esClient = AbstractSourceConnectThreadHolder.fetchESClient((ISourceInfo)esInfo);
        return this.batchSaveDocuments(esClient, dataSet.getDataAsList(), indexName, primaryKeyName, operationType);
    }

    private ResponseData fileDocumentOperation(BizModel bizModel, JSONObject bizOptJson, DataOptContext dataOptContext, ESIndexer esIndexer, String operationType) throws Exception {
        Object result;
        BizModelJSONTransform transform = new BizModelJSONTransform(bizModel);
        String documentId = StringBaseOpt.castObjectToString((Object)transform.attainExpressionValue(bizOptJson.getString("documentId")));
        if (StringUtils.isBlank((CharSequence)documentId)) {
            return ResponseData.makeErrorMessage((String)"\u6587\u6863\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!"delete".equals(operationType)) {
            DataSet dataSet = bizModel.getDataSet(bizOptJson.getString("source"));
            if (dataSet == null) {
                return ResponseData.makeErrorMessage((String)"\u6587\u6863\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            Object optTag = transform.attainExpressionValue(bizOptJson.getString("optTag"));
            if (optTag == null) {
                return ResponseData.makeErrorMessage((String)"\u4e1a\u52a1\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        switch (operationType) {
            case "add": {
                result = esIndexer.saveNewDocument((ESDocument)this.fileDocumentBuild(bizModel, bizOptJson, dataOptContext, transform));
                break;
            }
            case "delete": {
                result = esIndexer.deleteDocument(documentId);
                break;
            }
            case "update": {
                result = esIndexer.updateDocument((ESDocument)this.fileDocumentBuild(bizModel, bizOptJson, dataOptContext, transform));
                break;
            }
            default: {
                result = esIndexer.mergeDocument((ESDocument)this.fileDocumentBuild(bizModel, bizOptJson, dataOptContext, transform));
            }
        }
        return ResponseData.makeResponseData((Object)result);
    }

    private FileDocument fileDocumentBuild(BizModel bizModel, JSONObject bizOptJson, DataOptContext dataOptContext, BizModelJSONTransform modelTrasform) throws Exception {
        DataSet dataSet = bizModel.getDataSet(bizOptJson.getString("source"));
        FileDocument fileInfo = new FileDocument();
        fileInfo.setOptId(dataOptContext.getOptId());
        fileInfo.setOsId(dataOptContext.getOsId());
        fileInfo.setOptMethod("index");
        fileInfo.setUserCode(dataOptContext.getCurrentUserCode());
        fileInfo.setUnitCode(dataOptContext.getCurrentUnitCode());
        fileInfo.setContent(TikaTextExtractor.extractInputStreamText((InputStream)DataSetOptUtil.getInputStreamFormFile((Map)dataSet.getFirstRow())));
        fileInfo.setFileId(StringBaseOpt.castObjectToString((Object)modelTrasform.attainExpressionValue(bizOptJson.getString("documentId"))));
        fileInfo.setFileName(StringBaseOpt.castObjectToString((Object)modelTrasform.attainExpressionValue(bizOptJson.getString("fileName"))));
        fileInfo.setFileSummary(StringBaseOpt.castObjectToString((Object)modelTrasform.attainExpressionValue(bizOptJson.getString("fileSummary"))));
        fileInfo.setFileMD5(StringBaseOpt.castObjectToString((Object)modelTrasform.attainExpressionValue(bizOptJson.getString("fileMD5"))));
        fileInfo.setOptTag(StringBaseOpt.castObjectToString((Object)modelTrasform.attainExpressionValue(bizOptJson.getString("optTag"))));
        fileInfo.setCreateTime(new Date());
        Object keywords = modelTrasform.attainExpressionValue(bizOptJson.getString("keywords"));
        if (keywords != null) {
            fileInfo.setKeywords(StringBaseOpt.castObjectToString((Object)keywords).split(" "));
        }
        return fileInfo;
    }

    private ResponseData objectDocumentOperation(BizModel bizModel, JSONObject bizOptJson, DataOptContext dataOptContext, ESIndexer esIndexer, String operationType) {
        DataSet dataSet = bizModel.getDataSet(bizOptJson.getString("source"));
        if (dataSet == null) {
            return ResponseData.makeErrorMessage((String)"\u6587\u6863\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String optTag = bizOptJson.getString("optTag");
        if (StringUtils.isBlank((CharSequence)optTag)) {
            return ResponseData.makeErrorMessage((String)"\u4e1a\u52a1\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if ("delete".equals(operationType)) {
            Object documentId = JSONTransformer.transformer((Object)BuiltInOperation.getJsonFieldString((JSONObject)bizOptJson, (String)"documentId", null), (JSONTransformDataSupport)new BizModelJSONTransform(bizModel));
            if (documentId == null) {
                return ResponseData.makeErrorMessage((String)"\u6587\u6863\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            boolean b = esIndexer.deleteDocument(StringBaseOpt.castObjectToString((Object)documentId));
            return ResponseData.makeResponseData((Object)b);
        }
        VariableFormula formula = new VariableFormula();
        List dataAsList = dataSet.getDataAsList();
        int rowInd = 0;
        int rowCount = dataAsList.size();
        ArrayList<Object> addResult = new ArrayList<Object>();
        block8: for (Map documentInfo : dataAsList) {
            formula.setTrans((VariableTranslate)new DataRowVariableTranslate(bizModel, (Object)documentInfo, rowInd++, rowCount));
            switch (operationType) {
                case "add": {
                    addResult.add(esIndexer.saveNewDocument((ESDocument)this.objectDocumentBuild(formula, documentInfo, bizOptJson, dataOptContext)));
                    continue block8;
                }
                case "update": {
                    addResult.add(esIndexer.updateDocument((ESDocument)this.objectDocumentBuild(formula, documentInfo, bizOptJson, dataOptContext)));
                    continue block8;
                }
            }
            addResult.add(esIndexer.mergeDocument((ESDocument)this.objectDocumentBuild(formula, documentInfo, bizOptJson, dataOptContext)));
        }
        return ResponseData.makeResponseData(addResult);
    }

    private ObjectDocument objectDocumentBuild(VariableFormula formula, Map<String, Object> documentInfo, JSONObject bizOptJson, DataOptContext dataOptContext) {
        ObjectDocument objInfo = new ObjectDocument();
        objInfo.setOptId(dataOptContext.getOptId());
        objInfo.setOsId(dataOptContext.getOsId());
        objInfo.setOptMethod("index");
        objInfo.setUserCode(dataOptContext.getCurrentUserCode());
        objInfo.setUnitCode(dataOptContext.getCurrentUnitCode());
        objInfo.setOptTag(StringBaseOpt.castObjectToString((Object)formula.calcFormula(bizOptJson.getString("optTag"))));
        objInfo.contentObject(documentInfo);
        Object title = formula.calcFormula(bizOptJson.getString("title"));
        objInfo.setTitle(StringBaseOpt.castObjectToString((Object)title));
        objInfo.setCreateTime(new Date());
        return objInfo;
    }

    private ResponseData batchSaveDocuments(RestHighLevelClient restHighLevelClient, List<Map<String, Object>> jsonDatas, String indexName, String primaryKeyName, String operationType) throws IOException {
        BulkRequest requestBulk = new BulkRequest(indexName);
        block8: for (Map<String, Object> jsonData : jsonDatas) {
            String documentId = StringBaseOpt.castObjectToString((Object)jsonData.get(primaryKeyName));
            if (StringUtils.isBlank((CharSequence)documentId)) {
                return ResponseData.makeErrorMessage((String)"\u6307\u5b9a\u7684\u6587\u6863\u4e3b\u952e\u5b57\u6bb5\u4e0d\u5b58\u5728\uff01");
            }
            switch (operationType) {
                case "add": {
                    IndexRequest addRequest = new IndexRequest().source(jsonData, XContentType.JSON);
                    addRequest.id(documentId);
                    requestBulk.add(addRequest);
                    continue block8;
                }
                case "update": {
                    UpdateRequest updateRequest = new UpdateRequest(indexName, documentId);
                    updateRequest.doc(jsonData, XContentType.JSON);
                    requestBulk.add(updateRequest);
                    continue block8;
                }
            }
            if (EsWriteBizOperation.documentIdExist(restHighLevelClient, indexName, documentId)) {
                UpdateRequest mergeUpdateRequest = new UpdateRequest(indexName, documentId);
                mergeUpdateRequest.doc(jsonData, XContentType.JSON);
                requestBulk.add(mergeUpdateRequest);
                continue;
            }
            IndexRequest mergeIndexReq = new IndexRequest().source(jsonData, XContentType.JSON);
            mergeIndexReq.id(documentId);
            requestBulk.add(mergeIndexReq);
        }
        int updateCount = 0;
        int addCount = 0;
        int faildCount = 0;
        BulkResponse bulkResponse = restHighLevelClient.bulk(requestBulk, RequestOptions.DEFAULT);
        JSONObject result = new JSONObject();
        JSONObject faildData = new JSONObject();
        for (BulkItemResponse bulkItemResponse : bulkResponse) {
            DocWriteResponse itemResponse = bulkItemResponse.getResponse();
            if (itemResponse instanceof IndexResponse) {
                ++addCount;
            }
            if (itemResponse instanceof UpdateResponse) {
                ++updateCount;
            }
            if (!bulkItemResponse.isFailed()) continue;
            ++faildCount;
            faildData.put((Object)bulkItemResponse.getId(), (Object)bulkItemResponse.getFailureMessage());
        }
        result.put((Object)"addCount", (Object)addCount);
        result.put((Object)"updateCount", (Object)updateCount);
        result.put((Object)"faildCount", (Object)faildCount);
        if (faildCount > 0) {
            result.put((Object)"errorData", (Object)faildData);
        }
        return ResponseData.makeResponseData((Map)result);
    }

    public static boolean documentIdExist(RestHighLevelClient restHighLevelClient, String indexName, String documentId) throws IOException {
        GetRequest request = new GetRequest(indexName).id(documentId);
        return restHighLevelClient.exists(request, RequestOptions.DEFAULT);
    }
}

