/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.dde.bizopt.BuiltInOperation;
import com.centit.dde.core.BizModel;
import com.centit.dde.core.BizOperation;
import com.centit.dde.core.DataOptContext;
import com.centit.dde.core.DataSet;
import com.centit.dde.utils.BizModelJSONTransform;
import com.centit.framework.common.ResponseData;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.product.adapter.api.ISourceInfo;
import com.centit.product.adapter.po.SourceInfo;
import com.centit.product.metadata.dao.SourceInfoDao;
import com.centit.product.metadata.transaction.AbstractSourceConnectThreadHolder;
import com.centit.search.document.FileDocument;
import com.centit.search.document.ObjectDocument;
import com.centit.search.service.ESServerConfig;
import com.centit.search.service.Impl.ESSearcher;
import com.centit.search.service.IndexerSearcherFactory;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.json.JSONTransformDataSupport;
import com.centit.support.json.JSONTransformer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

public class EsQueryBizOperation
implements BizOperation {
    private final ESServerConfig esServerConfig;
    private SourceInfoDao sourceInfoDao;

    public EsQueryBizOperation(ESServerConfig esServerConfig, SourceInfoDao sourceInfoDao) {
        this.esServerConfig = esServerConfig;
        this.sourceInfoDao = sourceInfoDao;
    }

    public ResponseData runOpt(BizModel bizModel, JSONObject bizOptJson, DataOptContext dataOptContext) throws Exception {
        boolean indexFile;
        BizModelJSONTransform transform = new BizModelJSONTransform(bizModel);
        int pageNo = NumberBaseOpt.castObjectToInteger((Object)transform.attainExpressionValue(bizOptJson.getString("pageNo")), (Integer)1);
        int pageSize = NumberBaseOpt.castObjectToInteger((Object)transform.attainExpressionValue(bizOptJson.getString("pageSize")), (Integer)20);
        String indexType = bizOptJson.getString("indexType");
        if ("custom".equals(indexType)) {
            return this.customQueryOperation(bizModel, bizOptJson, transform, pageNo, pageSize);
        }
        HashMap<String, Object> queryParam = new HashMap<String, Object>(6);
        queryParam.put("osId", dataOptContext.getOsId());
        if (!bizOptJson.getBoolean("queryAll").booleanValue()) {
            Object optTag = transform.attainExpressionValue(bizOptJson.getString("optTag"));
            Object unitCode = transform.attainExpressionValue(bizOptJson.getString("unitCode"));
            Object userCode = transform.attainExpressionValue(bizOptJson.getString("userCode"));
            if (optTag != null) {
                queryParam.put("optTag", optTag);
            }
            if (unitCode != null) {
                queryParam.put("unitCode", unitCode);
            }
            if (userCode != null) {
                queryParam.put("userCode", userCode);
            }
        }
        ESSearcher esSearcher = (indexFile = "indexFile".equals(indexType)) ? IndexerSearcherFactory.obtainSearcher((ESServerConfig)this.esServerConfig, FileDocument.class) : IndexerSearcherFactory.obtainSearcher((ESServerConfig)this.esServerConfig, ObjectDocument.class);
        String keyword = StringBaseOpt.castObjectToString((Object)transform.attainExpressionValue(bizOptJson.getString("queryParameter")));
        if (StringUtils.isBlank((CharSequence)keyword)) {
            return ResponseData.makeErrorMessage((String)"\u67e5\u8be2\u5173\u952e\u5b57\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryBuilder queryBuilder = this.queryBuilder(queryParam, keyword, indexFile, esSearcher, bizOptJson, transform);
        String[] excludes = null;
        if (!bizOptJson.getBoolean("returnAllField").booleanValue()) {
            excludes = new String[]{"content"};
        }
        Pair search = esSearcher.esSearch(queryBuilder, null, excludes, pageNo, pageSize);
        PageDesc pageDesc = new PageDesc();
        pageDesc.setPageNo(pageNo);
        pageDesc.setPageSize(pageSize);
        pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)search.getLeft()));
        PageQueryResult result = PageQueryResult.createResult((Collection)((Collection)search.getRight()), (PageDesc)pageDesc);
        DataSet dataSet = new DataSet((Object)result);
        bizModel.putDataSet(bizOptJson.getString("id"), dataSet);
        return BuiltInOperation.createResponseSuccessData((int)dataSet.getSize());
    }

    private QueryBuilder queryBuilder(Map<String, Object> queryParam, String keyword, Boolean indexFile, ESSearcher esSearcher, JSONObject bizOptJson, BizModelJSONTransform transform) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (queryParam != null) {
            for (Map.Entry<String, Object> entry : queryParam.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (StringUtils.isBlank((CharSequence)key) || value == null) continue;
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)key, (Object[])new Object[]{value}));
            }
        }
        esSearcher.initTypeFields(indexFile != false ? FileDocument.class : ObjectDocument.class);
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            MultiMatchQueryBuilder multiMatchQueryBuilder = QueryBuilders.multiMatchQuery((Object)keyword, (String[])esSearcher.getQueryFields());
            Boolean custom = bizOptJson.getBoolean("custom");
            if (custom.booleanValue()) {
                String analyzer = StringBaseOpt.castObjectToString((Object)transform.attainExpressionValue(bizOptJson.getString("analyzer")));
                String minimumShouldMatch = StringBaseOpt.castObjectToString((Object)transform.attainExpressionValue(bizOptJson.getString("minimumShouldMatch")));
                if (StringUtils.isNotBlank((CharSequence)analyzer)) {
                    multiMatchQueryBuilder.analyzer(analyzer);
                }
                if (StringUtils.isNotBlank((CharSequence)minimumShouldMatch)) {
                    multiMatchQueryBuilder.minimumShouldMatch(minimumShouldMatch);
                }
            }
            boolQueryBuilder.must((QueryBuilder)multiMatchQueryBuilder);
        }
        return boolQueryBuilder;
    }

    private ResponseData customQueryOperation(BizModel bizModel, JSONObject bizOptJson, BizModelJSONTransform transform, Integer pageNo, Integer pageSize) throws Exception {
        Object queryWord;
        String databaseCode = BuiltInOperation.getJsonFieldString((JSONObject)bizOptJson, (String)"databaseName", null);
        SourceInfo esInfo = this.sourceInfoDao.getDatabaseInfoById(databaseCode);
        String indexName = BuiltInOperation.getJsonFieldString((JSONObject)bizOptJson, (String)"indexName", null);
        if (StringUtils.isBlank((CharSequence)indexName)) {
            return ResponseData.makeErrorMessage((String)"\u8bf7\u6307\u5b9a\u7d22\u5f15\u540d\u79f0\uff01");
        }
        BizModelJSONTransform bizModelJSONTransform = new BizModelJSONTransform(bizModel);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        JSONArray filterList = bizOptJson.getJSONArray("filterList");
        if (filterList != null) {
            for (int i = 0; i < filterList.size(); ++i) {
                JSONObject filterInfo = filterList.getJSONObject(i);
                Object filterValue = JSONTransformer.transformer((Object)filterInfo.getString("filterValue"), (JSONTransformDataSupport)bizModelJSONTransform);
                if (filterValue == null) continue;
                String columnName = filterInfo.getString("filterColumnName");
                this.timeProcessing(columnName, filterValue, boolQueryBuilder);
            }
        }
        JSONArray queryColumns = bizOptJson.getJSONArray("queryColumns");
        String[] queryColumnList = null;
        if (queryColumns != null) {
            queryColumnList = new String[queryColumns.size()];
            for (int i = 0; i < queryColumns.size(); ++i) {
                queryColumnList[i] = queryColumns.getJSONObject(i).getString("queryColumnName");
            }
        }
        if ((queryWord = JSONTransformer.transformer((Object)bizOptJson.getString("queryParameter"), (JSONTransformDataSupport)bizModelJSONTransform)) != null) {
            MultiMatchQueryBuilder multiMatchQueryBuilder = queryColumnList != null && queryColumnList.length > 0 ? QueryBuilders.multiMatchQuery((Object)queryWord, (String[])queryColumnList) : QueryBuilders.multiMatchQuery((Object)queryWord, (String[])new String[0]);
            int minimumShouldMatch = bizOptJson.getIntValue("minimumShouldMath");
            if (minimumShouldMatch > 0) {
                multiMatchQueryBuilder.minimumShouldMatch(minimumShouldMatch + "%");
            }
            boolQueryBuilder.must((QueryBuilder)multiMatchQueryBuilder);
        } else {
            MatchAllQueryBuilder matchAllQueryBuilder = QueryBuilders.matchAllQuery();
            boolQueryBuilder.must((QueryBuilder)matchAllQueryBuilder);
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        JSONArray sortColumns = bizOptJson.getJSONArray("sortColumns");
        ArrayList<FieldSortBuilder> sorts = new ArrayList<FieldSortBuilder>();
        if (sortColumns != null) {
            for (int i = 0; i < sortColumns.size(); ++i) {
                JSONObject sortField = sortColumns.getJSONObject(i);
                String sortColumnName = sortField.getString("sortColumnName");
                Object sortValue = transform.attainExpressionValue(sortField.getString("sortValue"));
                if (!StringUtils.isNotBlank((CharSequence)sortColumnName) || sortValue == null) continue;
                FieldSortBuilder order = (FieldSortBuilder)SortBuilders.fieldSort((String)sortColumnName).order("DESC".equals(sortValue) ? SortOrder.DESC : SortOrder.ASC);
                sorts.add(order);
            }
        }
        searchSourceBuilder.sort(sorts);
        searchSourceBuilder.from((pageNo - 1) * pageSize);
        searchSourceBuilder.size(pageSize.intValue());
        searchSourceBuilder.trackTotalHits(true);
        searchSourceBuilder.explain(Boolean.valueOf(false));
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        if (queryColumnList != null && queryColumnList.length > 0) {
            for (int i = 0; i < queryColumnList.length; ++i) {
                highlightBuilder.field(queryColumnList[i]);
            }
        }
        String color = StringBaseOpt.castObjectToString((Object)bizOptJson.getString("color"), (String)"red");
        if (highlightBuilder.fields().size() > 0) {
            ((HighlightBuilder)highlightBuilder.preTags(new String[]{"<span style='color:" + color + "'>"})).postTags(new String[]{"</span>"});
            highlightBuilder.highlighterType("unified");
            highlightBuilder.requireFieldMatch(Boolean.valueOf(true));
            highlightBuilder.fragmentSize(Integer.valueOf(800000));
            highlightBuilder.numOfFragments(Integer.valueOf(0));
        }
        searchSourceBuilder.highlighter(highlightBuilder);
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        searchRequest.source(searchSourceBuilder);
        RestHighLevelClient esClient = AbstractSourceConnectThreadHolder.fetchESClient((ISourceInfo)esInfo);
        SearchResponse searchResponse = esClient.search(searchRequest, RequestOptions.DEFAULT);
        JSONObject returnData = new JSONObject();
        if (searchSourceBuilder.highlighter() != null && searchSourceBuilder.highlighter().fields().size() > 0) {
            returnData.put("data", (Object)EsQueryBizOperation.returnHighlightResult(searchResponse, queryColumnList, true));
        } else {
            returnData.put("data", (Object)EsQueryBizOperation.resultPart(searchResponse, true));
        }
        returnData.put("pageInfo", (Object)EsQueryBizOperation.pageInfo(indexName, pageNo, pageSize, (QueryBuilder)boolQueryBuilder, esClient));
        String id = bizOptJson.getString("id");
        bizModel.putDataSet(id, new DataSet((Object)returnData));
        return ResponseData.makeResponseData((Object)returnData.getJSONArray("data").size());
    }

    private static JSONArray returnHighlightResult(SearchResponse searchResponse, String[] queryColumnList, Boolean explain) {
        JSONArray jsonArray = new JSONArray();
        for (SearchHit hit : searchResponse.getHits()) {
            JSONObject jsonObject = JSON.parseObject((String)hit.getSourceAsString());
            if (explain.booleanValue()) {
                jsonObject.put("explain_info", (Object)hit.getExplanation());
            }
            Map highlightFields = hit.getHighlightFields();
            for (String fieldName : queryColumnList) {
                HighlightField field = (HighlightField)highlightFields.get(fieldName);
                if (field == null) continue;
                Text[] fragments = field.fragments();
                String n_field = "";
                for (Text fragment : fragments) {
                    n_field = n_field + fragment;
                }
                jsonObject.put(fieldName, (Object)n_field);
            }
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }

    private static JSONArray resultPart(SearchResponse searchResponse, Boolean explain) {
        JSONArray resultArrays = new JSONArray();
        if (RestStatus.OK.equals((Object)searchResponse.status()) && searchResponse.getHits().getTotalHits().value > 0L) {
            for (SearchHit hit : searchResponse.getHits()) {
                JSONObject jsonObject = JSONObject.parseObject((String)hit.getSourceAsString());
                if (explain.booleanValue()) {
                    jsonObject.put("explain_info", (Object)hit.getExplanation());
                }
                resultArrays.add((Object)jsonObject);
            }
        }
        return resultArrays;
    }

    private static JSONObject pageInfo(String indexName, int pageNo, int pageSize, QueryBuilder queryBuilder, RestHighLevelClient restHighLevelClient) throws IOException {
        CountRequest countRequest = new CountRequest(new String[]{indexName});
        SearchSourceBuilder countSearchSourceBuilder = new SearchSourceBuilder();
        countSearchSourceBuilder.query(queryBuilder);
        countRequest.source(countSearchSourceBuilder);
        CountResponse countResponse = restHighLevelClient.count(countRequest, RequestOptions.DEFAULT);
        int totalCount = (int)countResponse.getCount();
        int pagesTotal = totalCount == 0 ? 0 : (totalCount % pageSize == 0 ? totalCount / pageSize : totalCount / pageSize + 1);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("pageNo", (Object)pageNo);
        jsonObject.put("pageSize", (Object)pageSize);
        jsonObject.put("totalCount", (Object)totalCount);
        jsonObject.put("pageTotal", (Object)pagesTotal);
        return jsonObject;
    }

    private void timeProcessing(String field, Object filterValue, BoolQueryBuilder boolQueryBuilder) {
        String fieldSuffix = field.substring(field.length() - 3).toLowerCase();
        String fieldName = field;
        if (field.endsWith("_gt") || field.endsWith("_ge") || field.endsWith("_lt") || field.endsWith("_le")) {
            fieldName = field.substring(0, field.length() - 4);
        }
        switch (fieldSuffix) {
            case "_gt": {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)fieldName).gt(filterValue));
                break;
            }
            case "_ge": {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)fieldName).gte(filterValue));
                break;
            }
            case "_lt": {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)fieldName).lt(filterValue));
                break;
            }
            case "_le": {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)fieldName).lte(filterValue));
                break;
            }
            default: {
                if (filterValue.getClass().isArray()) {
                    List value = CollectionsOpt.arrayToList((Object[])((Object[])filterValue));
                    TermsQueryBuilder termsQuery = QueryBuilders.termsQuery((String)fieldName, (Collection)value);
                    boolQueryBuilder.must((QueryBuilder)termsQuery);
                    break;
                }
                TermQueryBuilder termQuery = QueryBuilders.termQuery((String)fieldName, (Object)filterValue);
                boolQueryBuilder.must((QueryBuilder)termQuery);
            }
        }
    }
}

