/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.agent.service;

import com.centit.dde.agent.service.RunTaskJob;
import com.centit.dde.dao.DataPacketDao;
import com.centit.dde.po.DataPacket;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.model.adapter.OperationLogWriter;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.quartz.QuartzJobUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.binary.Hex;
import org.quartz.CronTrigger;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class TaskSchedulers {
    private final DataPacketDao dataPacketDao;
    private final Scheduler scheduler;
    private final OperationLogWriter operationLogWriter;
    private String taskMd5;

    @Autowired
    public TaskSchedulers(DataPacketDao dataPacketDao, Scheduler scheduler, OperationLogWriter operationLogWriter) {
        this.dataPacketDao = dataPacketDao;
        this.scheduler = scheduler;
        this.operationLogWriter = operationLogWriter;
    }

    private boolean isEqualMd5(List<DataPacket> list) {
        boolean result = false;
        StringBuilder sList = new StringBuilder();
        for (DataPacket i : list) {
            sList.append(i.getTaskCron());
        }
        String taskMd5 = "";
        try {
            int length;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            ByteArrayInputStream is = new ByteArrayInputStream(sList.toString().getBytes());
            while ((length = is.read(buffer)) != -1) {
                md5.update(buffer, 0, length);
            }
            taskMd5 = new String(Hex.encodeHex((byte[])md5.digest()));
        }
        catch (IOException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        if (taskMd5.equals(this.taskMd5)) {
            result = true;
        } else {
            this.taskMd5 = taskMd5;
        }
        return result;
    }

    private void refreshTask() throws SchedulerException {
        List list = this.dataPacketDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"taskType", "2", "isValid", "T"}));
        if (this.isEqualMd5(list)) {
            return;
        }
        Set triggerKeys = this.scheduler.getTriggerKeys(GroupMatcher.anyTriggerGroup());
        for (DataPacket ll : list) {
            if ("".equals(ll.getTaskCron()) || ll.getTaskCron() == null) continue;
            int i = 0;
            for (TriggerKey tKey : triggerKeys) {
                if (!tKey.getName().equals(ll.getPacketId())) continue;
                ++i;
                CronTrigger quatrzTrigger = (CronTrigger)this.scheduler.getTrigger(tKey);
                if (quatrzTrigger.getCronExpression().equals(ll.getTaskCron())) break;
                QuartzJobUtils.createOrReplaceCronJob((Scheduler)this.scheduler, (String)ll.getPacketId(), (String)ll.getPacketName(), (String)"task", (String)ll.getTaskCron(), (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"taskExchange", ll}));
                break;
            }
            if (i != 0) continue;
            QuartzJobUtils.createOrReplaceCronJob((Scheduler)this.scheduler, (String)ll.getPacketId(), (String)ll.getPacketName(), (String)"task", (String)ll.getTaskCron(), (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"taskExchange", ll}));
        }
        for (TriggerKey tKey : triggerKeys) {
            boolean found = false;
            for (DataPacket ll : list) {
                TriggerKey triggerKey = TriggerKey.triggerKey((String)ll.getPacketId(), (String)ll.getPacketName());
                if (!tKey.equals((Object)triggerKey)) continue;
                found = true;
                break;
            }
            if (found) continue;
            QuartzJobUtils.deleteJob((Scheduler)this.scheduler, (String)tKey.getName(), (String)tKey.getGroup());
        }
    }

    @PostConstruct
    public void init() throws SchedulerException {
        OperationLogCenter.initOperationLogWriter((OperationLogWriter)this.operationLogWriter);
        QuartzJobUtils.registerJobType((String)"task", RunTaskJob.class);
        this.scheduler.start();
    }

    @Scheduled(fixedDelay=50000L)
    public void work() throws SchedulerException {
        this.refreshTask();
    }
}

