/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.adapter.po;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.support.common.LeftRightPair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataOptStep {
    protected static final Logger logger = LoggerFactory.getLogger(DataOptStep.class);
    private Map<String, JSONObject> nodeMap = new HashMap<String, JSONObject>(50);
    private Map<String, List<JSONObject>> linkMap = new HashMap<String, List<JSONObject>>(100);
    private JSONObject currentStep;
    private int stepNo = 0;

    public DataOptStep(Map<String, JSONObject> nodeMap, Map<String, List<JSONObject>> linkMap) {
        this.nodeMap.putAll(nodeMap);
        this.linkMap.putAll(linkMap);
    }

    public DataOptStep(JSONObject dataOptJson) {
        this.mapData(dataOptJson);
    }

    private void mapData(JSONObject dataOptJson) {
        JSONArray nodes = dataOptJson.getJSONArray("nodes");
        for (Object obj : nodes) {
            if (!(obj instanceof JSONObject)) continue;
            JSONObject nodeJson = (JSONObject)obj;
            this.nodeMap.put(nodeJson.getString("id"), nodeJson);
        }
        JSONArray links = dataOptJson.getJSONArray("edges");
        for (Object obj : links) {
            if (!(obj instanceof JSONObject)) continue;
            JSONObject linkJson = (JSONObject)obj;
            String sourceId = (linkJson = linkJson.getJSONObject("properties")).getString("sourceId");
            List<JSONObject> nextNodes = this.linkMap.get(sourceId);
            if (nextNodes != null) {
                nextNodes.add(linkJson);
                continue;
            }
            ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
            jsonObjects.add(linkJson);
            this.linkMap.put(linkJson.getString("sourceId"), jsonObjects);
        }
    }

    public void setStartStep() {
        for (Map.Entry<String, JSONObject> m : this.nodeMap.entrySet()) {
            if (!"start".equals(m.getValue().getString("type"))) continue;
            this.currentStep = this.getOptStep(m.getKey());
            return;
        }
        this.setEndStep();
    }

    public JSONObject getOptStep(String id) {
        return this.nodeMap.get(id);
    }

    public void setEndStep() {
        this.currentStep = this.createEmptyObject();
        ++this.stepNo;
    }

    public List<JSONObject> getNextLinks(String id) {
        return this.linkMap.get(id);
    }

    public void seekToCycleEnd(String id) {
        HashSet<String> hasAddedNode = new HashSet<String>();
        ArrayDeque<LeftRightPair> brachNode = new ArrayDeque<LeftRightPair>();
        hasAddedNode.add(id);
        String curId = id;
        int cascade = 0;
        while (true) {
            List<JSONObject> nexts;
            if ((nexts = this.linkMap.get(curId)) != null && nexts.size() > 0) {
                for (JSONObject n : nexts) {
                    String nId = n.getString("targetId");
                    if (hasAddedNode.contains(nId)) continue;
                    hasAddedNode.add(nId);
                    JSONObject nextNode = this.nodeMap.get(n.getString("targetId"));
                    String stepType = nextNode.getString("type");
                    if ("finishCycle".equals(stepType)) {
                        if (cascade == 0) {
                            this.setCurrentStep(nextNode);
                            return;
                        }
                        brachNode.push(new LeftRightPair((Object)nId, (Object)(cascade - 1)));
                        continue;
                    }
                    if ("cycle".equals(stepType)) {
                        brachNode.push(new LeftRightPair((Object)nId, (Object)(cascade + 1)));
                        continue;
                    }
                    brachNode.push(new LeftRightPair((Object)nId, (Object)cascade));
                }
            }
            if (brachNode.isEmpty()) break;
            LeftRightPair branch = (LeftRightPair)brachNode.pop();
            curId = (String)branch.getLeft();
            cascade = (Integer)branch.getRight();
        }
        this.setEndStep();
    }

    public JSONObject getCurrentStep() {
        return this.currentStep;
    }

    public void setNextStep() {
        if (!this.isEndStep()) {
            this.setCurrentStep(this.getNextStep(this.currentStep.getString("id")));
        }
    }

    public JSONObject getNextStep(String id) {
        List<JSONObject> links = this.getNextLinks(id);
        if (links == null || links.size() == 0) {
            logger.error("\u5f53\u524d\u8282\u70b9(" + id + ")\u6ca1\u6709\u6709\u6548\u7684\u540e\u7eed\u8282\u70b9\u3002");
            return this.createEmptyObject();
        }
        if (links.size() > 1) {
            logger.error("\u5f53\u524d\u8282\u70b9(" + id + ")\u6709\u591a\u4e2a\u540e\u7eed\u8282\u70b9\u3002");
            return this.createEmptyObject();
        }
        return this.getOptStep(links.get(0).getString("targetId"));
    }

    private JSONObject createEmptyObject() {
        return new JSONObject();
    }

    public boolean isEndStep() {
        if (this.currentStep == null) {
            return true;
        }
        return this.currentStep.isEmpty();
    }

    public void setCurrentStep(JSONObject currentStep) {
        this.currentStep = currentStep;
        ++this.stepNo;
    }

    public int getStepNo() {
        return this.stepNo;
    }

    public Map<String, JSONObject> getNodeMap() {
        return this.nodeMap;
    }

    public Map<String, List<JSONObject>> getLinkMap() {
        return this.linkMap;
    }
}

