/*
 * Decompiled with CFR 0.152.
 */
package com.centit.locode.platform.controller;

import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.locode.platform.po.HistoryVersion;
import com.centit.locode.platform.service.HistoryVersionService;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.json.JSONOpt;
import com.centit.support.json.JsonDifferent;
import com.centit.support.security.SecurityOptUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u5386\u53f2\u7248\u672c\u7ba1\u7406", tags={"\u5386\u53f2\u7248\u672c\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/history"})
public class HistoryVersionController
extends BaseController {
    @Autowired
    private HistoryVersionService historyVersionService;

    @ApiOperation(value="\u65b0\u589e\u7248\u672c\u4fe1\u606f")
    @PostMapping
    @WrapUpResponseBody
    public String createHistoryVersion(@RequestBody String hvJsonStr) {
        HistoryVersion historyVersion = (HistoryVersion)JSONObject.parseObject((String)SecurityOptUtils.decodeSecurityString((String)hvJsonStr), HistoryVersion.class);
        historyVersion.setRelationId(historyVersion.getRelationId().trim());
        historyVersion.setHistorySha(historyVersion.generateHistorySha());
        if (this.historyVersionService.countHistoryVersion(historyVersion.getRelationId(), historyVersion.getHistorySha()) > 0) {
            throw new ObjectException(702, "\u5b58\u5728\u76f8\u540c\u7684\u7248\u672c\uff0c\u65e0\u9700\u518d\u6b21\u521b\u5efa\u3002sha\uff1a" + historyVersion.getHistorySha());
        }
        historyVersion.setAppVersionId(null);
        this.historyVersionService.createHistoryVersion(historyVersion);
        return historyVersion.getHistoryId();
    }

    @ApiOperation(value="\u4fee\u6539\u7248\u672c\u4fe1\u606f")
    @PutMapping
    @WrapUpResponseBody
    public void updateHistory(@RequestBody HistoryVersion historyVersion) {
        HistoryVersion dbVersion = this.historyVersionService.getHistoryVersion(historyVersion.getHistoryId());
        if (dbVersion == null) {
            throw new ObjectException(611, "\u9700\u8981\u4fee\u6539\u7684\u7248\u672c\u4fe1\u606f\u4e0d\u5b58\u5728!");
        }
        if (StringUtils.isNotBlank((CharSequence)dbVersion.getAppVersionId())) {
            throw new ObjectException(611, "\u5e94\u7528\u5168\u5c40\u7248\u672c\uff0c\u4e0d\u80fd\u4fee\u6539!");
        }
        historyVersion.setContent(null);
        historyVersion.setAppVersionId(null);
        this.historyVersionService.updateHistoryVersion(historyVersion);
    }

    @ApiOperation(value="\u5220\u9664\u7248\u672c\u4fe1\u606f")
    @DeleteMapping(value={"/{historyId}"})
    @WrapUpResponseBody
    public void deleteHistory(@PathVariable String historyId) {
        HistoryVersion dbVersion = this.historyVersionService.getHistoryVersion(historyId);
        if (dbVersion == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)dbVersion.getAppVersionId())) {
            throw new ObjectException(611, "\u5e94\u7528\u5168\u5c40\u7248\u672c\uff0c\u4e0d\u80fd\u5220\u9664!");
        }
        this.historyVersionService.deleteHistoryVersion(historyId);
    }

    @ApiOperation(value="\u67e5\u8be2\u7248\u672c\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/list"})
    @WrapUpResponseBody
    public PageQueryResult<HistoryVersion> listHistory(HttpServletRequest request, PageDesc pageDesc) {
        List<HistoryVersion> list = this.historyVersionService.listHistoryVersion(BaseController.collectRequestParameters((HttpServletRequest)request), pageDesc);
        return PageQueryResult.createResult(list, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u7248\u672c\u4fe1\u606f")
    @GetMapping(value={"/{historyId}"})
    @WrapUpResponseBody
    public HistoryVersion getHistory(@PathVariable String historyId) {
        return this.historyVersionService.getHistoryVersion(historyId);
    }

    @ApiOperation(value="\u548c\u5386\u53f2\u7248\u672c\u5bf9\u6bd4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="historyId", type="path", value="\u5386\u53f2\u7248\u672c\u4fe1\u606f"), @ApiImplicitParam(name="jsonType", type="param", paramType="String", value="\u8fd4\u56de\u7ed3\u679c\u673a\u6784 tree / object"), @ApiImplicitParam(name="currentVersion", type="body", value="\u5f53\u524d\u7248\u672c\u4fe1\u606f\uff0c\u4e00\u822c\u662f\u8349\u7a3f\u4fe1\u606f", dataTypeClass=HistoryVersion.class)})
    @PostMapping(value={"/compare/{historyId}"})
    @WrapUpResponseBody
    public JSONObject compareHistoryVersion(@PathVariable String historyId, @RequestBody HistoryVersion currentVersion, String jsonType) {
        HistoryVersion historyVersion = this.historyVersionService.getHistoryVersion(historyId);
        if (historyVersion == null || historyVersion.getContent() == null || currentVersion.getContent() == null) {
            throw new ObjectException(611, "\u7248\u672c\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u53c2\u6570");
        }
        JsonDifferent jsonDiff = JSONOpt.diff((Object)currentVersion.getContent(), (Object)historyVersion.getContent(), (String[])new String[]{"$item.id", "id"});
        if ("tree".equals(jsonType)) {
            return JSONObject.from((Object)jsonDiff);
        }
        return jsonDiff.toJSONObject();
    }

    @ApiOperation(value="\u4e24\u4e2a\u5386\u53f2\u7248\u672c\u5bf9\u6bd4")
    @ApiImplicitParams(value={@ApiImplicitParam, @ApiImplicitParam(name="jsonType", type="param", paramType="String", value="\u8fd4\u56de\u7ed3\u679c\u673a\u6784 tree / object"), @ApiImplicitParam(name="versionInfo", type="body", value="\u4e24\u4e2a\u5386\u53f2\u7248\u672c\u4fe1\u606f\uff0c{'version1':'v1', 'version2':'v2'}")})
    @PostMapping(value={"/compareHistory"})
    @WrapUpResponseBody
    public JSONObject compareHistoryVersion(@RequestBody String versionInfo, String jsonType) {
        JSONObject versionJson = JSONObject.parseObject((String)versionInfo);
        String v1 = versionJson.getString("version1");
        String v2 = versionJson.getString("version2");
        if (StringUtils.isBlank((CharSequence)v1) || StringUtils.isBlank((CharSequence)v2)) {
            throw new ObjectException(611, "\u7248\u672c\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u53c2\u6570");
        }
        HistoryVersion currentVersion = this.historyVersionService.getHistoryVersion(v1);
        HistoryVersion historyVersion = this.historyVersionService.getHistoryVersion(v2);
        if (historyVersion.getContent() == null || currentVersion.getContent() == null) {
            throw new ObjectException(611, "\u7248\u672c\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u53c2\u6570");
        }
        JsonDifferent jsonDiff = JSONOpt.diff((Object)currentVersion.getContent(), (Object)historyVersion.getContent(), (String[])new String[]{"$item.id", "id"});
        if ("tree".equals(jsonType)) {
            return JSONObject.from((Object)jsonDiff);
        }
        return jsonDiff.toJSONObject();
    }
}

