/*
 * Decompiled with CFR 0.152.
 */
package com.centit.locode.platform.controller;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONReader;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.locode.platform.po.AppMergeTask;
import com.centit.locode.platform.po.ApplicationVersion;
import com.centit.locode.platform.service.ApplicationVersionService;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/appHistory"})
@Api(tags={"\u5e94\u7528\u7684\u5168\u5c40\u5386\u53f2\u7248\u672c\u7ba1\u7406\u63a5\u53e3"}, value="\u5e94\u7528\u7684\u5168\u5c40\u5386\u53f2\u7248\u672c\u7ba1\u7406\u63a5\u53e3")
public class ApplicationVersionController
extends BaseController {
    @Autowired
    ApplicationVersionService applicationVersionService;

    @ApiOperation(value="\u5217\u4e3e\u6240\u6709\u5386\u53f2\u7248\u672c", notes="\u5217\u4e3e\u6240\u6709\u5386\u53f2\u7248\u672c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="osId", value="\u5e94\u7528ID\uff0capplication Id", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\uff0c\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="query", dataTypeClass=PageDesc.class)})
    @GetMapping(value={"list/{osId}"})
    @WrapUpResponseBody
    public PageQueryResult<ApplicationVersion> list(@PathVariable String osId, PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = ApplicationVersionController.collectRequestParameters((HttpServletRequest)request);
        List<ApplicationVersion> appVers = this.applicationVersionService.listApplicationVersion(osId, pageDesc, searchColumn);
        return PageQueryResult.createResultMapDict(appVers, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u521b\u5efa\u5386\u53f2\u7248\u672c", notes="\u521b\u5efa\u5386\u53f2\u7248\u672c")
    @PostMapping
    @WrapUpResponseBody
    public String createHistoryVersion(@RequestBody ApplicationVersion appVersion, HttpServletRequest request) {
        UserInfo userInfo = WebOptUtils.assertUserLogin((HttpServletRequest)request);
        if (this.applicationVersionService.checkMergeState(appVersion.getApplicationId())) {
            throw new ObjectException(611, "\u5f53\u524d\u5e94\u7528\u6709\u6b63\u5728\u5408\u5e76\u4e2d\u7684\u7248\u672c\uff0c\u8bf7\u7b49\u5f85\u5408\u5e76\u5b8c\u6210\u540e\u518d\u521b\u5efa\u65b0\u7248\u672c\uff01");
        }
        appVersion.setCreator(userInfo.getUserCode());
        return this.applicationVersionService.createApplicationVersion(appVersion);
    }

    @ApiOperation(value="\u66f4\u6539\u5386\u53f2\u7248\u672c\u4fe1\u606f", notes="\u66f4\u6539\u5386\u53f2\u7248\u672c\u4fe1\u606f")
    @PutMapping
    @WrapUpResponseBody
    public void updateHistoryVersion(@RequestBody ApplicationVersion appVersion) {
        this.applicationVersionService.updateApplicationVersion(appVersion);
    }

    @ApiOperation(value="\u6bd4\u8f83\u5386\u53f2\u7248\u672c", notes="\u6bd4\u8f83\u5386\u53f2\u7248\u672c")
    @GetMapping(value={"compare/{versionId}/{versionId2}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="versionId", value="\u5386\u53f2\u7248\u672c\u53f7", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="versionId2", value="\u5386\u53f2\u7248\u672c\u53f72", required=true, paramType="path", dataType="String")})
    @WrapUpResponseBody
    public JSONArray compareHistoryVersion(@PathVariable String versionId, @PathVariable String versionId2) {
        return this.applicationVersionService.compareTwoVersion(versionId, versionId2);
    }

    @ApiOperation(value="\u548c\u6700\u65b0\u7684\u5185\u5bb9\u5bf9\u6bd4", notes="\u548c\u6700\u65b0\u7684\u5185\u5bb9\u5bf9\u6bd4")
    @GetMapping(value={"diff/{osId}/{versionId}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="osId", value="\u5e94\u7528ID\uff0capplication Id", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="versionId", value="\u5386\u53f2\u7248\u672c\u53f7", required=true, paramType="path", dataType="String")})
    @WrapUpResponseBody
    public JSONArray compareToOldVersion(@PathVariable String osId, @PathVariable String versionId) {
        return this.applicationVersionService.compareToOldVersion(osId, versionId);
    }

    @ApiOperation(value="\u5220\u9664\u5386\u53f2\u7248\u672c", notes="\u5220\u9664\u5386\u53f2\u7248\u672c")
    @DeleteMapping(value={"{versionId}"})
    @ApiImplicitParam(name="versionId", value="\u5386\u53f2\u7248\u672c\u53f7", required=true, paramType="path", dataType="String")
    @WrapUpResponseBody
    public void deleteHistoryVersion(@PathVariable String versionId) {
        this.applicationVersionService.deleteApplicationVersion(versionId);
    }

    @ApiOperation(value="\u67e5\u770b\u5386\u53f2\u7248\u672c\u4e2d\u7684\u6587\u4ef6", notes="\u67e5\u770b\u5386\u53f2\u7248\u672c\u4e2d\u7684\u6587\u4ef6")
    @GetMapping(value={"view/{objType}/{appVersionId}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="objType", value="\u7c7b\u578b\uff1a1\uff1a\u5de5\u4f5c\u6d41 2\uff1a\u9875\u9762\u8bbe\u8ba1 3\uff1aapi\u7f51\u5173", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="appVersionId", value="\u5386\u53f2\u7248\u672c\u53f7", required=true, paramType="path", dataType="String")})
    @WrapUpResponseBody
    public PageQueryResult<Object> viewObjectByType(@PathVariable String objType, @PathVariable String appVersionId, PageDesc pageDesc) {
        JSONArray objs = this.applicationVersionService.listAppComponents(appVersionId, objType, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)objs, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u6062\u590d\uff08\u56de\u9000\uff09\u5386\u53f2\u7248\u672c", notes="\u56de\u9000\u540e\u8c03\u7528mergeTask\u67e5\u770b\u66f4\u65b0\u5185\u5bb9")
    @PostMapping(value={"/restore/{appVersionId}"})
    @ApiImplicitParam(name="appVersionId", value="\u5386\u53f2\u7248\u672c\u53f7", required=true, paramType="path", dataType="String")
    @WrapUpResponseBody
    public int restoreAppVersion(@PathVariable String appVersionId, HttpServletRequest request) {
        UserInfo userInfo = WebOptUtils.assertUserLogin((HttpServletRequest)request);
        return this.applicationVersionService.restoreAppVersion(appVersionId, userInfo.getUserCode());
    }

    @ApiOperation(value="\u5408\u5e76\u5386\u53f2\u7248\u672c\u4e2d\u7684\u90e8\u5206\u9875\u9762\u3001\u63a5\u53e3\u548c\u6d41\u7a0b", notes="\u5408\u5e76\u540e\u8c03\u7528mergeTask\u67e5\u770b\u66f4\u65b0\u5185\u5bb9")
    @PostMapping(value={"/merge/{appVersionId}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="appVersionId", value="\u5386\u53f2\u7248\u672c\u53f7", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="components", value="\u9009\u4e2d\u7684\u5bf9\u8c61\uff0c\u5c5e\u6027\u5305\u62ec mergeTask\u4e2d\u8fd4\u56de\u7684 historyId \u5373\u53ef", required=true, paramType="body", dataTypeClass=JSONArray.class)})
    @WrapUpResponseBody
    public int mergeAppComponents(@PathVariable String appVersionId, @RequestBody JSONArray components, HttpServletRequest request) {
        UserInfo userInfo = WebOptUtils.assertUserLogin((HttpServletRequest)request);
        return this.applicationVersionService.mergeAppComponents(appVersionId, components, userInfo.getUserCode());
    }

    @ApiOperation(value="\u67e5\u770b\u5408\u5e76\u5386\u53f2\u7248\u672c\u4e2d\u7684\u66f4\u65b0\u5185\u5bb9", notes="\u67e5\u770b\u5408\u5e76\u5386\u53f2\u7248\u672c\u4e2d\u7684\u66f4\u65b0\u5185\u5bb9")
    @GetMapping(value={"mergeTask/{appVersionId}"})
    @ApiImplicitParam(name="appVersionId", value="\u5386\u53f2\u7248\u672c\u53f7", required=true, paramType="path", dataType="String")
    @WrapUpResponseBody
    public PageQueryResult<AppMergeTask> listMergeTask(@PathVariable String appVersionId, PageDesc pageDesc, HttpServletRequest request) {
        List<AppMergeTask> objs = this.applicationVersionService.listAppMergeTasks(appVersionId, ApplicationVersionController.collectRequestParameters((HttpServletRequest)request), pageDesc);
        return PageQueryResult.createResultMapDict(objs, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u6807\u8bb0\u9875\u9762\u3001\u63a5\u53e3\u3001api\u5408\u5e76\u5b8c\u6210", notes="\u6807\u8bb0\u9875\u9762\u3001\u63a5\u53e3\u3001api\u5408\u5e76\u5b8c\u6210")
    @PutMapping(value={"/mergeCompleted"})
    @WrapUpResponseBody
    public boolean markMergeCompleted(@RequestBody JSONArray tasks, HttpServletRequest request) {
        UserInfo userInfo = WebOptUtils.assertUserLogin((HttpServletRequest)request);
        List appMergeTasks = tasks.toJavaList(AppMergeTask.class, new JSONReader.Feature[0]);
        String appVersionId = ((AppMergeTask)appMergeTasks.get(0)).getAppVersionId();
        for (AppMergeTask task : appMergeTasks) {
            task.setUpdateUser(userInfo.getUserCode());
            this.applicationVersionService.mergeCompleted(task);
        }
        return this.applicationVersionService.checkRestoreCompleted(appVersionId);
    }

    @ApiOperation(value="\u6807\u8bb0\u6062\u590d\u5408\u5e76\u5b8c\u6210", notes="\u6807\u8bb0\u6062\u590d\u5408\u5e76\u5b8c\u6210")
    @PutMapping(value={"/restoreCompleted/{appVersionId}"})
    @ApiImplicitParam(name="appVersionId", value="\u5386\u53f2\u7248\u672c\u53f7", required=true, paramType="path", dataType="String")
    @WrapUpResponseBody
    public void markRestoreCompleted(@PathVariable String appVersionId, HttpServletRequest request) {
        WebOptUtils.assertUserLogin((HttpServletRequest)request);
        this.applicationVersionService.restoreCompleted(appVersionId);
    }

    @ApiOperation(value="\u56de\u6eda\u4e00\u4e2a\u5bf9\u8c61\uff0c\u9875\u9762\u3001\u63a5\u53e3\u6216\u8005\u6d41\u7a0b", notes="\u56de\u6eda\u4e00\u4e2a\u5bf9\u8c61\uff0c\u9875\u9762\u3001\u63a5\u53e3\u6216\u8005\u6d41\u7a0b")
    @PutMapping(value={"/rollback"})
    @WrapUpResponseBody
    public boolean rollbackMergeTask(@RequestBody JSONArray tasks, HttpServletRequest request) {
        UserInfo userInfo = WebOptUtils.assertUserLogin((HttpServletRequest)request);
        List appMergeTasks = tasks.toJavaList(AppMergeTask.class, new JSONReader.Feature[0]);
        String appVersionId = ((AppMergeTask)appMergeTasks.get(0)).getAppVersionId();
        for (AppMergeTask task : appMergeTasks) {
            task.setUpdateUser(userInfo.getUserCode());
            this.applicationVersionService.rollbackMergeTask(task);
        }
        return this.applicationVersionService.checkRestoreCompleted(appVersionId);
    }

    @ApiOperation(value="\u56de\u6eda\u6240\u6709\u7684\u4e3a\u6807\u8bb0\u4e3a\u5df2\u5b8c\u6210\u5408\u5e76\u7684\u5bf9\u8c61", notes="\u56de\u6eda\u6240\u6709\u7684\u4e3a\u6807\u8bb0\u4e3a\u5df2\u5b8c\u6210\u5408\u5e76\u7684\u5bf9\u8c61")
    @PutMapping(value={"/rollbackAll/{appVersionId}"})
    @ApiImplicitParam(name="appVersionId", value="\u5386\u53f2\u7248\u672c\u53f7", required=true, paramType="path", dataType="String")
    @WrapUpResponseBody
    public void rollbackRestore(@PathVariable String appVersionId, HttpServletRequest request) {
        WebOptUtils.assertUserLogin((HttpServletRequest)request);
        this.applicationVersionService.rollbackRestore(appVersionId);
    }
}

