package com.centit.framework.jlwater.controller;

import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.security.CentitUserDetails;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;


@Controller
@RequestMapping("/jlwaterca")
@Api(value = "水务相关接口", tags = "水务相关接口")
public class JlwaterCaPlugin extends BaseController {
    @Autowired
    private PlatformEnvironment platformEnvironment;

    @ApiOperation(value = "水务集团单点登陆", notes = "水务集团单点登陆")
    @GetMapping(value = "/login")
    public String waterLogin(HttpServletRequest request, HttpServletResponse response) {
        String returnUrl = request.getParameter("returnUrl");
        String loginName = request.getHeader("oam_remote_user");
        if (null == loginName) {
            loginName = request.getParameter("testLoginName");
        }
        String errorMsg = "";
        CentitUserDetails ud = platformEnvironment.loadUserDetailsByLoginName(loginName);
        if (null != ud) {
            SecurityContextHolder.getContext().setAuthentication(ud);
        } else {
            errorMsg = "登录名" + loginName + "不存在！";
        }
        if (StringUtils.isNotBlank(errorMsg)) {
            String errorUrl = "redirect:redirecterror";
            try {
                errorUrl = errorUrl + "?msg=" + URLEncoder.encode(errorMsg, "UTF-8");
            } catch (UnsupportedEncodingException e) {
                logger.error("URLEncoder异常", e);
            }
            return errorUrl;
        }
        String accessToken = request.getSession().getId();
        if (StringUtils.isNotBlank(returnUrl)) {
            if (returnUrl.contains("/A/")) {
                returnUrl = returnUrl.replace("/A/", "/#/");
            }
            if (returnUrl.contains("?")){
                returnUrl = returnUrl + "&accessToken=" + accessToken;
            } else{
                returnUrl = returnUrl + "?accessToken=" + accessToken;
            }
        }
        response.setHeader("x-auth-token", accessToken);
        return "redirect:" + returnUrl;
    }
}
